document.addEventListener("DOMContentLoaded", function () {
    const { __ } = wp.i18n;

    const params = new URLSearchParams(window.location.search),
        checkparams = params.get('wkit_user_review'),
        Feedback = __("Your Feedback", "wdesignkit"),
        Feedback_error = __("Please Enter feedback", "wdesignkit"),
        p_comment = __("Add comment", "wdesignkit"),
        emoji_number_text = __("Rate Your Import Experience", "wdesignkit"),
        thumb_text = __("How Was Your Experience with WDesignKit?", "wdesignkit"),
        allow_email = __("Include your email with your review", "wdesignkit"),
        submit_btn = __("Submit", "wdesignkit");

    if (checkparams) {

        var reviewContentDiv = document.querySelector('.wkit-plugin-review-popup-container'),
            ratings = '',
            screenWidth = window.innerWidth,
            screenHeight = window.innerHeight,
            resolutions = (screenWidth + ' x ' + screenHeight);

        document.addEventListener('click', (e) => {
            if (e.target.closest('.wkit-plus-review')) {
                let feedbackElement = reviewContentDiv.querySelector('.wkit-get-feedback');
                if (feedbackElement) {
                    reviewContentDiv.classList.remove('wkit-negative-review');
                    feedbackElement.remove();
                }

                removeReviewPopup();
                window.open('https://wordpress.org/support/plugin/wdesignkit/reviews/#new-post', '_blank');
            } else if (e.target.closest('.wkit-minus-review')) {

                if (e.target.closest('.wkit-rating-one')) {
                    ratings = 1;
                } else if (e.target.closest('.wkit-rating-two')) {
                    ratings = 2;
                } else if (e.target.closest('.wkit-rating-three')) {
                    ratings = 3;
                }

                let feedbackElement = reviewContentDiv.querySelector('.wkit-get-feedback'),
                    selectedReview = reviewContentDiv.querySelector('.wkit-get-plugin-review'),
                    reviewText = reviewContentDiv.querySelector('.wkit-plugin-review-text');

                if (selectedReview && reviewText) {
                    selectedReview.remove();
                    reviewText.remove();
                }

                if (!feedbackElement) {
                    reviewContentDiv.classList.add('wkit-negative-review');
                    getReviewData()
                }
            } else if (e.target.closest('.wkit-plugin-review-close')) {
                removeReviewPopup();
            } else if (e.target.closest('.wkit-submit-review')) {
                var feedback_msg = document.querySelector('#wkit-pr-feedback');
                var email_val = document.querySelector('.wkit-plugin-review-email-inp') ? document.querySelector('.wkit-plugin-review-email-inp') : '';

                if (feedback_msg?.value.trim() == '') {
                    feedback_msg.classList.add('wkit-pr-error');
                    feedback_msg.placeholder = Feedback_error;
                    return
                }

                const formData = new FormData();
                formData.append('action', 'wdkit_submit_review');
                formData.append('nonce', wdkitPluginReview.nonce);
                formData.append('rating', ratings);
                formData.append('description', feedback_msg?.value);
                formData.append('page_url', window.location.href);
                formData.append('screen_resolution', resolutions);
                formData.append('allow_email', email_val?.checked);

                removeReviewPopup();
                fetch(wdkitPluginReview.ajax_url, {
                    method: 'POST',
                    body: formData,
                }).then(res => res.json())
            }
        });

        document.addEventListener('input', (e) => {
            var feedback_msg = e.target.closest('#wkit-pr-feedback');

            if (feedback_msg && feedback_msg.value.trim() != '' && feedback_msg.classList.contains('wkit-pr-error')) {
                feedback_msg.placeholder = p_comment;
                feedback_msg.classList.remove('wkit-pr-error');
            }
        });

        const getReviewData = () => {
            let review_form = `<div class='wkit-get-feedback'>
                <label for='wkit-pr-feedback' class='wkit-plugin-review-lable'>${Feedback}</label>
                <textarea class='wkit-plugin-review-input' rows='3' id='wkit-pr-feedback' placeholder='${p_comment}'></textarea>
                <div class="wkit-preview-popup-email">
                    <input id="wkit-emial-permission" type="checkbox" class="wkit-plugin-review-email-inp" />
                    <label for="wkit-emial-permission">${allow_email}</label>
                </div>
                <span class='wkit-submit-review'>${submit_btn}</span>
            </div>`;

            reviewContentDiv.innerHTML += review_form;
        };

        const removeReviewPopup = () => {
            const url = new URL(window.location.href);
            url.searchParams.delete('wkit_user_review');
            window.history.replaceState({}, '', url);

            let reviewPopup = document.querySelector('.wkit-plugin-review-popup-container');
            if (reviewPopup) {
                let removeContent = reviewPopup.querySelector('.wkit-plugin-review-content');
                if (removeContent) {
                    removeContent.classList.add('wkit-remove-review-popup');
                }

                setTimeout(() => {
                    reviewPopup.remove();
                }, 400);
            }
        }

        const thumbReview = () => {

            let review_data = `<span class='wkit-plugin-review-text'>${thumb_text}</span>
                                <div class='wkit-get-plugin-review'>
                                    <span class='wkit-plugin-review-btn wkit-plus-review'>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M37.4861 23.8375C37.451 24.1878 37.3196 24.5215 37.1063 24.8016C36.893 25.0817 36.6062 25.2972 36.2778 25.4242C36.0994 25.4937 35.9394 25.6033 35.8101 25.7445C35.6807 25.8857 35.5856 26.0547 35.5319 26.2385C35.4783 26.4223 35.4675 26.6159 35.5006 26.8045C35.5336 26.9931 35.6095 27.1716 35.7225 27.3262C35.8991 27.5679 36.0072 27.8527 36.0355 28.1507C36.0638 28.4487 36.0112 28.7488 35.8832 29.0194C35.7553 29.29 35.5567 29.5211 35.3084 29.6882C35.0601 29.8554 34.7713 29.9526 34.4725 29.9694C34.2353 29.9829 34.0069 30.0637 33.8139 30.2023C33.621 30.341 33.4715 30.5317 33.383 30.7521C33.2945 30.9726 33.2706 31.2137 33.3141 31.4473C33.3576 31.6808 33.4668 31.8972 33.6287 32.071C33.8176 32.2729 33.9573 32.5158 34.0369 32.7806C34.1164 33.0454 34.1338 33.3251 34.0875 33.5977C34.0413 33.8703 33.9327 34.1286 33.7703 34.3524C33.6078 34.5761 33.3959 34.7594 33.151 34.8878C28.0544 34.9815 22.8896 35.0111 17.7968 34.9759C17.51 34.9802 17.2272 34.9092 16.9765 34.77C16.2359 34.3776 15.3663 34.055 14.5247 33.7431C14.1597 33.608 13.788 33.4707 13.4285 33.3278V22.6135C14.7094 22.0024 15.7723 21.0391 16.5952 19.7382L21.4866 12.0094C21.9298 11.3219 22.1604 10.519 22.1496 9.70105C22.1473 9.28972 22.1512 8.81089 22.1562 8.30464C22.1674 6.91159 22.1809 5.33831 22.0871 4.01894C23.0324 3.90956 23.8223 4.27956 24.4981 5.14909C26.3583 7.5412 26.5793 12.4944 25.5223 15.0007C25.4285 15.223 25.4011 15.4678 25.4435 15.7054C25.4858 15.943 25.596 16.1633 25.7608 16.3397C25.9255 16.516 26.1378 16.6409 26.372 16.6992C26.6062 16.7575 26.8523 16.7468 27.0805 16.6683C31.4522 15.1636 34.36 15.0135 35.7234 16.2212C35.7893 16.2802 35.8616 16.3317 35.9388 16.3747C36.2563 16.5536 36.5279 16.8038 36.732 17.1057C36.9361 17.4076 37.0671 17.7528 37.1148 18.1141C37.1624 18.4754 37.1254 18.8428 37.0065 19.1873C36.8877 19.5318 36.6903 19.8439 36.43 20.0989C36.2965 20.2301 36.1941 20.3896 36.1305 20.5656C36.0668 20.7416 36.0435 20.9297 36.0622 21.1159C36.0809 21.3021 36.1411 21.4818 36.2385 21.6416C36.3359 21.8015 36.4679 21.9374 36.6248 22.0395C36.9205 22.2304 37.1575 22.4995 37.3095 22.8169C37.4615 23.1344 37.5226 23.4877 37.4859 23.8378L37.4861 23.8375ZM39.5935 17.7859C39.4961 17.0631 39.2377 16.3714 38.8375 15.7617C38.4373 15.1521 37.9054 14.6399 37.281 14.2631C36.262 13.4086 34.8962 12.9576 33.2185 12.9225C31.8684 12.8951 30.3019 13.1245 28.4723 13.6201C28.6714 12.3301 28.7089 11.0204 28.584 9.72112C28.3557 7.24198 27.6062 5.07378 26.4721 3.61487C25.2208 2.0055 23.4934 1.27581 21.6093 1.56019C21.0144 1.65227 20.476 1.96485 20.1011 2.43578C19.7262 2.9067 19.5423 3.50147 19.5859 4.10183C19.6808 5.33808 19.6673 6.90245 19.6556 8.28378C19.6512 8.79894 19.6473 9.28558 19.6495 9.71253C19.6578 10.0533 19.5616 10.3885 19.3738 10.673L14.4832 18.4017C14.1939 18.8651 13.8386 19.2838 13.4285 19.6446V18.6993C13.4286 18.5351 13.3963 18.3726 13.3336 18.2209C13.2708 18.0692 13.1787 17.9313 13.0626 17.8152C12.9465 17.6991 12.8087 17.6071 12.657 17.5443C12.5053 17.4815 12.3427 17.4492 12.1785 17.4493H1.24609C1.08192 17.4492 0.919336 17.4815 0.767642 17.5443C0.615948 17.6071 0.478117 17.6992 0.362027 17.8153C0.245938 17.9314 0.153866 18.0692 0.0910772 18.2209C0.0282879 18.3726 -0.00398824 18.5352 -0.00390609 18.6993V37.2556C-0.00390609 37.5871 0.12779 37.905 0.36221 38.1395C0.596631 38.3739 0.914573 38.5056 1.24609 38.5056H12.1789C12.5104 38.5056 12.8284 38.3739 13.0628 38.1395C13.2972 37.905 13.4289 37.5871 13.4289 37.2556V36.0037C13.5048 36.0317 13.5813 36.0601 13.6572 36.088C14.457 36.3843 15.2127 36.6646 15.8065 36.9786C16.4124 37.3069 17.0909 37.478 17.78 37.4764C19.1697 37.4859 20.5636 37.4907 21.9619 37.4909C25.7934 37.4909 29.6432 37.4546 33.4541 37.3832C33.6026 37.3806 33.7495 37.3512 33.8877 37.2967C34.9099 36.8952 35.7394 36.1176 36.2061 35.1236C36.6728 34.1295 36.7411 32.9945 36.3969 31.9517C37.234 31.4878 37.8858 30.7498 38.2428 29.8619C38.5997 28.974 38.6401 27.9902 38.357 27.076C38.8104 26.7091 39.1867 26.256 39.4641 25.743C39.7415 25.2299 39.9146 24.667 39.9735 24.0867C40.0323 23.5065 39.9757 22.9203 39.8068 22.362C39.638 21.8037 39.3604 21.2843 38.9898 20.8339C39.5186 19.9111 39.7307 18.8405 39.5935 17.7859Z" fill="#040483" />
                                        </svg>
                                    </span>
                                    <span class='wkit-plugin-review-btn wkit-minus-review wkit-rating-three'>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M2.51391 16.1625C2.54895 15.8122 2.68043 15.4785 2.89373 15.1984C3.10703 14.9183 3.3938 14.7028 3.72219 14.5758C3.90058 14.5063 4.06061 14.3967 4.18993 14.2555C4.31926 14.1143 4.41442 13.9453 4.46808 13.7615C4.52174 13.5777 4.53246 13.3841 4.49942 13.1955C4.46638 13.0069 4.39045 12.8284 4.2775 12.6738C4.1009 12.4321 3.99277 12.1473 3.96448 11.8493C3.93619 11.5513 3.9888 11.2512 4.11676 10.9806C4.24473 10.71 4.44331 10.4789 4.69159 10.3118C4.93987 10.1446 5.22865 10.0474 5.5275 10.0306C5.76469 10.0171 5.99313 9.93627 6.18607 9.79765C6.37902 9.65903 6.52849 9.46833 6.61701 9.24786C6.70553 9.02739 6.72942 8.78627 6.6859 8.55271C6.64238 8.31915 6.53324 8.10282 6.37125 7.92903C6.18239 7.72706 6.04273 7.48419 5.96315 7.21937C5.88356 6.95455 5.86622 6.67493 5.91245 6.40231C5.95869 6.12968 6.06727 5.87142 6.22971 5.64765C6.39216 5.42388 6.60409 5.24064 6.84899 5.11223C11.9456 5.01848 17.1104 4.98888 22.2032 5.02411C22.49 5.01979 22.7728 5.09081 23.0235 5.23005C23.7641 5.62239 24.6337 5.94497 25.4753 6.25692C25.8403 6.392 26.212 6.52927 26.5715 6.67216V17.3865C25.2906 17.9976 24.2277 18.9609 23.4048 20.2618L18.5134 27.9906C18.0702 28.6781 17.8396 29.481 17.8504 30.299C17.8527 30.7103 17.8488 31.1891 17.8438 31.6954C17.8326 33.0884 17.8191 34.6617 17.9129 35.9811C16.9676 36.0904 16.1777 35.7204 15.5019 34.8509C13.6417 32.4588 13.4207 27.5056 14.4777 24.9993C14.5715 24.777 14.5989 24.5322 14.5565 24.2946C14.5142 24.057 14.404 23.8367 14.2392 23.6603C14.0745 23.484 13.8622 23.3591 13.628 23.3008C13.3938 23.2425 13.1477 23.2532 12.9195 23.3317C8.54782 24.8364 5.64 24.9865 4.27657 23.7788C4.21066 23.7198 4.13842 23.6683 4.06118 23.6253C3.74367 23.4464 3.47212 23.1962 3.26802 22.8943C3.06392 22.5924 2.93287 22.2472 2.88522 21.8859C2.83757 21.5246 2.87464 21.1572 2.99349 20.8127C3.11234 20.4682 3.30972 20.1561 3.57 19.9011C3.7035 19.7699 3.80585 19.6104 3.86951 19.4344C3.93317 19.2584 3.95651 19.0703 3.93782 18.8841C3.91913 18.6979 3.85888 18.5182 3.76151 18.3584C3.66414 18.1985 3.53214 18.0626 3.37524 17.9605C3.07954 17.7696 2.84253 17.5005 2.69052 17.1831C2.5385 16.8656 2.47742 16.5123 2.51407 16.1622L2.51391 16.1625ZM0.406489 22.2141C0.50392 22.9369 0.762259 23.6286 1.16248 24.2383C1.56269 24.8479 2.09459 25.3601 2.71899 25.7369C3.73805 26.5914 5.10375 27.0424 6.78149 27.0775C8.13156 27.1049 9.69813 26.8755 11.5277 26.3799C11.3286 27.6699 11.2911 28.9796 11.416 30.2789C11.6443 32.758 12.3938 34.9262 13.5279 36.3851C14.7792 37.9945 16.5066 38.7242 18.3907 38.4398C18.9856 38.3477 19.524 38.0351 19.8989 37.5642C20.2738 37.0933 20.4577 36.4985 20.4141 35.8982C20.3192 34.6619 20.3327 33.0975 20.3444 31.7162C20.3488 31.2011 20.3527 30.7144 20.3505 30.2875C20.3422 29.9467 20.4384 29.6115 20.6262 29.327L25.5168 21.5983C25.8061 21.1349 26.1614 20.7162 26.5715 20.3554V21.3007C26.5714 21.4649 26.6037 21.6274 26.6664 21.7791C26.7292 21.9308 26.8213 22.0687 26.9374 22.1848C27.0535 22.3009 27.1913 22.3929 27.343 22.4557C27.4947 22.5185 27.6573 22.5508 27.8215 22.5507H38.7539C38.9181 22.5508 39.0807 22.5185 39.2324 22.4557C39.3841 22.3929 39.5219 22.3008 39.638 22.1847C39.7541 22.0686 39.8461 21.9308 39.9089 21.7791C39.9717 21.6274 40.004 21.4648 40.0039 21.3007V2.74442C40.0039 2.4129 39.8722 2.09496 39.6378 1.86054C39.4034 1.62612 39.0854 1.49442 38.7539 1.49442H27.8211C27.4896 1.49442 27.1716 1.62612 26.9372 1.86054C26.7028 2.09496 26.5711 2.4129 26.5711 2.74442V3.9963C26.4952 3.96833 26.4187 3.93989 26.3428 3.912C25.543 3.61567 24.7873 3.33544 24.1935 3.02137C23.5876 2.69312 22.9091 2.52197 22.22 2.52356C20.8303 2.51408 19.4364 2.50927 18.0381 2.50911C14.2066 2.50911 10.3568 2.54536 6.54594 2.61677C6.39737 2.61945 6.25049 2.64877 6.11227 2.70333C5.09015 3.10478 4.26056 3.8824 3.7939 4.87645C3.32724 5.87049 3.25895 7.0055 3.60305 8.04833C2.76601 8.51222 2.11421 9.25016 1.75725 10.1381C1.40029 11.026 1.35993 12.0098 1.64297 12.924C1.18959 13.2909 0.81334 13.744 0.535908 14.257C0.258475 14.7701 0.0853542 15.333 0.0265264 15.9133C-0.0323013 16.4935 0.0243279 17.0797 0.19315 17.638C0.361972 18.1963 0.639646 18.7157 1.01016 19.1661C0.481364 20.0889 0.269334 21.1595 0.406489 22.2141Z" fill="#FC4032" />
                                        </svg>
                                    </span>
                                </div>`;
            reviewContentDiv.innerHTML += review_data;
        };

        const emojiReview = () => {
            const emojis = [
                {
                    svg: `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.9999 4.13516C11.237 4.13516 4.1332 11.2389 4.1332 20.0018C4.1332 28.7647 11.237 35.8685 19.9999 35.8685C28.7628 35.8685 35.8665 28.7647 35.8665 20.0018C35.8665 11.2389 28.7628 4.13516 19.9999 4.13516ZM2.5332 20.0018C2.5332 10.3552 10.3533 2.53516 19.9999 2.53516C29.6464 2.53516 37.4665 10.3552 37.4665 20.0018C37.4665 29.6484 29.6464 37.4685 19.9999 37.4685C10.3533 37.4685 2.5332 29.6484 2.5332 20.0018ZM11.0239 17.1512C11.024 16.858 11.1113 16.5714 11.2748 16.328C11.4384 16.0847 11.6707 15.8955 11.9421 15.7846C12.2135 15.6737 12.5118 15.6462 12.799 15.7055C13.0861 15.7648 13.3491 15.9083 13.5544 16.1176C13.7597 16.327 13.8981 16.5927 13.9518 16.8809C14.0055 17.1692 13.9722 17.4669 13.8561 17.7361C13.74 18.0054 13.5463 18.2339 13.2998 18.3927C13.0533 18.5515 12.7651 18.6332 12.472 18.6276C12.2794 18.6276 12.0887 18.5893 11.9112 18.5147C11.7336 18.4402 11.5727 18.331 11.4379 18.1935C11.303 18.056 11.197 17.893 11.1259 17.714C11.0548 17.5351 11.0201 17.3437 11.0239 17.1512ZM26.0439 17.1514C26.0439 16.7598 26.1995 16.3843 26.4764 16.1074C26.7533 15.8305 27.1288 15.675 27.5204 15.675C27.912 15.675 28.2875 15.8305 28.5644 16.1074C28.8413 16.3843 28.9968 16.7598 28.9968 17.1514C28.9968 17.543 28.8413 17.9185 28.5644 18.1954C28.2875 18.4723 27.912 18.6279 27.5204 18.6279C27.1288 18.6279 26.7533 18.4723 26.4764 18.1954C26.1995 17.9185 26.0439 17.543 26.0439 17.1514ZM15.6175 24.6599C16.9224 23.8028 18.4494 23.3461 20.0106 23.3461C21.5718 23.3461 23.0988 23.8028 24.4037 24.6599C25.7085 25.517 26.7342 26.737 27.3542 28.1698C27.5297 28.5753 28.0007 28.7617 28.4061 28.5862C28.8116 28.4107 28.9981 27.9398 28.8226 27.5343C28.0786 25.8151 26.8478 24.351 25.2821 23.3226C23.7163 22.2941 21.8839 21.7461 20.0106 21.7461C18.1373 21.7461 16.3049 22.2941 14.7391 23.3226C13.1734 24.351 11.9427 25.8151 11.1986 27.5343C11.0231 27.9398 11.2096 28.4107 11.6151 28.5862C12.0206 28.7617 12.4915 28.5753 12.667 28.1698C13.2871 26.737 14.3127 25.517 15.6175 24.6599ZM10.5674 11.6777C10.7968 11.3 11.2889 11.1798 11.6665 11.4092L15.4995 13.7374C15.8772 13.9668 15.9973 14.4589 15.768 14.8365C15.5386 15.2141 15.0465 15.3343 14.6689 15.1049L10.8359 12.7767C10.4582 12.5473 10.3381 12.0553 10.5674 11.6777ZM29.1829 12.7781C29.5613 12.5499 29.6831 12.0583 29.4549 11.6799C29.2268 11.3015 28.7351 11.1797 28.3568 11.4079L24.4953 13.7361C24.1169 13.9642 23.9952 14.4559 24.2233 14.8343C24.4514 15.2126 24.9431 15.3344 25.3215 15.1063L29.1829 12.7781Z" />
                </svg>`,
                    svg_class: 'wkit-emoji-container wkit-minus-review wkit-rating-one',
                },
                {
                    svg: `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.1332 19.9979C4.1332 11.235 11.237 4.13125 19.9999 4.13125C28.7628 4.13125 35.8665 11.235 35.8665 19.9979C35.8665 28.7608 28.7628 35.8646 19.9999 35.8646C11.237 35.8646 4.1332 28.7608 4.1332 19.9979ZM19.9999 2.53125C10.3533 2.53125 2.5332 10.3513 2.5332 19.9979C2.5332 29.6445 10.3533 37.4646 19.9999 37.4646C29.6464 37.4646 37.4665 29.6445 37.4665 19.9979C37.4665 10.3513 29.6464 2.53125 19.9999 2.53125ZM11.4404 15.084C11.1636 15.3609 11.008 15.7364 11.008 16.128C11.008 16.5196 11.1636 16.8951 11.4404 17.172C11.7173 17.4489 12.0929 17.6044 12.4844 17.6044C12.876 17.6044 13.2516 17.4489 13.5284 17.172C13.8053 16.8951 13.9609 16.5196 13.9609 16.128C13.9609 15.7364 13.8053 15.3609 13.5284 15.084C13.2516 14.8071 12.876 14.6516 12.4844 14.6516C12.0929 14.6516 11.7173 14.8071 11.4404 15.084ZM26.0559 16.128C26.0559 15.836 26.1425 15.5505 26.3047 15.3077C26.4669 15.0649 26.6975 14.8757 26.9673 14.764C27.2371 14.6522 27.5339 14.623 27.8203 14.6799C28.1067 14.7369 28.3698 14.8775 28.5763 15.084C28.7828 15.2905 28.9234 15.5536 28.9804 15.84C29.0373 16.1264 29.0081 16.4232 28.8963 16.693C28.7846 16.9628 28.5954 17.1934 28.3526 17.3556C28.1098 17.5178 27.8243 17.6044 27.5323 17.6044C27.1407 17.6044 26.7652 17.4489 26.4883 17.172C26.2114 16.8951 26.0559 16.5196 26.0559 16.128ZM15.6019 23.6364C16.9068 22.7793 18.4338 22.3227 19.995 22.3227C21.5561 22.3227 23.0832 22.7793 24.3881 23.6364C25.6929 24.4935 26.7185 25.7136 27.3386 27.1463C27.5141 27.5518 27.985 27.7383 28.3905 27.5628C28.796 27.3873 28.9825 26.9163 28.807 26.5109C28.0629 24.7916 26.8322 23.3276 25.2665 22.2991C23.7007 21.2706 21.8683 20.7227 19.995 20.7227C18.1217 20.7227 16.2893 21.2706 14.7235 22.2991C13.1577 23.3276 11.927 24.7916 11.183 26.5109C11.0075 26.9163 11.194 27.3873 11.5994 27.5628C12.0049 27.7383 12.4759 27.5518 12.6514 27.1463C13.2714 25.7136 14.2971 24.4935 15.6019 23.6364Z" />
                </svg>`,
                    svg_class: 'wkit-emoji-container wkit-minus-review wkit-rating-two',
                },
                {
                    svg: `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.9999 4.13125C11.237 4.13125 4.1332 11.235 4.1332 19.9979C4.1332 28.7608 11.237 35.8646 19.9999 35.8646C28.7628 35.8646 35.8665 28.7608 35.8665 19.9979C35.8665 11.235 28.7628 4.13125 19.9999 4.13125ZM2.5332 19.9979C2.5332 10.3513 10.3533 2.53125 19.9999 2.53125C29.6464 2.53125 37.4665 10.3513 37.4665 19.9979C37.4665 29.6445 29.6464 37.4646 19.9999 37.4646C10.3533 37.4646 2.5332 29.6445 2.5332 19.9979ZM11.3311 15.3234C11.1688 15.5662 11.0822 15.8516 11.0822 16.1436C11.0822 16.5352 11.2378 16.9107 11.5147 17.1876C11.7916 17.4645 12.1671 17.6201 12.5587 17.6201C12.8507 17.6201 13.1361 17.5335 13.3789 17.3712C13.6217 17.209 13.811 16.9784 13.9227 16.7086C14.0345 16.4388 14.0637 16.142 14.0067 15.8556C13.9498 15.5692 13.8091 15.3061 13.6027 15.0996C13.3962 14.8931 13.1331 14.7525 12.8467 14.6956C12.5603 14.6386 12.2634 14.6678 11.9937 14.7796C11.7239 14.8913 11.4933 15.0806 11.3311 15.3234ZM26.5342 15.0996C26.2573 15.3765 26.1018 15.752 26.1018 16.1436C26.1018 16.5352 26.2573 16.9107 26.5342 17.1876C26.8111 17.4645 27.1866 17.6201 27.5782 17.6201C27.9698 17.6201 28.3453 17.4645 28.6222 17.1876C28.8991 16.9107 29.0546 16.5352 29.0546 16.1436C29.0546 15.752 28.8991 15.3765 28.6222 15.0996C28.3453 14.8227 27.9698 14.6672 27.5782 14.6672C27.1866 14.6672 26.8111 14.8227 26.5342 15.0996ZM13.0012 25.1992C12.5593 25.1992 12.2012 25.5574 12.2012 25.9992C12.2012 26.441 12.5593 26.7992 13.0012 26.7992H27.0012C27.443 26.7992 27.8012 26.441 27.8012 25.9992C27.8012 25.5574 27.443 25.1992 27.0012 25.1992H13.0012Z" />
                </svg>`,
                    svg_class: 'wkit-emoji-container wkit-minus-review wkit-rating-three',
                },
                {
                    svg: `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.1332 19.9979C4.1332 11.235 11.2369 4.13125 19.9999 4.13125C28.7628 4.13125 35.8665 11.235 35.8665 19.9979C35.8665 28.7608 28.7628 35.8646 19.9999 35.8646C11.2369 35.8646 4.1332 28.7608 4.1332 19.9979ZM19.9999 2.53125C10.3533 2.53125 2.5332 10.3513 2.5332 19.9979C2.5332 29.6445 10.3533 37.4646 19.9999 37.4646C29.6464 37.4646 37.4665 29.6445 37.4665 19.9979C37.4665 10.3513 29.6464 2.53125 19.9999 2.53125ZM11.0012 23.1992C10.7489 23.1992 10.5115 23.3182 10.3605 23.5202C10.2094 23.7222 10.1625 23.9836 10.2338 24.2255C10.8779 26.4095 12.1677 28.3267 13.9234 29.6922C15.6798 31.0583 17.8093 31.7992 20.0012 31.7992C22.1931 31.7992 24.3226 31.0583 26.079 29.6922C27.8347 28.3267 29.1245 26.4095 29.7685 24.2255C29.8398 23.9836 29.7929 23.7222 29.6419 23.5202C29.4908 23.3182 29.2534 23.1992 29.0012 23.1992H11.0012ZM14.9057 28.4292C13.701 27.4922 12.7475 26.2406 12.136 24.7992H27.8663C27.2548 26.2406 26.3014 27.4922 25.0967 28.4292C23.6149 29.5817 21.8295 30.1992 20.0012 30.1992C18.1729 30.1992 16.3875 29.5817 14.9057 28.4292ZM13.0598 16.8858C12.8691 16.7892 12.6571 16.7422 12.4434 16.7491C12.2297 16.7561 12.0212 16.8167 11.8372 16.9255C11.6531 17.0343 11.4994 17.1877 11.3903 17.3716C11.1648 17.7515 10.674 17.8767 10.294 17.6512C9.9141 17.4258 9.78888 16.9349 10.0144 16.555C10.2607 16.14 10.6076 15.7937 11.023 15.5481C11.4384 15.3026 11.9091 15.1656 12.3914 15.15C12.8737 15.1343 13.3522 15.2403 13.7827 15.4584C14.2133 15.6765 14.5819 15.9994 14.8547 16.3976C15.1044 16.7621 15.0113 17.26 14.6468 17.5097C14.2823 17.7594 13.7844 17.6663 13.5347 17.3018C13.4139 17.1255 13.2505 16.9824 13.0598 16.8858ZM27.5442 15.1406L27.5286 15.1407C27.0627 15.1466 26.6049 15.2626 26.1923 15.479C25.7798 15.6954 25.4242 16.0062 25.1545 16.3861C24.8987 16.7464 24.9835 17.2458 25.3437 17.5015C25.704 17.7573 26.2034 17.6726 26.4592 17.3123C26.583 17.1379 26.7462 16.9952 26.9356 16.8959C27.1227 16.7977 27.33 16.7446 27.5412 16.7407C27.7619 16.7435 27.9784 16.8024 28.1702 16.912C28.3642 17.0229 28.5264 17.1818 28.6411 17.3736C28.868 17.7527 29.3592 17.8761 29.7384 17.6493C30.1175 17.4224 30.2409 16.9311 30.014 16.552C29.7582 16.1244 29.3966 15.77 28.964 15.5228C28.5314 15.2756 28.0424 15.144 27.5442 15.1406Z" />
                </svg>`,
                    svg_class: 'wkit-emoji-container wkit-plus-review',
                },
                {
                    svg: `<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.1332 19.9979C4.1332 11.235 11.237 4.13125 19.9999 4.13125C28.7628 4.13125 35.8665 11.235 35.8665 19.9979C35.8665 28.7608 28.7628 35.8646 19.9999 35.8646C11.237 35.8646 4.1332 28.7608 4.1332 19.9979ZM19.9999 2.53125C10.3533 2.53125 2.5332 10.3513 2.5332 19.9979C2.5332 29.6445 10.3533 37.4646 19.9999 37.4646C29.6464 37.4646 37.4665 29.6445 37.4665 19.9979C37.4665 10.3513 29.6464 2.53125 19.9999 2.53125ZM13.6914 14.823C13.8398 14.8402 13.9832 14.8872 14.1129 14.9613C14.2879 15.0487 14.4358 15.1821 14.5409 15.3472C14.6459 15.5122 14.7041 15.7027 14.7092 15.8983C14.7376 16.3809 14.482 16.6365 14.1697 16.9204L13.4599 17.545L12.4661 18.3684L11.3304 17.4315C11.2416 17.3482 11.142 17.265 11.0396 17.1794L11.0396 17.1794C10.6179 16.8272 10.149 16.4354 10.1947 15.8415C10.2223 15.656 10.2932 15.4796 10.4017 15.3267C10.5103 15.1737 10.6533 15.0486 10.8193 14.9613C11.0832 14.8196 11.3923 14.7878 11.6795 14.8729C11.9666 14.9579 12.2085 15.153 12.3526 15.4156C12.4169 15.5591 12.4553 15.7129 12.4661 15.8699C12.4636 15.7111 12.5028 15.5545 12.5797 15.4156C12.6481 15.2828 12.7428 15.1652 12.8579 15.0699C12.973 14.9747 13.1061 14.9037 13.2494 14.8612C13.3926 14.8188 13.543 14.8058 13.6914 14.823ZM25.8963 14.9652C26.1602 14.8235 26.4693 14.7917 26.7564 14.8768C27.0436 14.9618 27.2855 15.1569 27.4296 15.4195C27.4939 15.563 27.5323 15.7168 27.5431 15.8738C27.5406 15.715 27.5798 15.5584 27.6567 15.4195C27.7251 15.2867 27.8198 15.1691 27.9349 15.0739C28.0499 14.9786 28.1831 14.9076 28.3264 14.8652C28.4696 14.8227 28.62 14.8097 28.7684 14.8269C28.9168 14.8441 29.0602 14.8911 29.1899 14.9652C29.3568 15.0479 29.4995 15.1725 29.604 15.3267C29.7085 15.481 29.7712 15.6597 29.7862 15.8454C29.8565 16.4549 29.3655 16.8515 28.9205 17.2109C28.8265 17.2868 28.7346 17.3611 28.6504 17.4354L27.5431 18.3724L26.5494 17.549L25.8395 16.9243C25.5272 16.6404 25.2717 16.3848 25.2717 15.9022C25.2825 15.7044 25.3461 15.5131 25.456 15.3483C25.5659 15.1835 25.7179 15.0512 25.8963 14.9652ZM12.1001 23.0694L11.9893 23.1221C12.5809 24.6266 13.5866 25.9381 14.8956 26.9012C16.3723 27.9876 18.1576 28.5736 19.9909 28.5736C21.8242 28.5736 23.6095 27.9876 25.0862 26.9012C26.3983 25.9359 27.4057 24.6205 27.9967 23.1115L27.905 23.0672C27.5072 22.8749 27.3406 22.3965 27.5328 21.9987C27.7251 21.6009 28.2035 21.4343 28.6013 21.6266L30.3048 22.45C30.7026 22.6422 30.8692 23.1206 30.677 23.5184C30.4847 23.9162 30.0064 24.0828 29.6086 23.8905L29.4409 23.8095C28.7342 25.5513 27.5574 27.0695 26.0344 28.19C24.2829 29.4786 22.1654 30.1736 19.9909 30.1736C17.8165 30.1736 15.6989 29.4786 13.9474 28.19C12.4248 27.0697 11.248 25.5519 10.5413 23.8104L10.3681 23.8928C9.96906 24.0825 9.4918 23.9128 9.3021 23.5137C9.1124 23.1147 9.2821 22.6374 9.68113 22.4478L11.4131 21.6244C11.8121 21.4347 12.2894 21.6044 12.4791 22.0034C12.6688 22.4024 12.4991 22.8797 12.1001 23.0694Z" />
                </svg>`,
                    svg_class: 'wkit-emoji-container wkit-plus-review',
                },
            ]
            var svg_html = '';
            emojis.forEach((svg_data) => {
                svg_html += `<span class="${svg_data.svg_class}">${svg_data.svg}</span>`
            })

            let emoji_data = `<span class='wkit-plugin-review-text'>${emoji_number_text}</span>
                                <div class='wkit-get-plugin-review'>
                                    ${svg_html}
                                </div>`;

            reviewContentDiv.innerHTML += emoji_data;
        }

        const numberReview = () => {

            const numbers = [
                { points: '1', num_class: 'wkit-number-container wkit-minus-review wkit-rating-one' },
                { points: '2', num_class: 'wkit-number-container wkit-minus-review wkit-rating-two' },
                { points: '3', num_class: 'wkit-number-container wkit-minus-review wkit-rating-three' },
                { points: '4', num_class: 'wkit-number-container wkit-plus-review' },
                { points: '5', num_class: 'wkit-number-container wkit-plus-review' },
            ]

            let number_html = '';
            numbers.forEach((num_data) => {
                number_html += `<span class="${num_data.num_class}">${num_data.points}</span>`
            })

            reviewContentDiv.innerHTML += ` <span class='wkit-plugin-review-text'>${emoji_number_text}</span><div class='wkit-get-plugin-review'>${number_html}</div>`;
        }

        const updateReviewContent = () => {

            let review_container = `
                <div class="wkit-plugin-review-content">
                    <span class="wkit-plugin-review-close">
                        <svg width="14" height="14" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1.40091 15.2558C1.66182 15.5169 2.01481 15.6637 2.38274 15.6637C2.75067 15.6637 3.10366 15.5169 3.36456 15.2558L8.29499 10.2193L13.2254 15.2558C13.5884 15.6217 14.118 15.7645 14.6141 15.6306C15.1103 15.4967 15.4981 15.1062 15.6309 14.6064C15.7639 14.1067 15.6221 13.5733 15.2588 13.2076L10.2587 8.24141L15.2588 3.27521C15.5659 2.91424 15.6703 2.42082 15.5365 1.96497C15.4027 1.50913 15.0485 1.15236 14.5959 1.01757C14.1431 0.882762 13.6535 0.987976 13.2949 1.29727L8.29499 6.26348L3.36455 1.29727C3.00619 0.987976 2.51632 0.882762 2.06375 1.01757C1.61119 1.15237 1.257 1.50911 1.12317 1.96497C0.989339 2.42082 1.0938 2.91424 1.40087 3.27521L6.3313 8.24141L1.40087 13.2076C1.11968 13.4728 0.959961 13.8436 0.959961 14.2316C0.959961 14.6198 1.11968 14.9904 1.40087 15.2557L1.40091 15.2558Z" fill="#19191B"></path></svg>
                    </span>
                    <div class='wkit-plugin-review'></div>
                </div>`;

            reviewContentDiv.innerHTML = review_container;
            reviewContentDiv = reviewContentDiv.querySelector('.wkit-plugin-review');

            let date = new Date().getDate();

            if (date) {
                if (date <= 10) {
                    thumbReview();
                } else if (date <= 20) {
                    emojiReview()
                } else if (date <= 31) {
                    numberReview()
                }
            }
        };

        updateReviewContent();
    }
});