/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-09 12:09:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `JQx2cw4_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1125 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_mystickymenu_contact_lists` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `widget_id` int DEFAULT NULL,
  `contact_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `contact_phone` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `contact_email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `widget_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `page_link` varchar(522) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `message_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=9435 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_ab_test_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `test_id` bigint unsigned NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `views` int DEFAULT '0',
  `converted` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `campaign_id` (`campaign_id`),
  CONSTRAINT `JQx2cw4_pbb_ab_test_variants_ibfk_1` FOREIGN KEY (`test_id`) REFERENCES `JQx2cw4_pbb_ab_tests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `JQx2cw4_pbb_ab_test_variants_ibfk_2` FOREIGN KEY (`campaign_id`) REFERENCES `JQx2cw4_posts` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_ab_tests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint unsigned NOT NULL,
  `metric` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `winner` bigint unsigned DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `duration` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_browsers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `browser_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `country_name` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_log_browsers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint unsigned NOT NULL,
  `browser_id` int unsigned NOT NULL,
  `count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `browser_id` (`browser_id`),
  KEY `log_browser` (`log_id`,`browser_id`),
  CONSTRAINT `JQx2cw4_pbb_log_browsers_ibfk_1` FOREIGN KEY (`log_id`) REFERENCES `JQx2cw4_pbb_logs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `JQx2cw4_pbb_log_browsers_ibfk_2` FOREIGN KEY (`browser_id`) REFERENCES `JQx2cw4_pbb_browsers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_log_countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint unsigned NOT NULL,
  `country_id` int unsigned NOT NULL,
  `count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`),
  KEY `log_country` (`log_id`,`country_id`),
  CONSTRAINT `JQx2cw4_pbb_log_countries_ibfk_1` FOREIGN KEY (`log_id`) REFERENCES `JQx2cw4_pbb_logs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `JQx2cw4_pbb_log_countries_ibfk_2` FOREIGN KEY (`country_id`) REFERENCES `JQx2cw4_pbb_countries` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_log_referrers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint unsigned NOT NULL,
  `referrer_id` int unsigned NOT NULL,
  `count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `referrer_id` (`referrer_id`),
  KEY `log_referrer` (`log_id`,`referrer_id`),
  CONSTRAINT `JQx2cw4_pbb_log_referrers_ibfk_1` FOREIGN KEY (`log_id`) REFERENCES `JQx2cw4_pbb_logs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `JQx2cw4_pbb_log_referrers_ibfk_2` FOREIGN KEY (`referrer_id`) REFERENCES `JQx2cw4_pbb_referrers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint unsigned NOT NULL,
  `views` int DEFAULT '0',
  `converted` int DEFAULT '0',
  `date` date NOT NULL,
  `device_desktop` int DEFAULT '0',
  `device_tablet` int DEFAULT '0',
  `device_mobile` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `date` (`date`),
  KEY `campaign_date` (`campaign_id`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_referrers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `referrer_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_pbb_subscribers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint unsigned NOT NULL,
  `campaign_title` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `form_data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_data` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `date` (`date`),
  KEY `campaign_date` (`campaign_id`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11411 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1575 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_qcld_slider_hero_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time` datetime NOT NULL,
  `slide` longtext COLLATE utf8mb4_unicode_520_ci,
  `style` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `bg_image_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `bg_audio_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `bg_gradient` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_qcld_slider_hero_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sliderid` int NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `slide` longtext COLLATE utf8mb4_unicode_520_ci,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_link` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_link_new_tab` tinyint(1) NOT NULL,
  `thumbnail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ordering` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `btn` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `btn2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `t_font` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `d_font` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tl_space` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dl_space` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stomp` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `draft` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `JQx2cw4_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: JQx2cw4_actionscheduler_actions */
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("977", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-10 05:22:28", "2025-12-10 05:22:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765344148;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765344148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-10 05:22:29", "2025-12-10 05:22:29", "1", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("978", "action_scheduler/migration_hook", "complete", "2025-12-10 05:23:29", "2025-12-10 05:23:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765344209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765344209;}", "2", "1", "2025-12-10 05:23:47", "2025-12-10 05:23:47", "4", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("979", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-11 05:22:29", "2025-12-11 05:22:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765430549;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765430549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-11 06:02:14", "2025-12-11 06:02:14", "573", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("980", "wp_mail_smtp_summary_report_email", "complete", "2025-12-15 14:00:00", "2025-12-15 14:00:00", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765807200;s:18:\"\0*\0first_timestamp\";i:1765807200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765807200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-12-15 16:24:13", "2025-12-15 16:24:13", "1003", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("981", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-10 05:24:48", "2025-12-10 05:24:48", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765344288;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765344288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-10 05:24:51", "2025-12-10 05:24:51", "7", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("982", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-11 05:24:51", "2025-12-11 05:24:51", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765430691;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765430691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-11 06:02:14", "2025-12-11 06:02:14", "573", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("983", "wpforms_process_forms_locator_scan", "complete", "2025-12-10 05:30:37", "2025-12-10 05:30:37", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765344637;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765344637;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-10 05:30:38", "2025-12-10 05:30:38", "15", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("984", "wpforms_process_purge_spam", "complete", "2025-12-10 05:30:37", "2025-12-10 05:30:37", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765344637;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765344637;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-10 05:30:38", "2025-12-10 05:30:38", "15", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("985", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-09 16:35:38", "2025-12-09 16:35:38", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765298138;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765298138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-12-10 05:30:38", "2025-12-10 05:30:38", "15", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("986", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-17 05:30:38", "2025-12-17 05:30:38", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765949438;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765949438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-12-17 07:27:28", "2025-12-17 07:27:28", "1032", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("987", "wpforms_process_forms_locator_scan", "complete", "2025-12-11 05:30:38", "2025-12-11 05:30:38", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765431038;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765431038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-11 06:02:14", "2025-12-11 06:02:14", "573", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("988", "wpforms_process_purge_spam", "complete", "2025-12-11 05:30:38", "2025-12-11 05:30:38", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765431038;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765431038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-11 06:02:14", "2025-12-11 06:02:14", "573", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("989", "wpforms_admin_notifications_update", "complete", "2025-12-10 05:30:56", "2025-12-10 05:30:56", "10", "{\"tasks_meta_id\":3}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-10 05:31:18", "2025-12-10 05:31:18", "17", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("990", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-12 06:02:14", "2025-12-12 06:02:14", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765519334;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765519334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-12 06:06:45", "2025-12-12 06:06:45", "897", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("991", "wpforms_process_forms_locator_scan", "complete", "2025-12-12 06:02:14", "2025-12-12 06:02:14", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765519334;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765519334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-12 06:06:45", "2025-12-12 06:06:45", "897", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("992", "wpforms_process_purge_spam", "complete", "2025-12-12 06:02:14", "2025-12-12 06:02:14", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765519334;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765519334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-12 06:06:45", "2025-12-12 06:06:45", "897", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("993", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-12 06:02:14", "2025-12-12 06:02:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765519334;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765519334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-12 06:06:45", "2025-12-12 06:06:45", "897", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("994", "wpforms_admin_notifications_update", "complete", "2025-12-11 10:50:24", "2025-12-11 10:50:24", "10", "{\"tasks_meta_id\":4}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-11 10:50:25", "2025-12-11 10:50:25", "578", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("995", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-13 06:06:45", "2025-12-13 06:06:45", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765606005;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765606005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-13 06:07:41", "2025-12-13 06:07:41", "916", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("996", "wpforms_process_forms_locator_scan", "complete", "2025-12-13 06:06:45", "2025-12-13 06:06:45", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765606005;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765606005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-13 06:07:41", "2025-12-13 06:07:41", "916", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("997", "wpforms_process_purge_spam", "complete", "2025-12-13 06:06:45", "2025-12-13 06:06:45", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765606005;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765606005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-13 06:07:41", "2025-12-13 06:07:41", "916", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("998", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-13 06:06:45", "2025-12-13 06:06:45", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765606005;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765606005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-13 06:07:41", "2025-12-13 06:07:41", "916", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("999", "wpforms_admin_notifications_update", "complete", "2025-12-12 15:09:33", "2025-12-12 15:09:33", "10", "{\"tasks_meta_id\":5}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-12 15:09:36", "2025-12-12 15:09:36", "908", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1000", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-14 06:07:41", "2025-12-14 06:07:41", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765692461;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765692461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-14 06:13:05", "2025-12-14 06:13:05", "937", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1001", "wpforms_process_forms_locator_scan", "complete", "2025-12-14 06:07:41", "2025-12-14 06:07:41", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765692461;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765692461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-14 06:13:05", "2025-12-14 06:13:05", "937", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1002", "wpforms_process_purge_spam", "complete", "2025-12-14 06:07:41", "2025-12-14 06:07:41", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765692461;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765692461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-14 06:13:05", "2025-12-14 06:13:05", "937", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1003", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-14 06:07:41", "2025-12-14 06:07:41", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765692461;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765692461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-14 06:13:05", "2025-12-14 06:13:05", "937", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1004", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-15 06:13:05", "2025-12-15 06:13:05", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765779185;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765779185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-15 06:15:50", "2025-12-15 06:15:50", "960", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1005", "wpforms_process_forms_locator_scan", "complete", "2025-12-15 06:13:05", "2025-12-15 06:13:05", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765779185;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765779185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-15 06:15:50", "2025-12-15 06:15:50", "960", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1006", "wpforms_process_purge_spam", "complete", "2025-12-15 06:13:05", "2025-12-15 06:13:05", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765779185;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765779185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-15 06:15:50", "2025-12-15 06:15:50", "960", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1007", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-15 06:13:05", "2025-12-15 06:13:05", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765779185;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765779185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-15 06:15:50", "2025-12-15 06:15:50", "960", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1008", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-16 06:15:50", "2025-12-16 06:15:50", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765865750;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765865750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-16 06:27:58", "2025-12-16 06:27:58", "1013", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1009", "wpforms_process_forms_locator_scan", "complete", "2025-12-16 06:15:50", "2025-12-16 06:15:50", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765865750;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765865750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-16 06:27:58", "2025-12-16 06:27:58", "1013", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1010", "wpforms_process_purge_spam", "complete", "2025-12-16 06:15:50", "2025-12-16 06:15:50", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765865750;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765865750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-16 06:27:58", "2025-12-16 06:27:58", "1013", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1011", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-16 06:15:50", "2025-12-16 06:15:50", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765865750;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765865750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-16 06:27:58", "2025-12-16 06:27:58", "1013", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1012", "wp_mail_smtp_summary_report_email", "complete", "2025-12-22 16:24:13", "2025-12-22 16:24:13", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766420653;s:18:\"\0*\0first_timestamp\";i:1765807200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766420653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-12-22 16:24:27", "2025-12-22 16:24:27", "1457", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1013", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-17 06:27:58", "2025-12-17 06:27:58", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765952878;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765952878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-17 07:27:28", "2025-12-17 07:27:28", "1032", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1014", "wpforms_process_forms_locator_scan", "complete", "2025-12-17 06:27:58", "2025-12-17 06:27:58", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765952878;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765952878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-17 07:27:28", "2025-12-17 07:27:28", "1032", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1015", "wpforms_process_purge_spam", "complete", "2025-12-17 06:27:58", "2025-12-17 06:27:58", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765952878;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765952878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-17 07:27:28", "2025-12-17 07:27:28", "1032", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1016", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-17 06:27:58", "2025-12-17 06:27:58", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765952878;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765952878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-17 07:27:28", "2025-12-17 07:27:28", "1032", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1017", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-24 07:27:28", "2025-12-24 07:27:28", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766561248;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766561248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-12-24 07:36:53", "2025-12-24 07:36:53", "1774", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1018", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-18 07:27:28", "2025-12-18 07:27:28", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766042848;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766042848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-18 07:54:44", "2025-12-18 07:54:44", "1050", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1019", "wpforms_process_forms_locator_scan", "complete", "2025-12-18 07:27:28", "2025-12-18 07:27:28", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766042848;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766042848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-18 07:54:44", "2025-12-18 07:54:44", "1050", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1020", "wpforms_process_purge_spam", "complete", "2025-12-18 07:27:28", "2025-12-18 07:27:28", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766042848;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766042848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-18 07:54:44", "2025-12-18 07:54:44", "1050", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1021", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-18 07:27:28", "2025-12-18 07:27:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766042848;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766042848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-18 07:54:44", "2025-12-18 07:54:44", "1050", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1022", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-19 07:54:44", "2025-12-19 07:54:44", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766130884;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766130884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-19 08:26:31", "2025-12-19 08:26:31", "1075", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1023", "wpforms_process_forms_locator_scan", "complete", "2025-12-19 07:54:44", "2025-12-19 07:54:44", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766130884;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766130884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-19 08:26:31", "2025-12-19 08:26:31", "1075", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1024", "wpforms_process_purge_spam", "complete", "2025-12-19 07:54:44", "2025-12-19 07:54:44", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766130884;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766130884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-19 08:26:31", "2025-12-19 08:26:31", "1075", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1025", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-19 07:54:44", "2025-12-19 07:54:44", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766130884;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766130884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-19 08:26:31", "2025-12-19 08:26:31", "1075", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1026", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-20 08:26:31", "2025-12-20 08:26:31", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766219191;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766219191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-20 09:10:47", "2025-12-20 09:10:47", "1096", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1027", "wpforms_process_forms_locator_scan", "complete", "2025-12-20 08:26:31", "2025-12-20 08:26:31", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766219191;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766219191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-20 09:10:47", "2025-12-20 09:10:47", "1096", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1028", "wpforms_process_purge_spam", "complete", "2025-12-20 08:26:31", "2025-12-20 08:26:31", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766219191;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766219191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-20 09:10:47", "2025-12-20 09:10:47", "1096", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1029", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-20 08:26:31", "2025-12-20 08:26:31", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766219191;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766219191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-20 09:10:47", "2025-12-20 09:10:47", "1096", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1030", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-21 09:10:47", "2025-12-21 09:10:47", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766308247;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766308247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-21 09:11:46", "2025-12-21 09:11:46", "1118", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1031", "wpforms_process_forms_locator_scan", "complete", "2025-12-21 09:10:47", "2025-12-21 09:10:47", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766308247;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766308247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-21 09:11:46", "2025-12-21 09:11:46", "1118", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1032", "wpforms_process_purge_spam", "complete", "2025-12-21 09:10:47", "2025-12-21 09:10:47", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766308247;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766308247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-21 09:11:46", "2025-12-21 09:11:46", "1118", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1033", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-21 09:10:47", "2025-12-21 09:10:47", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766308247;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766308247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-21 09:11:46", "2025-12-21 09:11:46", "1118", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1034", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-22 09:11:46", "2025-12-22 09:11:46", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766394706;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766394706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-22 09:14:51", "2025-12-22 09:14:51", "1228", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1035", "wpforms_process_forms_locator_scan", "complete", "2025-12-22 09:11:46", "2025-12-22 09:11:46", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766394706;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766394706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-22 09:14:51", "2025-12-22 09:14:51", "1228", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1036", "wpforms_process_purge_spam", "complete", "2025-12-22 09:11:46", "2025-12-22 09:11:46", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766394706;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766394706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-22 09:14:51", "2025-12-22 09:14:51", "1228", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1037", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-22 09:11:46", "2025-12-22 09:11:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766394706;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766394706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-22 09:14:51", "2025-12-22 09:14:51", "1228", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1038", "wpforms_admin_notifications_update", "complete", "2025-12-22 01:19:04", "2025-12-22 01:19:04", "10", "{\"tasks_meta_id\":6}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-22 01:19:07", "2025-12-22 01:19:07", "1135", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1039", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-23 09:14:51", "2025-12-23 09:14:51", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766481291;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766481291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-23 09:19:25", "2025-12-23 09:19:25", "1537", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1040", "wpforms_process_forms_locator_scan", "complete", "2025-12-23 09:14:51", "2025-12-23 09:14:51", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766481291;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766481291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-23 09:19:25", "2025-12-23 09:19:25", "1537", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1041", "wpforms_process_purge_spam", "complete", "2025-12-23 09:14:51", "2025-12-23 09:14:51", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766481291;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766481291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-23 09:19:25", "2025-12-23 09:19:25", "1537", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1042", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-23 09:14:51", "2025-12-23 09:14:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766481291;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766481291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-23 09:19:25", "2025-12-23 09:19:25", "1537", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1043", "wp_mail_smtp_summary_report_email", "complete", "2025-12-29 16:24:27", "2025-12-29 16:24:27", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767025467;s:18:\"\0*\0first_timestamp\";i:1765807200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767025467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-12-29 17:14:43", "2025-12-29 17:14:43", "2401", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1044", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-24 09:19:25", "2025-12-24 09:19:25", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766567965;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766567965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-24 09:21:15", "2025-12-24 09:21:15", "1778", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1045", "wpforms_process_forms_locator_scan", "complete", "2025-12-24 09:19:25", "2025-12-24 09:19:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766567965;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766567965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-24 09:21:15", "2025-12-24 09:21:15", "1778", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1046", "wpforms_process_purge_spam", "complete", "2025-12-24 09:19:25", "2025-12-24 09:19:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766567965;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766567965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-24 09:21:15", "2025-12-24 09:21:15", "1778", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1047", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-24 09:19:25", "2025-12-24 09:19:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766567965;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766567965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-24 09:21:15", "2025-12-24 09:21:15", "1778", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1048", "wpforms_admin_notifications_update", "complete", "2025-12-23 10:36:13", "2025-12-23 10:36:13", "10", "{\"tasks_meta_id\":7}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-23 10:36:17", "2025-12-23 10:36:17", "1543", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1049", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-12-31 07:36:53", "2025-12-31 07:36:53", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767166613;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767166613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2025-12-31 07:43:48", "2025-12-31 07:43:48", "2596", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1050", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-25 09:21:15", "2025-12-25 09:21:15", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766654475;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766654475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-25 09:25:25", "2025-12-25 09:25:25", "1845", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1051", "wpforms_process_forms_locator_scan", "complete", "2025-12-25 09:21:15", "2025-12-25 09:21:15", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766654475;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766654475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-25 09:25:25", "2025-12-25 09:25:25", "1845", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1052", "wpforms_process_purge_spam", "complete", "2025-12-25 09:21:15", "2025-12-25 09:21:15", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766654475;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766654475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-25 09:25:25", "2025-12-25 09:25:25", "1845", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1053", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-25 09:21:15", "2025-12-25 09:21:15", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766654475;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766654475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-25 09:25:25", "2025-12-25 09:25:25", "1845", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1054", "wpforms_admin_notifications_update", "complete", "2025-12-24 16:01:53", "2025-12-24 16:01:53", "10", "{\"tasks_meta_id\":8}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-24 16:01:55", "2025-12-24 16:01:55", "1805", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1055", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-26 09:25:25", "2025-12-26 09:25:25", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766741125;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766741125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-26 09:25:32", "2025-12-26 09:25:32", "2141", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1056", "wpforms_process_forms_locator_scan", "complete", "2025-12-26 09:25:25", "2025-12-26 09:25:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766741125;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766741125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-26 09:25:32", "2025-12-26 09:25:32", "2141", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1057", "wpforms_process_purge_spam", "complete", "2025-12-26 09:25:25", "2025-12-26 09:25:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766741125;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766741125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-26 09:25:32", "2025-12-26 09:25:32", "2141", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1058", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-26 09:25:25", "2025-12-26 09:25:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766741125;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766741125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-26 09:25:32", "2025-12-26 09:25:32", "2141", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1059", "wpforms_admin_notifications_update", "complete", "2025-12-26 03:23:03", "2025-12-26 03:23:03", "10", "{\"tasks_meta_id\":9}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-26 03:23:06", "2025-12-26 03:23:06", "1941", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1060", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-27 09:25:32", "2025-12-27 09:25:32", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766827532;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766827532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-27 09:29:06", "2025-12-27 09:29:06", "2185", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1061", "wpforms_process_forms_locator_scan", "complete", "2025-12-27 09:25:32", "2025-12-27 09:25:32", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766827532;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766827532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-27 09:29:06", "2025-12-27 09:29:06", "2185", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1062", "wpforms_process_purge_spam", "complete", "2025-12-27 09:25:32", "2025-12-27 09:25:32", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766827532;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766827532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-27 09:29:06", "2025-12-27 09:29:06", "2185", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1063", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-27 09:25:32", "2025-12-27 09:25:32", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766827532;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766827532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-27 09:29:06", "2025-12-27 09:29:06", "2185", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1064", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-28 09:29:06", "2025-12-28 09:29:06", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766914146;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766914146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-28 09:34:06", "2025-12-28 09:34:06", "2323", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1065", "wpforms_process_forms_locator_scan", "complete", "2025-12-28 09:29:06", "2025-12-28 09:29:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766914146;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766914146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-28 09:34:06", "2025-12-28 09:34:06", "2323", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1066", "wpforms_process_purge_spam", "complete", "2025-12-28 09:29:06", "2025-12-28 09:29:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766914146;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766914146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-28 09:34:06", "2025-12-28 09:34:06", "2323", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1067", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-28 09:29:06", "2025-12-28 09:29:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766914146;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766914146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-28 09:34:06", "2025-12-28 09:34:06", "2323", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1068", "wpforms_admin_notifications_update", "complete", "2025-12-27 23:36:06", "2025-12-27 23:36:06", "10", "{\"tasks_meta_id\":10}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-27 23:36:42", "2025-12-27 23:36:42", "2199", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1069", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-29 09:34:06", "2025-12-29 09:34:06", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767000846;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767000846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-29 09:37:02", "2025-12-29 09:37:02", "2394", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1070", "wpforms_process_forms_locator_scan", "complete", "2025-12-29 09:34:06", "2025-12-29 09:34:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767000846;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767000846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-29 09:37:02", "2025-12-29 09:37:02", "2394", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1071", "wpforms_process_purge_spam", "complete", "2025-12-29 09:34:06", "2025-12-29 09:34:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767000846;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767000846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-29 09:37:02", "2025-12-29 09:37:02", "2394", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1072", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-29 09:34:06", "2025-12-29 09:34:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767000846;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767000846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-29 09:37:02", "2025-12-29 09:37:02", "2394", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1073", "wpforms_admin_notifications_update", "complete", "2025-12-29 01:45:00", "2025-12-29 01:45:00", "10", "{\"tasks_meta_id\":11}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-29 01:45:05", "2025-12-29 01:45:05", "2348", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1074", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-30 09:37:02", "2025-12-30 09:37:02", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767087422;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767087422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-30 09:46:39", "2025-12-30 09:46:39", "2412", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1075", "wpforms_process_forms_locator_scan", "complete", "2025-12-30 09:37:02", "2025-12-30 09:37:02", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767087422;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767087422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-30 09:46:39", "2025-12-30 09:46:39", "2412", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1076", "wpforms_process_purge_spam", "complete", "2025-12-30 09:37:02", "2025-12-30 09:37:02", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767087422;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767087422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-30 09:46:39", "2025-12-30 09:46:39", "2412", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1077", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-30 09:37:02", "2025-12-30 09:37:02", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767087422;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767087422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-30 09:46:39", "2025-12-30 09:46:39", "2412", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1078", "wp_mail_smtp_summary_report_email", "complete", "2026-01-05 17:14:43", "2026-01-05 17:14:43", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767633283;s:18:\"\0*\0first_timestamp\";i:1765807200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767633283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2026-01-05 19:07:48", "2026-01-05 19:07:48", "2844", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1079", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-31 09:46:39", "2025-12-31 09:46:39", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767174399;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767174399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-31 09:50:38", "2025-12-31 09:50:38", "2621", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1080", "wpforms_process_forms_locator_scan", "complete", "2025-12-31 09:46:39", "2025-12-31 09:46:39", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767174399;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767174399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-31 09:50:38", "2025-12-31 09:50:38", "2621", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1081", "wpforms_process_purge_spam", "complete", "2025-12-31 09:46:39", "2025-12-31 09:46:39", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767174399;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767174399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-31 09:50:38", "2025-12-31 09:50:38", "2621", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1082", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-31 09:46:39", "2025-12-31 09:46:39", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767174399;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767174399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-31 09:50:38", "2025-12-31 09:50:38", "2621", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1083", "wpforms_admin_notifications_update", "complete", "2025-12-30 16:00:04", "2025-12-30 16:00:04", "10", "{\"tasks_meta_id\":12}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2025-12-30 16:00:07", "2025-12-30 16:00:07", "2419", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1084", "wpforms_email_summaries_fetch_info_blocks", "complete", "2026-01-07 07:43:48", "2026-01-07 07:43:48", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767771828;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767771828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "1", "2026-01-07 07:46:18", "2026-01-07 07:46:18", "3014", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1085", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-01 09:50:38", "2026-01-01 09:50:38", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767261038;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767261038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-01 10:02:33", "2026-01-01 10:02:33", "2681", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1086", "wpforms_process_forms_locator_scan", "complete", "2026-01-01 09:50:38", "2026-01-01 09:50:38", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767261038;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767261038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-01 10:02:33", "2026-01-01 10:02:33", "2681", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1087", "wpforms_process_purge_spam", "complete", "2026-01-01 09:50:38", "2026-01-01 09:50:38", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767261038;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767261038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-01 10:02:33", "2026-01-01 10:02:33", "2681", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1088", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 09:50:38", "2026-01-01 09:50:38", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767261038;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767261038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-01 10:02:33", "2026-01-01 10:02:33", "2681", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1089", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-02 10:02:33", "2026-01-02 10:02:33", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767348153;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767348153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-02 10:06:44", "2026-01-02 10:06:44", "2722", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1090", "wpforms_process_forms_locator_scan", "complete", "2026-01-02 10:02:33", "2026-01-02 10:02:33", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767348153;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767348153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-02 10:06:44", "2026-01-02 10:06:44", "2722", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1091", "wpforms_process_purge_spam", "complete", "2026-01-02 10:02:33", "2026-01-02 10:02:33", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767348153;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767348153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-02 10:06:45", "2026-01-02 10:06:45", "2722", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1092", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-02 10:02:33", "2026-01-02 10:02:33", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767348153;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767348153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-02 10:06:45", "2026-01-02 10:06:45", "2722", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1093", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-03 10:06:44", "2026-01-03 10:06:44", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767434804;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767434804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-03 13:33:38", "2026-01-03 13:33:38", "2769", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1094", "wpforms_process_forms_locator_scan", "complete", "2026-01-03 10:06:44", "2026-01-03 10:06:44", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767434804;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767434804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-03 13:33:38", "2026-01-03 13:33:38", "2769", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1095", "wpforms_process_purge_spam", "complete", "2026-01-03 10:06:45", "2026-01-03 10:06:45", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767434805;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767434805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-03 13:33:38", "2026-01-03 13:33:38", "2769", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1096", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-03 10:06:45", "2026-01-03 10:06:45", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767434805;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767434805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-03 13:33:38", "2026-01-03 13:33:38", "2769", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1097", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-04 13:33:38", "2026-01-04 13:33:38", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767533618;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767533618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-04 14:25:20", "2026-01-04 14:25:20", "2799", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1098", "wpforms_process_forms_locator_scan", "complete", "2026-01-04 13:33:38", "2026-01-04 13:33:38", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767533618;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767533618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-04 14:25:20", "2026-01-04 14:25:20", "2799", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1099", "wpforms_process_purge_spam", "complete", "2026-01-04 13:33:38", "2026-01-04 13:33:38", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767533618;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767533618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-04 14:25:20", "2026-01-04 14:25:20", "2799", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1100", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-04 13:33:38", "2026-01-04 13:33:38", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767533618;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767533618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-04 14:25:20", "2026-01-04 14:25:20", "2799", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1101", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-05 14:25:20", "2026-01-05 14:25:20", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767623120;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767623120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-05 16:55:19", "2026-01-05 16:55:19", "2842", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1102", "wpforms_process_forms_locator_scan", "complete", "2026-01-05 14:25:20", "2026-01-05 14:25:20", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767623120;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767623120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-05 16:55:19", "2026-01-05 16:55:19", "2842", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1103", "wpforms_process_purge_spam", "complete", "2026-01-05 14:25:20", "2026-01-05 14:25:20", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767623120;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767623120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-05 16:55:19", "2026-01-05 16:55:19", "2842", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1104", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-05 14:25:20", "2026-01-05 14:25:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767623120;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767623120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-05 16:55:19", "2026-01-05 16:55:19", "2842", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1105", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-06 16:55:19", "2026-01-06 16:55:19", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767718519;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767718519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-06 16:56:53", "2026-01-06 16:56:53", "2876", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1106", "wpforms_process_forms_locator_scan", "complete", "2026-01-06 16:55:19", "2026-01-06 16:55:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767718519;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767718519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-06 16:56:53", "2026-01-06 16:56:53", "2876", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1107", "wpforms_process_purge_spam", "complete", "2026-01-06 16:55:19", "2026-01-06 16:55:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767718519;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767718519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-06 16:56:53", "2026-01-06 16:56:53", "2876", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1108", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-06 16:55:19", "2026-01-06 16:55:19", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767718519;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767718519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-06 16:56:53", "2026-01-06 16:56:53", "2876", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1109", "wp_mail_smtp_summary_report_email", "pending", "2026-01-12 19:07:48", "2026-01-12 19:07:48", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768244868;s:18:\"\0*\0first_timestamp\";i:1765807200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768244868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1110", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-07 16:56:53", "2026-01-07 16:56:53", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767805013;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767805013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-07 18:33:04", "2026-01-07 18:33:04", "3129", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1111", "wpforms_process_forms_locator_scan", "complete", "2026-01-07 16:56:53", "2026-01-07 16:56:53", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767805013;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767805013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-07 18:33:04", "2026-01-07 18:33:04", "3129", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1112", "wpforms_process_purge_spam", "complete", "2026-01-07 16:56:53", "2026-01-07 16:56:53", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767805013;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767805013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-07 18:33:04", "2026-01-07 18:33:04", "3129", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1113", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-07 16:56:53", "2026-01-07 16:56:53", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767805013;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767805013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-07 18:33:04", "2026-01-07 18:33:04", "3129", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1114", "wpforms_admin_notifications_update", "complete", "2026-01-07 05:33:58", "2026-01-07 05:33:58", "10", "{\"tasks_meta_id\":13}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-07 05:34:02", "2026-01-07 05:34:02", "2891", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1115", "wpforms_email_summaries_fetch_info_blocks", "pending", "2026-01-14 07:46:18", "2026-01-14 07:46:18", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768376778;s:18:\"\0*\0first_timestamp\";i:1765298138;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768376778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1116", "wp_mail_smtp_admin_notifications_update", "complete", "2026-01-08 18:33:04", "2026-01-08 18:33:04", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767897184;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767897184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-08 21:44:13", "2026-01-08 21:44:13", "3156", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1117", "wpforms_process_forms_locator_scan", "complete", "2026-01-08 18:33:04", "2026-01-08 18:33:04", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767897184;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767897184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-08 21:44:13", "2026-01-08 21:44:13", "3156", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1118", "wpforms_process_purge_spam", "complete", "2026-01-08 18:33:04", "2026-01-08 18:33:04", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767897184;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767897184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2026-01-08 21:44:13", "2026-01-08 21:44:13", "3156", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1119", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-08 18:33:04", "2026-01-08 18:33:04", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767897184;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767897184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-08 21:44:13", "2026-01-08 21:44:13", "3156", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1120", "wp_mail_smtp_admin_notifications_update", "pending", "2026-01-09 21:44:13", "2026-01-09 21:44:13", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767995053;s:18:\"\0*\0first_timestamp\";i:1765344288;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767995053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1121", "wpforms_process_forms_locator_scan", "pending", "2026-01-09 21:44:13", "2026-01-09 21:44:13", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767995053;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767995053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1122", "wpforms_process_purge_spam", "pending", "2026-01-09 21:44:13", "2026-01-09 21:44:13", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767995053;s:18:\"\0*\0first_timestamp\";i:1765344637;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767995053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1123", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-01-09 21:44:13", "2026-01-09 21:44:13", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767995053;s:18:\"\0*\0first_timestamp\";i:1765344148;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767995053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `JQx2cw4_actionscheduler_actions` VALUES("1124", "wpforms_admin_notifications_update", "complete", "2026-01-09 01:32:48", "2026-01-09 01:32:48", "10", "{\"tasks_meta_id\":14}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-09 01:32:52", "2026-01-09 01:32:52", "3176", NULL);

/* INSERT TABLE DATA: JQx2cw4_actionscheduler_groups */
INSERT INTO `JQx2cw4_actionscheduler_groups` VALUES("1", "ActionScheduler");
INSERT INTO `JQx2cw4_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `JQx2cw4_actionscheduler_groups` VALUES("3", "wp_mail_smtp");
INSERT INTO `JQx2cw4_actionscheduler_groups` VALUES("4", "wpforms");

/* INSERT TABLE DATA: JQx2cw4_actionscheduler_logs */
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("1", "977", "action created", "2025-12-10 05:22:28", "2025-12-10 05:22:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("2", "978", "action created", "2025-12-10 05:22:29", "2025-12-10 05:22:29");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("3", "977", "action started via WP Cron", "2025-12-10 05:22:29", "2025-12-10 05:22:29");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("4", "977", "action complete via WP Cron", "2025-12-10 05:22:29", "2025-12-10 05:22:29");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("5", "979", "action created", "2025-12-10 05:22:29", "2025-12-10 05:22:29");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("6", "978", "action started via Async Request", "2025-12-10 05:23:47", "2025-12-10 05:23:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("7", "978", "action complete via Async Request", "2025-12-10 05:23:47", "2025-12-10 05:23:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("8", "980", "action created", "2025-12-10 05:23:48", "2025-12-10 05:23:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("9", "981", "action created", "2025-12-10 05:23:48", "2025-12-10 05:23:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("10", "981", "action started via Async Request", "2025-12-10 05:24:51", "2025-12-10 05:24:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("11", "981", "action complete via Async Request", "2025-12-10 05:24:51", "2025-12-10 05:24:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("12", "982", "action created", "2025-12-10 05:24:51", "2025-12-10 05:24:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("13", "983", "action created", "2025-12-10 05:30:37", "2025-12-10 05:30:37");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("14", "984", "action created", "2025-12-10 05:30:37", "2025-12-10 05:30:37");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("15", "985", "action created", "2025-12-10 05:30:37", "2025-12-10 05:30:37");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("16", "985", "action started via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("17", "985", "action complete via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("18", "986", "action created", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("19", "983", "action started via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("20", "983", "action complete via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("21", "987", "action created", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("22", "984", "action started via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("23", "984", "action complete via WP Cron", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("24", "988", "action created", "2025-12-10 05:30:38", "2025-12-10 05:30:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("25", "989", "action created", "2025-12-10 05:30:56", "2025-12-10 05:30:56");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("26", "989", "action started via Async Request", "2025-12-10 05:31:18", "2025-12-10 05:31:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("27", "989", "action complete via Async Request", "2025-12-10 05:31:18", "2025-12-10 05:31:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("28", "982", "action started via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("29", "982", "action complete via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("30", "990", "action created", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("31", "987", "action started via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("32", "987", "action complete via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("33", "991", "action created", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("34", "988", "action started via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("35", "988", "action complete via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("36", "992", "action created", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("37", "979", "action started via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("38", "979", "action complete via WP Cron", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("39", "993", "action created", "2025-12-11 06:02:14", "2025-12-11 06:02:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("40", "994", "action created", "2025-12-11 10:50:24", "2025-12-11 10:50:24");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("41", "994", "action started via WP Cron", "2025-12-11 10:50:25", "2025-12-11 10:50:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("42", "994", "action complete via WP Cron", "2025-12-11 10:50:25", "2025-12-11 10:50:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("43", "990", "action started via WP Cron", "2025-12-12 06:06:44", "2025-12-12 06:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("44", "990", "action complete via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("45", "995", "action created", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("46", "991", "action started via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("47", "991", "action complete via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("48", "996", "action created", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("49", "992", "action started via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("50", "992", "action complete via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("51", "997", "action created", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("52", "993", "action started via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("53", "993", "action complete via WP Cron", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("54", "998", "action created", "2025-12-12 06:06:45", "2025-12-12 06:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("55", "999", "action created", "2025-12-12 15:09:33", "2025-12-12 15:09:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("56", "999", "action started via WP Cron", "2025-12-12 15:09:36", "2025-12-12 15:09:36");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("57", "999", "action complete via WP Cron", "2025-12-12 15:09:36", "2025-12-12 15:09:36");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("58", "995", "action started via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("59", "995", "action complete via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("60", "1000", "action created", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("61", "996", "action started via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("62", "996", "action complete via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("63", "1001", "action created", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("64", "997", "action started via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("65", "997", "action complete via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("66", "1002", "action created", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("67", "998", "action started via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("68", "998", "action complete via WP Cron", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("69", "1003", "action created", "2025-12-13 06:07:41", "2025-12-13 06:07:41");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("70", "1000", "action started via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("71", "1000", "action complete via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("72", "1004", "action created", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("73", "1001", "action started via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("74", "1001", "action complete via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("75", "1005", "action created", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("76", "1002", "action started via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("77", "1002", "action complete via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("78", "1006", "action created", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("79", "1003", "action started via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("80", "1003", "action complete via WP Cron", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("81", "1007", "action created", "2025-12-14 06:13:05", "2025-12-14 06:13:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("82", "1004", "action started via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("83", "1004", "action complete via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("84", "1008", "action created", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("85", "1005", "action started via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("86", "1005", "action complete via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("87", "1009", "action created", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("88", "1006", "action started via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("89", "1006", "action complete via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("90", "1010", "action created", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("91", "1007", "action started via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("92", "1007", "action complete via WP Cron", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("93", "1011", "action created", "2025-12-15 06:15:50", "2025-12-15 06:15:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("94", "980", "action started via WP Cron", "2025-12-15 16:24:13", "2025-12-15 16:24:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("95", "980", "action complete via WP Cron", "2025-12-15 16:24:13", "2025-12-15 16:24:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("96", "1012", "action created", "2025-12-15 16:24:13", "2025-12-15 16:24:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("97", "1008", "action started via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("98", "1008", "action complete via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("99", "1013", "action created", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("100", "1009", "action started via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("101", "1009", "action complete via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("102", "1014", "action created", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("103", "1010", "action started via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("104", "1010", "action complete via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("105", "1015", "action created", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("106", "1011", "action started via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("107", "1011", "action complete via WP Cron", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("108", "1016", "action created", "2025-12-16 06:27:58", "2025-12-16 06:27:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("109", "986", "action started via WP Cron", "2025-12-17 07:27:27", "2025-12-17 07:27:27");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("110", "986", "action complete via WP Cron", "2025-12-17 07:27:27", "2025-12-17 07:27:27");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("111", "1017", "action created", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("112", "1013", "action started via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("113", "1013", "action complete via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("114", "1018", "action created", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("115", "1014", "action started via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("116", "1014", "action complete via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("117", "1019", "action created", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("118", "1015", "action started via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("119", "1015", "action complete via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("120", "1020", "action created", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("121", "1016", "action started via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("122", "1016", "action complete via WP Cron", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("123", "1021", "action created", "2025-12-17 07:27:28", "2025-12-17 07:27:28");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("124", "1018", "action started via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("125", "1018", "action complete via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("126", "1022", "action created", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("127", "1019", "action started via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("128", "1019", "action complete via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("129", "1023", "action created", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("130", "1020", "action started via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("131", "1020", "action complete via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("132", "1024", "action created", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("133", "1021", "action started via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("134", "1021", "action complete via WP Cron", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("135", "1025", "action created", "2025-12-18 07:54:44", "2025-12-18 07:54:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("136", "1022", "action started via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("137", "1022", "action complete via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("138", "1026", "action created", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("139", "1023", "action started via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("140", "1023", "action complete via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("141", "1027", "action created", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("142", "1024", "action started via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("143", "1024", "action complete via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("144", "1028", "action created", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("145", "1025", "action started via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("146", "1025", "action complete via WP Cron", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("147", "1029", "action created", "2025-12-19 08:26:31", "2025-12-19 08:26:31");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("148", "1026", "action started via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("149", "1026", "action complete via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("150", "1030", "action created", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("151", "1027", "action started via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("152", "1027", "action complete via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("153", "1031", "action created", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("154", "1028", "action started via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("155", "1028", "action complete via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("156", "1032", "action created", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("157", "1029", "action started via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("158", "1029", "action complete via WP Cron", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("159", "1033", "action created", "2025-12-20 09:10:47", "2025-12-20 09:10:47");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("160", "1030", "action started via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("161", "1030", "action complete via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("162", "1034", "action created", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("163", "1031", "action started via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("164", "1031", "action complete via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("165", "1035", "action created", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("166", "1032", "action started via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("167", "1032", "action complete via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("168", "1036", "action created", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("169", "1033", "action started via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("170", "1033", "action complete via WP Cron", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("171", "1037", "action created", "2025-12-21 09:11:46", "2025-12-21 09:11:46");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("172", "1038", "action created", "2025-12-22 01:19:04", "2025-12-22 01:19:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("173", "1038", "action started via Async Request", "2025-12-22 01:19:07", "2025-12-22 01:19:07");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("174", "1038", "action complete via Async Request", "2025-12-22 01:19:07", "2025-12-22 01:19:07");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("175", "1034", "action started via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("176", "1034", "action complete via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("177", "1039", "action created", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("178", "1035", "action started via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("179", "1035", "action complete via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("180", "1040", "action created", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("181", "1036", "action started via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("182", "1036", "action complete via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("183", "1041", "action created", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("184", "1037", "action started via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("185", "1037", "action complete via WP Cron", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("186", "1042", "action created", "2025-12-22 09:14:51", "2025-12-22 09:14:51");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("187", "1012", "action started via Async Request", "2025-12-22 16:24:27", "2025-12-22 16:24:27");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("188", "1012", "action complete via Async Request", "2025-12-22 16:24:27", "2025-12-22 16:24:27");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("189", "1043", "action created", "2025-12-22 16:24:27", "2025-12-22 16:24:27");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("190", "1039", "action started via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("191", "1039", "action complete via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("192", "1044", "action created", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("193", "1040", "action started via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("194", "1040", "action complete via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("195", "1045", "action created", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("196", "1041", "action started via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("197", "1041", "action complete via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("198", "1046", "action created", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("199", "1042", "action started via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("200", "1042", "action complete via WP Cron", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("201", "1047", "action created", "2025-12-23 09:19:25", "2025-12-23 09:19:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("202", "1048", "action created", "2025-12-23 10:36:13", "2025-12-23 10:36:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("203", "1048", "action started via WP Cron", "2025-12-23 10:36:17", "2025-12-23 10:36:17");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("204", "1048", "action complete via WP Cron", "2025-12-23 10:36:17", "2025-12-23 10:36:17");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("205", "1017", "action started via WP Cron", "2025-12-24 07:36:53", "2025-12-24 07:36:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("206", "1017", "action complete via WP Cron", "2025-12-24 07:36:53", "2025-12-24 07:36:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("207", "1049", "action created", "2025-12-24 07:36:53", "2025-12-24 07:36:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("208", "1044", "action started via WP Cron", "2025-12-24 09:21:14", "2025-12-24 09:21:14");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("209", "1044", "action complete via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("210", "1050", "action created", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("211", "1045", "action started via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("212", "1045", "action complete via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("213", "1051", "action created", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("214", "1046", "action started via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("215", "1046", "action complete via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("216", "1052", "action created", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("217", "1047", "action started via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("218", "1047", "action complete via WP Cron", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("219", "1053", "action created", "2025-12-24 09:21:15", "2025-12-24 09:21:15");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("220", "1054", "action created", "2025-12-24 16:01:53", "2025-12-24 16:01:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("221", "1054", "action started via WP Cron", "2025-12-24 16:01:55", "2025-12-24 16:01:55");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("222", "1054", "action complete via WP Cron", "2025-12-24 16:01:55", "2025-12-24 16:01:55");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("223", "1050", "action started via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("224", "1050", "action complete via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("225", "1055", "action created", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("226", "1051", "action started via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("227", "1051", "action complete via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("228", "1056", "action created", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("229", "1052", "action started via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("230", "1052", "action complete via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("231", "1057", "action created", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("232", "1053", "action started via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("233", "1053", "action complete via WP Cron", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("234", "1058", "action created", "2025-12-25 09:25:25", "2025-12-25 09:25:25");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("235", "1059", "action created", "2025-12-26 03:23:03", "2025-12-26 03:23:03");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("236", "1059", "action started via Async Request", "2025-12-26 03:23:06", "2025-12-26 03:23:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("237", "1059", "action complete via Async Request", "2025-12-26 03:23:06", "2025-12-26 03:23:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("238", "1055", "action started via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("239", "1055", "action complete via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("240", "1060", "action created", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("241", "1056", "action started via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("242", "1056", "action complete via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("243", "1061", "action created", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("244", "1057", "action started via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("245", "1057", "action complete via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("246", "1062", "action created", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("247", "1058", "action started via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("248", "1058", "action complete via WP Cron", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("249", "1063", "action created", "2025-12-26 09:25:32", "2025-12-26 09:25:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("250", "1060", "action started via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("251", "1060", "action complete via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("252", "1064", "action created", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("253", "1061", "action started via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("254", "1061", "action complete via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("255", "1065", "action created", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("256", "1062", "action started via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("257", "1062", "action complete via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("258", "1066", "action created", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("259", "1063", "action started via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("260", "1063", "action complete via WP Cron", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("261", "1067", "action created", "2025-12-27 09:29:06", "2025-12-27 09:29:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("262", "1068", "action created", "2025-12-27 23:36:06", "2025-12-27 23:36:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("263", "1068", "action started via WP Cron", "2025-12-27 23:36:42", "2025-12-27 23:36:42");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("264", "1068", "action complete via WP Cron", "2025-12-27 23:36:42", "2025-12-27 23:36:42");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("265", "1064", "action started via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("266", "1064", "action complete via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("267", "1069", "action created", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("268", "1065", "action started via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("269", "1065", "action complete via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("270", "1070", "action created", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("271", "1066", "action started via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("272", "1066", "action complete via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("273", "1071", "action created", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("274", "1067", "action started via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("275", "1067", "action complete via WP Cron", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("276", "1072", "action created", "2025-12-28 09:34:06", "2025-12-28 09:34:06");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("277", "1073", "action created", "2025-12-29 01:45:00", "2025-12-29 01:45:00");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("278", "1073", "action started via Async Request", "2025-12-29 01:45:05", "2025-12-29 01:45:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("279", "1073", "action complete via Async Request", "2025-12-29 01:45:05", "2025-12-29 01:45:05");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("280", "1069", "action started via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("281", "1069", "action complete via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("282", "1074", "action created", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("283", "1070", "action started via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("284", "1070", "action complete via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("285", "1075", "action created", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("286", "1071", "action started via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("287", "1071", "action complete via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("288", "1076", "action created", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("289", "1072", "action started via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("290", "1072", "action complete via WP Cron", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("291", "1077", "action created", "2025-12-29 09:37:02", "2025-12-29 09:37:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("292", "1043", "action started via WP Cron", "2025-12-29 17:14:42", "2025-12-29 17:14:42");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("293", "1043", "action complete via WP Cron", "2025-12-29 17:14:43", "2025-12-29 17:14:43");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("294", "1078", "action created", "2025-12-29 17:14:43", "2025-12-29 17:14:43");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("295", "1074", "action started via WP Cron", "2025-12-30 09:46:38", "2025-12-30 09:46:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("296", "1074", "action complete via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("297", "1079", "action created", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("298", "1075", "action started via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("299", "1075", "action complete via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("300", "1080", "action created", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("301", "1076", "action started via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("302", "1076", "action complete via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("303", "1081", "action created", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("304", "1077", "action started via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("305", "1077", "action complete via WP Cron", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("306", "1082", "action created", "2025-12-30 09:46:39", "2025-12-30 09:46:39");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("307", "1083", "action created", "2025-12-30 16:00:04", "2025-12-30 16:00:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("308", "1083", "action started via WP Cron", "2025-12-30 16:00:07", "2025-12-30 16:00:07");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("309", "1083", "action complete via WP Cron", "2025-12-30 16:00:07", "2025-12-30 16:00:07");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("310", "1049", "action started via WP Cron", "2025-12-31 07:43:48", "2025-12-31 07:43:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("311", "1049", "action complete via WP Cron", "2025-12-31 07:43:48", "2025-12-31 07:43:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("312", "1084", "action created", "2025-12-31 07:43:48", "2025-12-31 07:43:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("313", "1079", "action started via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("314", "1079", "action complete via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("315", "1085", "action created", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("316", "1080", "action started via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("317", "1080", "action complete via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("318", "1086", "action created", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("319", "1081", "action started via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("320", "1081", "action complete via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("321", "1087", "action created", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("322", "1082", "action started via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("323", "1082", "action complete via WP Cron", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("324", "1088", "action created", "2025-12-31 09:50:38", "2025-12-31 09:50:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("325", "1085", "action started via WP Cron", "2026-01-01 10:02:32", "2026-01-01 10:02:32");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("326", "1085", "action complete via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("327", "1089", "action created", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("328", "1086", "action started via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("329", "1086", "action complete via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("330", "1090", "action created", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("331", "1087", "action started via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("332", "1087", "action complete via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("333", "1091", "action created", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("334", "1088", "action started via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("335", "1088", "action complete via WP Cron", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("336", "1092", "action created", "2026-01-01 10:02:33", "2026-01-01 10:02:33");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("337", "1089", "action started via WP Cron", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("338", "1089", "action complete via WP Cron", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("339", "1093", "action created", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("340", "1090", "action started via WP Cron", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("341", "1090", "action complete via WP Cron", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("342", "1094", "action created", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("343", "1091", "action started via WP Cron", "2026-01-02 10:06:44", "2026-01-02 10:06:44");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("344", "1091", "action complete via WP Cron", "2026-01-02 10:06:45", "2026-01-02 10:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("345", "1095", "action created", "2026-01-02 10:06:45", "2026-01-02 10:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("346", "1092", "action started via WP Cron", "2026-01-02 10:06:45", "2026-01-02 10:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("347", "1092", "action complete via WP Cron", "2026-01-02 10:06:45", "2026-01-02 10:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("348", "1096", "action created", "2026-01-02 10:06:45", "2026-01-02 10:06:45");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("349", "1093", "action started via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("350", "1093", "action complete via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("351", "1097", "action created", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("352", "1094", "action started via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("353", "1094", "action complete via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("354", "1098", "action created", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("355", "1095", "action started via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("356", "1095", "action complete via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("357", "1099", "action created", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("358", "1096", "action started via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("359", "1096", "action complete via WP Cron", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("360", "1100", "action created", "2026-01-03 13:33:38", "2026-01-03 13:33:38");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("361", "1097", "action started via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("362", "1097", "action complete via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("363", "1101", "action created", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("364", "1098", "action started via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("365", "1098", "action complete via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("366", "1102", "action created", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("367", "1099", "action started via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("368", "1099", "action complete via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("369", "1103", "action created", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("370", "1100", "action started via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("371", "1100", "action complete via WP Cron", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("372", "1104", "action created", "2026-01-04 14:25:20", "2026-01-04 14:25:20");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("373", "1101", "action started via WP Cron", "2026-01-05 16:55:18", "2026-01-05 16:55:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("374", "1101", "action complete via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("375", "1105", "action created", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("376", "1102", "action started via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("377", "1102", "action complete via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("378", "1106", "action created", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("379", "1103", "action started via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("380", "1103", "action complete via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("381", "1107", "action created", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("382", "1104", "action started via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("383", "1104", "action complete via WP Cron", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("384", "1108", "action created", "2026-01-05 16:55:19", "2026-01-05 16:55:19");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("385", "1078", "action started via WP Cron", "2026-01-05 19:07:48", "2026-01-05 19:07:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("386", "1078", "action complete via WP Cron", "2026-01-05 19:07:48", "2026-01-05 19:07:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("387", "1109", "action created", "2026-01-05 19:07:48", "2026-01-05 19:07:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("388", "1105", "action started via WP Cron", "2026-01-06 16:56:52", "2026-01-06 16:56:52");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("389", "1105", "action complete via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("390", "1110", "action created", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("391", "1106", "action started via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("392", "1106", "action complete via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("393", "1111", "action created", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("394", "1107", "action started via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("395", "1107", "action complete via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("396", "1112", "action created", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("397", "1108", "action started via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("398", "1108", "action complete via WP Cron", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("399", "1113", "action created", "2026-01-06 16:56:53", "2026-01-06 16:56:53");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("400", "1114", "action created", "2026-01-07 05:33:58", "2026-01-07 05:33:58");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("401", "1114", "action started via Async Request", "2026-01-07 05:34:02", "2026-01-07 05:34:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("402", "1114", "action complete via Async Request", "2026-01-07 05:34:02", "2026-01-07 05:34:02");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("403", "1084", "action started via Async Request", "2026-01-07 07:46:18", "2026-01-07 07:46:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("404", "1084", "action complete via Async Request", "2026-01-07 07:46:18", "2026-01-07 07:46:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("405", "1115", "action created", "2026-01-07 07:46:18", "2026-01-07 07:46:18");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("406", "1110", "action started via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("407", "1110", "action complete via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("408", "1116", "action created", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("409", "1111", "action started via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("410", "1111", "action complete via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("411", "1117", "action created", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("412", "1112", "action started via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("413", "1112", "action complete via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("414", "1118", "action created", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("415", "1113", "action started via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("416", "1113", "action complete via WP Cron", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("417", "1119", "action created", "2026-01-07 18:33:04", "2026-01-07 18:33:04");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("418", "1116", "action started via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("419", "1116", "action complete via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("420", "1120", "action created", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("421", "1117", "action started via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("422", "1117", "action complete via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("423", "1121", "action created", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("424", "1118", "action started via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("425", "1118", "action complete via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("426", "1122", "action created", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("427", "1119", "action started via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("428", "1119", "action complete via WP Cron", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("429", "1123", "action created", "2026-01-08 21:44:13", "2026-01-08 21:44:13");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("430", "1124", "action created", "2026-01-09 01:32:48", "2026-01-09 01:32:48");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("431", "1124", "action started via WP Cron", "2026-01-09 01:32:50", "2026-01-09 01:32:50");
INSERT INTO `JQx2cw4_actionscheduler_logs` VALUES("432", "1124", "action complete via WP Cron", "2026-01-09 01:32:52", "2026-01-09 01:32:52");

/* INSERT TABLE DATA: JQx2cw4_duplicator_packages */
INSERT INTO `JQx2cw4_duplicator_packages` VALUES("1", "migration_to_websitesonabudget", "91253e3fdefab94d2739_20260109120835", "21", "2026-01-09 12:09:08", "websiteonabudget", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-09 12:08:35\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:30:\"migration_to_websitesonabudget\";s:4:\"Hash\";s:35:\"91253e3fdefab94d2739_20260109120835\";s:8:\"NameHash\";s:66:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:76:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:16:\"websiteonabudget\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:78:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:66:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:6411;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:34224;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-01-09 12:08:35\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.1.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:30:\"migration_to_websitesonabudget\";s:4:\"Hash\";s:35:\"91253e3fdefab94d2739_20260109120835\";s:8:\"NameHash\";s:66:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:84:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:80:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:79:\"migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:178:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/backups-dup-lite/tmp/migration_to_websitesonabudget_91253e3fdefab94d2739_20260109120835_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:75:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-admin\";i:1;s:78:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-includes\";i:2;s:87:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:66:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com\";i:1;s:66:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com\";i:2;s:77:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content\";i:3;s:85:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/uploads\";i:4;s:85:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/plugins\";i:5;s:88:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/mu-plugins\";i:6;s:84:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:98:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: JQx2cw4_options */
INSERT INTO `JQx2cw4_options` VALUES("1", "cron", "a:20:{i:1767960568;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1767960988;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1767963363;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1767964809;a:1:{s:22:\"seedprod_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1767965162;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1767966962;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768002963;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768002992;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768004188;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768007621;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768126823;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768176000;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1768226400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768262214;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768311444;a:1:{s:26:\"pbb_analytics_expiry_clean\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768348563;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768483209;a:1:{s:29:\"seedprod_lite_fetch_help_docs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768493606;a:1:{s:15:\"pbb_daily_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768531487;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `JQx2cw4_options` VALUES("2", "siteurl", "https://websiteonabudget.thebootroomhq.com", "on");
INSERT INTO `JQx2cw4_options` VALUES("3", "home", "https://websiteonabudget.thebootroomhq.com", "on");
INSERT INTO `JQx2cw4_options` VALUES("4", "blogname", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("7", "admin_email", "admin@websiteonabudget.thebootroomhq.com", "on");
INSERT INTO `JQx2cw4_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `JQx2cw4_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `JQx2cw4_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `JQx2cw4_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `JQx2cw4_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `JQx2cw4_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `JQx2cw4_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `JQx2cw4_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `JQx2cw4_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `JQx2cw4_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `JQx2cw4_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `JQx2cw4_options` VALUES("30", "rewrite_rules", "a:225:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:20:\"emailkit-template/?$\";s:28:\"index.php?post_type=emailkit\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:47:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"theme-advanced-hook/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"theme-advanced-hook/([^/]+)/embed/?$\";s:52:\"index.php?theme-advanced-hook=$matches[1]&embed=true\";s:40:\"theme-advanced-hook/([^/]+)/trackback/?$\";s:46:\"index.php?theme-advanced-hook=$matches[1]&tb=1\";s:48:\"theme-advanced-hook/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?theme-advanced-hook=$matches[1]&paged=$matches[2]\";s:55:\"theme-advanced-hook/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?theme-advanced-hook=$matches[1]&cpage=$matches[2]\";s:44:\"theme-advanced-hook/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?theme-advanced-hook=$matches[1]&page=$matches[2]\";s:36:\"theme-advanced-hook/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"theme-advanced-hook/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"theme-advanced-hook/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"theme-advanced-hook/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"theme-advanced-hook/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"theme-advanced-hook/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"class-manager/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"class-manager/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"class-manager/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"class-manager/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"class-manager/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"class-manager/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"class-manager/(.+?)/embed/?$\";s:46:\"index.php?class-manager=$matches[1]&embed=true\";s:32:\"class-manager/(.+?)/trackback/?$\";s:40:\"index.php?class-manager=$matches[1]&tb=1\";s:40:\"class-manager/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?class-manager=$matches[1]&paged=$matches[2]\";s:47:\"class-manager/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?class-manager=$matches[1]&cpage=$matches[2]\";s:36:\"class-manager/(.+?)(?:/([0-9]+))?/?$\";s:52:\"index.php?class-manager=$matches[1]&page=$matches[2]\";s:40:\"elementor-hf/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"elementor-hf/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"elementor-hf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"elementor-hf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"elementor-hf/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"elementor-hf/([^/]+)/embed/?$\";s:45:\"index.php?elementor-hf=$matches[1]&embed=true\";s:33:\"elementor-hf/([^/]+)/trackback/?$\";s:39:\"index.php?elementor-hf=$matches[1]&tb=1\";s:41:\"elementor-hf/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&paged=$matches[2]\";s:48:\"elementor-hf/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?elementor-hf=$matches[1]&cpage=$matches[2]\";s:37:\"elementor-hf/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?elementor-hf=$matches[1]&page=$matches[2]\";s:29:\"elementor-hf/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"elementor-hf/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"elementor-hf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"elementor-hf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"elementor-hf/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"popupkit-campaigns/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"popupkit-campaigns/([^/]+)/embed/?$\";s:51:\"index.php?popupkit-campaigns=$matches[1]&embed=true\";s:39:\"popupkit-campaigns/([^/]+)/trackback/?$\";s:45:\"index.php?popupkit-campaigns=$matches[1]&tb=1\";s:47:\"popupkit-campaigns/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?popupkit-campaigns=$matches[1]&paged=$matches[2]\";s:54:\"popupkit-campaigns/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?popupkit-campaigns=$matches[1]&cpage=$matches[2]\";s:43:\"popupkit-campaigns/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?popupkit-campaigns=$matches[1]&page=$matches[2]\";s:35:\"popupkit-campaigns/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"popupkit-campaigns/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"popupkit-campaigns/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"popupkit-campaigns/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"popupkit-campaigns/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"popupkit-campaigns/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"emailkit-template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"emailkit-template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"emailkit-template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"emailkit-template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"emailkit-template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"emailkit-template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"emailkit-template/([^/]+)/embed/?$\";s:41:\"index.php?emailkit=$matches[1]&embed=true\";s:38:\"emailkit-template/([^/]+)/trackback/?$\";s:35:\"index.php?emailkit=$matches[1]&tb=1\";s:46:\"emailkit-template/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?emailkit=$matches[1]&paged=$matches[2]\";s:53:\"emailkit-template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?emailkit=$matches[1]&cpage=$matches[2]\";s:42:\"emailkit-template/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?emailkit=$matches[1]&page=$matches[2]\";s:34:\"emailkit-template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"emailkit-template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"emailkit-template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"emailkit-template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"emailkit-template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"emailkit-template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:44:\"index.php?elemenfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:38:\"index.php?elemenfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?elemenfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?elemenfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?elemenfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"portfoliocategory/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?elemenfoliocategory=$matches[1]&feed=$matches[2]\";s:53:\"portfoliocategory/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?elemenfoliocategory=$matches[1]&feed=$matches[2]\";s:34:\"portfoliocategory/([^/]+)/embed/?$\";s:52:\"index.php?elemenfoliocategory=$matches[1]&embed=true\";s:46:\"portfoliocategory/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elemenfoliocategory=$matches[1]&paged=$matches[2]\";s:28:\"portfoliocategory/([^/]+)/?$\";s:41:\"index.php?elemenfoliocategory=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1510&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `JQx2cw4_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `JQx2cw4_options` VALUES("34", "active_plugins", "a:35:{i:0;s:19:\"akismet/akismet.php\";i:1;s:27:\"astra-sites/astra-sites.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:31:\"elementor-pro/elementor-pro.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:37:\"elementskit-lite/elementskit-lite.php\";i:8;s:21:\"emailkit/EmailKit.php\";i:9;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:10;s:21:\"getgenie/getgenie.php\";i:11;s:47:\"gutenkit-blocks-addon/gutenkit-blocks-addon.php\";i:12;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:13;s:29:\"health-check/health-check.php\";i:14;s:19:\"jetpack/jetpack.php\";i:15;s:23:\"ml-slider/ml-slider.php\";i:16;s:29:\"mystickymenu/mystickymenu.php\";i:17;s:43:\"popup-builder-block/popup-builder-block.php\";i:18;s:43:\"portfolio-elementor/portfolio-elementor.php\";i:19;s:57:\"powerpack-lite-for-elementor/powerpack-lite-elementor.php\";i:20;s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";i:21;s:67:\"responsive-addons-for-elementor/responsive-addons-for-elementor.php\";i:22;s:37:\"royal-elementor-addons/wpr-addons.php\";i:23;s:79:\"sastra-essential-addons-for-elementor/sastra-essential-addons-for-elementor.php\";i:24;s:25:\"shopengine/shopengine.php\";i:25;s:32:\"slider-hero/qcld-slider-main.php\";i:26;s:75:\"sticky-header-effects-for-elementor/sticky-header-effects-for-elementor.php\";i:27;s:70:\"the-plus-addons-for-elementor-page-builder/theplus_elementor_addon.php\";i:28;s:25:\"wdesignkit/wdesignkit.php\";i:29;s:33:\"wp-call-button/wp-call-button.php\";i:30;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:31;s:23:\"wp-social/wp-social.php\";i:32;s:41:\"wp-ultimate-review/wp-ultimate-review.php\";i:33;s:33:\"wpcf7-redirect/wpcf7-redirect.php\";i:34;s:24:\"wpforms-lite/wpforms.php\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("35", "category_base", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `JQx2cw4_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `JQx2cw4_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `JQx2cw4_options` VALUES("41", "template", "astra", "on");
INSERT INTO `JQx2cw4_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `JQx2cw4_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `JQx2cw4_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `JQx2cw4_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `JQx2cw4_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `JQx2cw4_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `JQx2cw4_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `JQx2cw4_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `JQx2cw4_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `JQx2cw4_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `JQx2cw4_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `JQx2cw4_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `JQx2cw4_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `JQx2cw4_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `JQx2cw4_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `JQx2cw4_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `JQx2cw4_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `JQx2cw4_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `JQx2cw4_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `JQx2cw4_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `JQx2cw4_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `JQx2cw4_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("80", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";a:2:{i:0;s:30:\"PremiumAddons\\Includes\\PA_Core\";i:1;s:9:\"uninstall\";}s:33:\"wp-call-button/wp-call-button.php\";s:29:\"wp_call_button_uninstall_hook\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `JQx2cw4_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("83", "page_on_front", "1510", "on");
INSERT INTO `JQx2cw4_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("87", "site_icon", "135", "on");
INSERT INTO `JQx2cw4_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `JQx2cw4_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `JQx2cw4_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("92", "admin_email_lifespan", "1779580562", "on");
INSERT INTO `JQx2cw4_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `JQx2cw4_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `JQx2cw4_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `JQx2cw4_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `JQx2cw4_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `JQx2cw4_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `JQx2cw4_options` VALUES("102", "JQx2cw4_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:13:\"edit_emailkit\";b:1;s:20:\"edit_others_emailkit\";b:1;s:16:\"publish_emailkit\";b:1;s:13:\"read_emailkit\";b:1;s:21:\"read_private_emailkit\";b:1;s:15:\"delete_emailkit\";b:1;s:23:\"edit_published_emailkit\";b:1;s:17:\"delete_published_\";b:1;s:13:\"publish_popup\";b:1;s:10:\"edit_popup\";b:1;s:12:\"delete_popup\";b:1;s:18:\"read_private_popup\";b:1;s:10:\"read_popup\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `JQx2cw4_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `JQx2cw4_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `JQx2cw4_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("106", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `JQx2cw4_options` VALUES("125", "nonce_key", "&?W%p364uqXGf4GZN=(/,g-4vErV0(J`W%/J~vo&>N2SQXl=m#&NXk87|[5rg.;t", "off");
INSERT INTO `JQx2cw4_options` VALUES("126", "nonce_salt", "}Z*)ToUNTyw<x#A1*!!`n99gFq.p./n:!,^!uD-[R.2^,xFDsSXl(ed#D_$,yY C", "off");
INSERT INTO `JQx2cw4_options` VALUES("127", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1764028640;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"3199e2537fbad380fa221e097719f7c6\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `JQx2cw4_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("160", "current_theme", "Astra", "auto");
INSERT INTO `JQx2cw4_options` VALUES("161", "theme_mods_astra", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:3;s:11:\"mobile_menu\";i:4;}s:18:\"custom_css_post_id\";i:518;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1764180111;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}}}s:11:\"custom_logo\";s:0:\"\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("162", "theme_switched", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("165", "astra-settings", "a:9:{s:18:\"theme-auto-version\";s:6:\"4.12.0\";s:22:\"is_theme_queue_running\";b:0;s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:0:{}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:0:{}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";i:90;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";i:50;}s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:0:{}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:0:{}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:1;}s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:20:\"global-color-palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F0F5FA\";i:6;s:7:\"#111111\";i:7;s:7:\"#D1D5DB\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:23:\"footer-copyright-editor\";s:58:\"Copyright [copyright] [current_year] | All Rights Reserved\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("166", "allowed_astra_notices", "a:5:{i:0;s:21:\"astra-sites-on-active\";i:1;s:16:\"bsf-optin-notice\";i:2;s:26:\"astra-sites-welcome-notice\";i:3;s:16:\"uae-optin-notice\";i:4;s:18:\"astra-optin-notice\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("167", "astra_analytics_installed_time", "1764028641", "off");
INSERT INTO `JQx2cw4_options` VALUES("173", "finished_updating_comment_type", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("180", "WPLANG", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("181", "new_admin_email", "admin@websiteonabudget.thebootroomhq.com", "auto");
INSERT INTO `JQx2cw4_options` VALUES("188", "_site_transient_wp_plugin_dependencies_plugin_data", "a:2:{s:14:\"contact-form-7\";a:35:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:7:\"version\";s:5:\"6.1.4\";s:6:\"author\";s:78:\"<a href=\"https://profiles.wordpress.org/rocklobsterinc/\">Rock Lobster Inc.</a>\";s:14:\"author_profile\";s:46:\"https://profiles.wordpress.org/rocklobsterinc/\";s:12:\"contributors\";a:2:{s:14:\"rocklobsterinc\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/rocklobsterinc/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/4aa558df1c07e327536d8d0adad6d00fcdca0484c51adf0b867a2aa5ee054bbc?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Rock Lobster Inc.\";}s:12:\"takayukister\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/takayukister/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/538487024e649d43dea84ff38d14582d03119e3e7aaaca3b7692443335999133?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Takayuki Miyoshi\";}}s:8:\"requires\";s:3:\"6.7\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:80;s:7:\"ratings\";a:5:{i:5;i:1451;i:4;i:148;i:3;i:75;i:2;i:68;i:1;i:405;}s:11:\"num_ratings\";i:2147;s:11:\"support_url\";s:52:\"https://wordpress.org/support/plugin/contact-form-7/\";s:15:\"support_threads\";i:69;s:24:\"support_threads_resolved\";i:22;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2025-11-30 7:47am GMT\";s:5:\"added\";s:10:\"2007-08-02\";s:8:\"homepage\";s:25:\"https://contactform7.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:2525:\"<p>Contact Form 7 is a plugin designed to be a practical tool for all WordPress users who embrace the philosophy of free and open source software. It employs sophisticatedly modularized architecture and its original <a href=\"https://contactform7.com/schema-woven-validation/\" rel=\"nofollow ugc\">Schema-Woven Validation</a> technology.</p>\n<h4>Docs and support</h4>\n<p>You can find <a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">docs</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a> and more detailed information about Contact Form 7 on <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">contactform7.com</a>. When you cannot find the answer to your question on the FAQ or in any of the documentation, check the <a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"ugc\">support forum</a> on WordPress.org. If you cannot locate any topics that pertain to your particular issue, post a new topic for it.</p>\n<h4>Contact Form 7 needs your support</h4>\n<p>It is hard to continue to maintain this plugin without support from users like you. There are several ways for you to <a href=\"https://contactform7.com/contributing/\" rel=\"nofollow ugc\">contribute to the project</a>: testing, coding, translating it into your local languages, helping other users, financial donations, etc, etc. We equally welcome you regardless of the way you contribute.</p>\n<h4>Privacy notices</h4>\n<p>With the default configuration, this plugin, in itself, does not:</p>\n<ul>\n<li>track users by stealth;</li>\n<li>write any user personal data to the database;</li>\n<li>send any data to external servers;</li>\n<li>use cookies.</li>\n</ul>\n<p>If you activate certain features in this plugin, the contact form submitter&#8217;s personal data, including their IP address, may be sent to the service provider. Thus, confirming the provider&#8217;s privacy policy is recommended. These features include:</p>\n<ul>\n<li>reCAPTCHA (<a href=\"https://policies.google.com/?hl=en\" rel=\"nofollow ugc\">Google</a>)</li>\n<li>Akismet (<a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">Automattic</a>)</li>\n<li><a href=\"https://www.constantcontact.com/legal/privacy-center\" rel=\"nofollow ugc\">Constant Contact</a></li>\n<li><a href=\"https://www.brevo.com/legal/privacypolicy/\" rel=\"nofollow ugc\">Brevo</a></li>\n<li><a href=\"https://stripe.com/privacy\" rel=\"nofollow ugc\">Stripe</a></li>\n<li>Turnstile (<a href=\"https://www.cloudflare.com/turnstile-privacy-policy/\" rel=\"nofollow ugc\">Cloudflare</a>)</li>\n</ul>\n\";s:12:\"installation\";s:458:\"<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the <strong>Plugins</strong> screen (<strong>Plugins &gt; Installed Plugins</strong>).</li>\n</ol>\n<p>You will find <strong>Contact</strong> menu in your WordPress admin screen.</p>\n<p>For basic usage, have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow ugc\">plugin&#8217;s website</a>.</p>\n\";s:3:\"faq\";s:449:\"<p>Do you have questions or issues with Contact Form 7? Use these support channels appropriately.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow ugc\">Docs</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow ugc\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"ugc\">Support forum</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow ugc\">Support</a></p>\n\";s:9:\"changelog\";s:1771:\"<p>For more information, see <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow ugc\">Releases</a>.</p>\n<h4>6.1.4</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-614/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-614/</a></p>\n<h4>6.1.3</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-613/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-613/</a></p>\n<h4>6.1.2</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-612/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-612/</a></p>\n<h4>6.1.1</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-611/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-611/</a></p>\n<h4>6.1</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-61/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-61/</a></p>\n<h4>6.0.5</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-605/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-605/</a></p>\n<h4>6.0.4</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-604/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-604/</a></p>\n<h4>6.0.3</h4>\n<ul>\n<li>Updates the copyright year to 2025.</li>\n<li>Updates the &#8220;Contact Form 7 needs your support&#8221; message content.</li>\n<li>Updates the Constant Contact deprecation warning.</li>\n</ul>\n<h4>6.0.2</h4>\n<ul>\n<li>Removes unnecessary type declaration from nullable arguments to avoid deprecation warnings in PHP 8.4.</li>\n</ul>\n<h4>6.0.1</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-601/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-601/</a></p>\n<h4>6.0</h4>\n<p><a href=\"https://contactform7.com/contact-form-7-60/\" rel=\"nofollow ugc\">https://contactform7.com/contact-form-7-60/</a></p>\n\";s:11:\"screenshots\";s:225:\"<ol><li><a href=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\"><img src=\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\" alt=\"screenshot-1.png\"></a><p>screenshot-1.png</p></li></ol>\";s:7:\"reviews\";s:15432:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Simple and Reliable</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/harborherald95/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c81c1714b8cce81b3c3b47f0f3003cbc9b35730da5a7c180398a520cf835b288?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c81c1714b8cce81b3c3b47f0f3003cbc9b35730da5a7c180398a520cf835b288?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/harborherald95/\" class=\"reviewer-name\">harborherald95</a> on <span class=\"review-date\">December 30, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Contact Form 7 is a simple and reliable plugin for creating contact forms. Easy to set up and works perfectly for basic form needs.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Simple and functional</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/lukegarry/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c611d11fbc2697a87a888d1a9b792d23799ae131f520af2bfb546d3e1305969f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c611d11fbc2697a87a888d1a9b792d23799ae131f520af2bfb546d3e1305969f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/lukegarry/\" class=\"reviewer-name\">Luke Garrison <small>(lukegarry)</small></a> on <span class=\"review-date\">December 14, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I like this plugin because it\'s simple but works perfectly. It doesn\'t take hours to configure!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can&#039;t believe this is free</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/klearkrystal/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f2c10e29ef5a25b76a84a16b3286476ab7d891008d87ac3a4607aff6712c51f4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f2c10e29ef5a25b76a84a16b3286476ab7d891008d87ac3a4607aff6712c51f4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/klearkrystal/\" class=\"reviewer-name\">klearkrystal</a> on <span class=\"review-date\">December 11, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I can do anything related to forms with this plugin, for free. cant beleive it. Many thanks to the author!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">very happy with plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/sunshinefan/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/c7bca59cb4966de27ea733a4f1d18a06183341e9af279fe10aa312d44f2fa9d5?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/c7bca59cb4966de27ea733a4f1d18a06183341e9af279fe10aa312d44f2fa9d5?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/sunshinefan/\" class=\"reviewer-name\">sunshinefan</a> on <span class=\"review-date\">December 6, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'m happy with how easy it is to use and the form options</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not simple enough</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/whiteelephantagency/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d77da09e583e1566e62273a5270a884532349a7304b61f04956dfd6b4a919f5d?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d77da09e583e1566e62273a5270a884532349a7304b61f04956dfd6b4a919f5d?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/whiteelephantagency/\" class=\"reviewer-name\">whiteelephantagency</a> on <span class=\"review-date\">November 26, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Out of the box form with very little support and features. I\'ve always had issues with deliverability. I think they really shuold upgrade the interface and make it easier to actually create the forms. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Thank you</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/mjhabib4/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7846a00a11bed7886213dcbc07a83a13bc051b29eecb488b476b78558e57264a?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7846a00a11bed7886213dcbc07a83a13bc051b29eecb488b476b78558e57264a?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/mjhabib4/\" class=\"reviewer-name\">MJ Habib <small>(mjhabib4)</small></a> on <span class=\"review-date\">October 30, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Contact Form 7 remains one of my go-to form plugins because it’s simple, reliable, and flexible. Even though it\'s been around for years, it still works smoothly across themes and handles basic to moderately complex forms with ease. I appreciate its stability and commitment to free and open source.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Quiz (form field) only loads sometimes.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/braads/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/21a0e98a004178f29b071eff54cc482a2f4611eab3ee615cbaa59c428e4d8a8f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/21a0e98a004178f29b071eff54cc482a2f4611eab3ee615cbaa59c428e4d8a8f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/braads/\" class=\"reviewer-name\">Brad <small>(braads)</small></a> on <span class=\"review-date\">October 22, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'ve added a quiz to the contact form to prevent spam.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Sometimes the quiz (form field) loads, sometimes (well, most of the time) it doesn\'t. Very frustrating.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It\'s probably time for a new plugin. Contact Form 7 is now outdated.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/hiroshixo/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8ebc923f62bf4bc5c819c678bcd0f3e97beb55682b0da5498deaff72f2201f7f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8ebc923f62bf4bc5c819c678bcd0f3e97beb55682b0da5498deaff72f2201f7f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/hiroshixo/\" class=\"reviewer-name\">Hiroshi <small>(hiroshixo)</small></a> on <span class=\"review-date\">October 9, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>This is a great plugin, which I always use on almost all my websites. It just works. 👍</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Fantastic Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/nolanrichardson/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/00655133aac26f5bf75c73c0e19b965aea6a8758fe43d0899a529bb25c9a6d08?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/00655133aac26f5bf75c73c0e19b965aea6a8758fe43d0899a529bb25c9a6d08?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/nolanrichardson/\" class=\"reviewer-name\">nolanrichardson</a> on <span class=\"review-date\">October 2, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>It keeps things simple and functional</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">WordPress classic</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/diegobittencourt/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/57f994681397b666aadbdad1ab144ffef2ccbc3fe32f71a8bf23b8d2dfd03a0c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/57f994681397b666aadbdad1ab144ffef2ccbc3fe32f71a8bf23b8d2dfd03a0c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/diegobittencourt/\" class=\"reviewer-name\">Diego Bittencourt <small>(diegobittencourt)</small></a> on <span class=\"review-date\">August 30, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Great contribution to community just like Flamingo.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:13:\"download_link\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.4.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:1:{i:1;a:2:{s:3:\"src\";s:67:\"https://ps.w.org/contact-form-7/assets/screenshot-1.png?rev=1176454\";s:7:\"caption\";s:16:\"screenshot-1.png\";}}s:4:\"tags\";a:2:{s:12:\"contact-form\";s:12:\"contact form\";s:23:\"schema-woven-validation\";s:23:\"schema-woven validation\";}s:8:\"versions\";a:201:{s:3:\"1.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.1.zip\";s:4:\"1.10\";s:62:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.zip\";s:8:\"1.10.0.1\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.0.1.zip\";s:6:\"1.10.1\";s:64:\"https://downloads.wordpress.org/plugin/contact-form-7.1.10.1.zip\";s:3:\"1.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.2.zip\";s:3:\"1.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.zip\";s:5:\"1.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.1.zip\";s:5:\"1.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.3.2.zip\";s:3:\"1.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.zip\";s:5:\"1.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.1.zip\";s:5:\"1.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.2.zip\";s:5:\"1.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.3.zip\";s:5:\"1.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.4.4.zip\";s:3:\"1.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.5.zip\";s:3:\"1.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.zip\";s:5:\"1.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.6.1.zip\";s:3:\"1.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.zip\";s:5:\"1.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.1.zip\";s:5:\"1.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.2.zip\";s:5:\"1.7.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.4.zip\";s:5:\"1.7.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.5.zip\";s:5:\"1.7.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.zip\";s:7:\"1.7.6.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.6.1.zip\";s:5:\"1.7.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.zip\";s:7:\"1.7.7.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.7.1.zip\";s:5:\"1.7.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.7.8.zip\";s:3:\"1.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.zip\";s:7:\"1.8.0.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.1.zip\";s:7:\"1.8.0.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.2.zip\";s:7:\"1.8.0.3\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.3.zip\";s:7:\"1.8.0.4\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.0.4.zip\";s:5:\"1.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.zip\";s:7:\"1.8.1.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.8.1.1.zip\";s:3:\"1.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.zip\";s:5:\"1.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.1.zip\";s:5:\"1.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.zip\";s:7:\"1.9.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.1.zip\";s:7:\"1.9.2.2\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.2.2.zip\";s:5:\"1.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.3.zip\";s:5:\"1.9.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.4.zip\";s:5:\"1.9.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.zip\";s:7:\"1.9.5.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.1.9.5.1.zip\";s:3:\"2.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.zip\";s:8:\"2.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0-beta.zip\";s:5:\"2.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.1.zip\";s:5:\"2.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.2.zip\";s:5:\"2.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.3.zip\";s:5:\"2.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.4.zip\";s:5:\"2.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.5.zip\";s:5:\"2.0.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.6.zip\";s:5:\"2.0.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.0.7.zip\";s:3:\"2.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.zip\";s:5:\"2.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.1.zip\";s:5:\"2.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.1.2.zip\";s:3:\"2.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.zip\";s:5:\"2.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.2.1.zip\";s:3:\"2.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.zip\";s:5:\"2.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.3.1.zip\";s:3:\"2.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.zip\";s:5:\"2.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.1.zip\";s:5:\"2.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.2.zip\";s:5:\"2.4.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.3.zip\";s:5:\"2.4.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.4.zip\";s:5:\"2.4.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.5.zip\";s:5:\"2.4.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.2.4.6.zip\";s:3:\"3.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.zip\";s:8:\"3.0-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0-beta.zip\";s:5:\"3.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.1.zip\";s:5:\"3.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.zip\";s:7:\"3.0.2.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.3.0.2.1.zip\";s:3:\"3.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.zip\";s:5:\"3.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.1.zip\";s:5:\"3.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.1.2.zip\";s:3:\"3.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.zip\";s:5:\"3.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.2.1.zip\";s:3:\"3.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.zip\";s:5:\"3.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.1.zip\";s:5:\"3.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.2.zip\";s:5:\"3.3.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.3.3.zip\";s:3:\"3.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.zip\";s:5:\"3.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.1.zip\";s:5:\"3.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.4.2.zip\";s:3:\"3.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.zip\";s:5:\"3.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.1.zip\";s:5:\"3.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.2.zip\";s:5:\"3.5.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.3.zip\";s:5:\"3.5.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.5.4.zip\";s:3:\"3.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.6.zip\";s:3:\"3.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.zip\";s:5:\"3.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.1.zip\";s:5:\"3.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.7.2.zip\";s:3:\"3.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.zip\";s:5:\"3.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.8.1.zip\";s:3:\"3.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.zip\";s:8:\"3.9-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9-beta.zip\";s:5:\"3.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.1.zip\";s:5:\"3.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.2.zip\";s:5:\"3.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.3.9.3.zip\";s:3:\"4.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.zip\";s:5:\"4.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.1.zip\";s:5:\"4.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.2.zip\";s:5:\"4.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.0.3.zip\";s:3:\"4.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.zip\";s:8:\"4.1-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1-beta.zip\";s:5:\"4.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.1.zip\";s:5:\"4.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.1.2.zip\";s:3:\"4.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.zip\";s:8:\"4.2-beta\";s:66:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2-beta.zip\";s:5:\"4.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.1.zip\";s:5:\"4.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.2.zip\";s:3:\"4.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.zip\";s:5:\"4.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.1.zip\";s:3:\"4.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.zip\";s:5:\"4.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.1.zip\";s:5:\"4.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.4.2.zip\";s:3:\"4.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.zip\";s:5:\"4.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.5.1.zip\";s:3:\"4.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.zip\";s:5:\"4.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.6.1.zip\";s:3:\"4.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.7.zip\";s:3:\"4.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.zip\";s:5:\"4.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.8.1.zip\";s:3:\"4.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.zip\";s:5:\"4.9.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.1.zip\";s:5:\"4.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.9.2.zip\";s:3:\"5.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.zip\";s:5:\"5.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.1.zip\";s:5:\"5.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.2.zip\";s:5:\"5.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.3.zip\";s:5:\"5.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.4.zip\";s:5:\"5.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:3:\"5.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.zip\";s:5:\"5.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.1.zip\";s:5:\"5.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.2.zip\";s:5:\"5.1.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.3.zip\";s:5:\"5.1.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.4.zip\";s:5:\"5.1.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.5.zip\";s:5:\"5.1.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.6.zip\";s:5:\"5.1.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.7.zip\";s:5:\"5.1.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.8.zip\";s:5:\"5.1.9\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.9.zip\";s:3:\"5.2\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.zip\";s:5:\"5.2.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.1.zip\";s:5:\"5.2.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.2.2.zip\";s:3:\"5.3\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.zip\";s:5:\"5.3.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.1.zip\";s:5:\"5.3.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.3.2.zip\";s:3:\"5.4\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.zip\";s:5:\"5.4.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.1.zip\";s:5:\"5.4.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.4.2.zip\";s:3:\"5.5\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.zip\";s:5:\"5.5.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.1.zip\";s:5:\"5.5.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.2.zip\";s:5:\"5.5.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.3.zip\";s:5:\"5.5.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.4.zip\";s:5:\"5.5.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.5.zip\";s:5:\"5.5.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.6.zip\";s:7:\"5.5.6.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.5.5.6.1.zip\";s:3:\"5.6\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.zip\";s:5:\"5.6.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.1.zip\";s:5:\"5.6.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.2.zip\";s:5:\"5.6.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.3.zip\";s:5:\"5.6.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.6.4.zip\";s:3:\"5.7\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.zip\";s:5:\"5.7.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.1.zip\";s:5:\"5.7.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.2.zip\";s:5:\"5.7.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.3.zip\";s:5:\"5.7.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.4.zip\";s:5:\"5.7.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.5.zip\";s:7:\"5.7.5.1\";s:65:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.5.1.zip\";s:5:\"5.7.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.6.zip\";s:5:\"5.7.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.7.zip\";s:3:\"5.8\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.zip\";s:5:\"5.8.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.1.zip\";s:5:\"5.8.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.2.zip\";s:5:\"5.8.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.3.zip\";s:5:\"5.8.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.4.zip\";s:5:\"5.8.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.5.zip\";s:5:\"5.8.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.6.zip\";s:5:\"5.8.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.7.zip\";s:3:\"5.9\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.zip\";s:5:\"5.9.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.2.zip\";s:5:\"5.9.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.3.zip\";s:5:\"5.9.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.4.zip\";s:5:\"5.9.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.5.zip\";s:5:\"5.9.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.6.zip\";s:5:\"5.9.7\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.7.zip\";s:5:\"5.9.8\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.9.8.zip\";s:3:\"6.0\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.zip\";s:5:\"6.0.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.1.zip\";s:5:\"6.0.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.2.zip\";s:5:\"6.0.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.3.zip\";s:5:\"6.0.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.4.zip\";s:5:\"6.0.5\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.5.zip\";s:5:\"6.0.6\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.6.zip\";s:3:\"6.1\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.zip\";s:5:\"6.1.1\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.1.zip\";s:5:\"6.1.2\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.2.zip\";s:5:\"6.1.3\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.3.zip\";s:5:\"6.1.4\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.4.zip\";s:5:\"trunk\";s:57:\"https://downloads.wordpress.org/plugin/contact-form-7.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:32:\"https://contactform7.com/donate/\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";s:4:\"high\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:14:\"Contact Form 7\";}s:9:\"elementor\";a:35:{s:4:\"name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.34.1\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6092;i:4;i:218;i:3;i:111;i:2;i:106;i:1;i:640;}s:11:\"num_ratings\";i:7167;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:105;s:24:\"support_threads_resolved\";i:88;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2026-01-07 3:33pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:25581:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>Heading</strong>. Add eye-catching headlines.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>Icon</strong>. Place one or more of 600+ icons available.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>Icon List</strong>. Use any icon to create a bullet list.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>Progress Bar</strong>. Include an escalating progress bar.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Toggle</strong>. Use the Toggle to hide or display content, like FAQ.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>Alert</strong>. Include a colored alert box to draw visitor’s attention.</li>\n<li><strong>HTML</strong>. Insert code into the page.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>Menu Anchor</strong>. Link any menu to this anchor.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>Google Maps</strong>. Embed maps into the page.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>Divider</strong>. Separate content with a designed divider.</li>\n<li><strong>Spacer</strong>. Add space between elements.</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>And counting&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>Mega Menu</strong>: Customize advanced menus for better navigation and displaying complex content.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 Join a Global Community</h4>\n<p>Join a global community that helps each other achieve their goals.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1461:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP version 7.4 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<h4>Recommended Requirements</h4>\n<ul>\n<li>PHP version 8.1 or greater</li>\n<li>MySQL version 5.6 or greater</li>\n<li>WordPress Memory limit of 64 MB or greater (128 MB or higher is preferred)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>Installation</h4>\n<ol>\n<li>Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the <code>wp-content/plugins/</code> directory of your WordPress installation.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n<li>Go to Pages &gt; Add New</li>\n<li>Press the &#8216;Edit with Elementor&#8217; button.</li>\n<li>Now you can drag and drop widgets from the left panel onto the content area, as well as add new sections and columns that make up the page structure.</li>\n</ol>\n<p>For documentation and tutorials visit our <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">Knowledge Base</a>.</p>\n\";s:3:\"faq\";s:4862:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nHow do I install Elementor?\n</h4>\n<p>\n<p>To install the free version of Elementor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nDoes Elementor work with all the themes?\n</h4>\n<p>\n<p>Elementor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor, and optimize your experience.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nIs Elementor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nCan I create an online store?\n</h4>\n<p>\n<p>Yes, with the Elementor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nDoes it work with other WordPress plugins?\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nDo I need to know how to code?\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of Elementor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nIs my site secure with Elementor?\n</h4>\n<p>\n<p>The security of your website is extremely important to us and we take proactive measures to assure that your websites are secure. Elementor is ISO 27001 certified, and has a dedicated team of security professionals that implements industry best-practices for maximum security and compliance, 24/7.</p>\n<p>There is also a managed security Bug Bounty program, utilizing the community power by enabling 24/7/365 crowdsourced vulnerability detection.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nCan I buy templates separately?\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nIs Elementor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>Of course! You can set which post types will enable Elementor in the settings page.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nWhat is the difference between Elementor&#8217;s free Plugin and Elementor Pro\n</h4>\n<p>\n<p>Elementor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nHow can I become a Contributor\n</h4>\n<p>\n<p>If you want to contribute, go to our <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">Elementor GitHub Repository</a> and see where you can help.<br />\nYou can also add a new language via <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a>. We’ve built a short guide explaining <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:3091:\"<h4>3.34.1 &#8211; 2026-01-07</h4>\n<ul>\n<li>Fix: RTL issues in Icon Box widget (<a href=\"https://github.com/elementor/elementor/issues/33963\" rel=\"nofollow ugc\">#33963</a>)</li>\n<li>Fix: Incorrect <code>space_between_widgets</code> spacing in columns (<a href=\"https://github.com/elementor/elementor/issues/34033\" rel=\"nofollow ugc\">#34033</a>)</li>\n<li>Fix: User settings not applied correctly (<a href=\"https://github.com/elementor/elementor/issues/34065\" rel=\"nofollow ugc\">#34065</a>)</li>\n<li>Fix: Flex Grow is not applied correctly to child containers in the Flexbox element &#8211; Editor V4</li>\n<li>Fix: Deleting a Tab breaks the content–tab relationship in Tabs element &#8211; Editor V4</li>\n<li>Fix: Appearance badge in Site Templates is misaligned and not centered</li>\n</ul>\n<h4>3.34.0 &#8211; 2025-12-22</h4>\n<ul>\n<li>New: Introducing Atomic Tabs &#8211; enabling flexible and fully customizable tab layouts with nested Atomic Elements &#8211; Editor V4</li>\n<li>New: Introducing Entrance Interactions to add lightweight motion and bring elements to life as they appear &#8211; Editor V4</li>\n<li>Tweak: Replaced the legacy V3 container wrapper with the optimized V4 wrapper for improved markup &#8211; Editor V4</li>\n<li>Tweak: Improved frontend link control output to ensure consistent rendering &#8211; Editor V4 (<a href=\"https://github.com/elementor/elementor/issues/32233\" rel=\"nofollow ugc\">#32233</a>)</li>\n<li>Tweak: Added reset option inside popovers &#8211; Editor V4</li>\n<li>Tweak: Updated Border control layout for a clearer and more consistent editing workflow &#8211; Editor V4</li>\n<li>Tweak: Added <code>span</code> option inside the Paragraph atom &#8211; Editor V4</li>\n<li>Tweak: Improved transitions to better support logical properties &#8211; Editor V4</li>\n<li>Tweak: Improved dropdown folder behavior and resolved related UI issues in Template Library</li>\n<li>Tweak: Merged &#8220;Import/Export Customization&#8221; feature into the version</li>\n<li>Tweak: Added <code>builder_content_data</code> filter for extending Template Library and Global Widget content (props <a href=\"https://github.com/dgwatkins\" rel=\"nofollow ugc\">@dgwatkins</a>)</li>\n<li>Tweak: Applied CSS logical properties in Icon Box widget</li>\n<li>Tweak: Applied CSS logical properties in Icon List widget</li>\n<li>Tweak: Applied CSS logical properties in text alignment controls and fixed RTL rendering in the Editor</li>\n<li>Fix: Local Transform values overridden Class-level Transform defaults even when unchanged &#8211; Editor V4</li>\n<li>Fix: Fatal error when opening pages containing atomic elements while the V4 experiment is deactivated &#8211; Editor V4</li>\n<li>Fix: Hover Scale transform set through Class did not save correctly &#8211; Editor V4</li>\n<li>Fix: PHP 8.4 deprecation notices related to deprecated <code>E_STRICT</code> constant</li>\n<li>Fix: Missing CSS regeneration after clearing cached files on pages containing dynamic tags</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:18708:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor Saving</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/cattypretorius/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/f968ce90261108c62bcf7d06369075a00cd1452de558a13500f1a9d0ff9793e4?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/f968ce90261108c62bcf7d06369075a00cd1452de558a13500f1a9d0ff9793e4?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/cattypretorius/\" class=\"reviewer-name\">cattypretorius</a> on <span class=\"review-date\">January 8, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I love this plugin to bits, but since I\'ve started vir Elementor 6 years ago, they had the problem back then already that Elementor won\'t save, even if you try a lot of consecutive times. No amount of support help, like disable all the plugins, restart, cleaning the database, and anything I can think of. If Elementor can solve this problem, then it will absolutely perfect.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Shady business practices</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/son9ne/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5663014b76b796e987e70d9628d1adbb791cbb44b9c5a9f4d800920c0d676701?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5663014b76b796e987e70d9628d1adbb791cbb44b9c5a9f4d800920c0d676701?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/son9ne/\" class=\"reviewer-name\">SoN9ne <small>(son9ne)</small></a> on <span class=\"review-date\">January 7, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Great for people that don\'t really know how to design or build sites. A great tool for beginners but that\'s about it. This plugin is a bloated mess to say the least but the business practices is what did me in on this one. Cancelled renewals suddenly renews, trying to cancel the renewal is not as straight forward as it should be. They hide it through support instead of using your portal to manage your subscription. No mention of this anywhere. This is just shady practices to trap people into their system. You cannot delete your credit card on file, which is why I got another renewal AFTER I cancelled it. Feels a lot like a gym membership, except at least with the gym membership, you get something.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Can&#039;t give it 0</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/theo38/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/87731a097e5d61eeb3f76f2045c3d558e0642975b0decdceb616f2c47115ad14?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/87731a097e5d61eeb3f76f2045c3d558e0642975b0decdceb616f2c47115ad14?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/theo38/\" class=\"reviewer-name\">Theo Pape <small>(theo38)</small></a> on <span class=\"review-date\">January 6, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Just use Gutenberg with Automattic\'s wordpress.com managed hosting.<br /><br />Why would you ever use Elementor to build a website in 2026? The performance alone is extremely poor; modules add such mess to the structure of the pages; SEO is non-existent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Elementor\'s ultimate aim is to tie you in to using their \'platform\' and then to overcharge you for sub-par services. Hosting will frequently go down. You will be overcharged for things such as email sending. Their Elementor admin, where you manage your website and \'add-ons\', crashes all the time.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Pro account doesn’t feel worth it like this.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/petya29765/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/946228052ed8a062545edb7fe00307e3bf4043118f6c4956b3ab4655af7e93a7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/946228052ed8a062545edb7fe00307e3bf4043118f6c4956b3ab4655af7e93a7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/petya29765/\" class=\"reviewer-name\">petyadesign.de <small>(petya29765)</small></a> on <span class=\"review-date\">January 6, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I’m using Elementor (including Pro) and honestly I’m pretty disappointed. The support replies fast, but the help is often ineffective. The default answer I keep getting is always the same: “Disable all plugins and switch your theme.” Thanks, but that doesn’t solve anything when you’re dealing with a real issue.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>After several attempts I finally got someone who seemed to actually look into it, but the problem still wasn’t fixed. And the worst part: after every update, the exact same issue comes back. Right now Elementor won’t even start anymore, even though my server performance is excellent.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quick responses, but no real solutions. A Pro account doesn’t feel worth it like this.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Icons are lot lesser after 3.34 updates</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/amitblue/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2cd08e6909e66ed5713faafaaf465c178d7e8b72d8a888390602d35eee0bf413?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2cd08e6909e66ed5713faafaaf465c178d7e8b72d8a888390602d35eee0bf413?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/amitblue/\" class=\"reviewer-name\">amitblue</a> on <span class=\"review-date\">January 5, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Hi, I have elementor 3.33.2 running on one setup and it has lot more icons with font awesome, whereas on my latest setup running on elementor 3.34 has a lot lesser icons in the list even basic icons, home, close, rocket is missing from the list and a lot more? </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Was it reduced intentionally? should I switch it 3.33 version? Please suggest.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Nightmare</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/chopperpl/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/36ce5d10257773e66b7ee78585f1d448766379309d1ed4f7ad375e6e69cd7970?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/36ce5d10257773e66b7ee78585f1d448766379309d1ed4f7ad375e6e69cd7970?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/chopperpl/\" class=\"reviewer-name\">chopperpl</a> on <span class=\"review-date\">January 4, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>What a waste of time. I have purchased the web template based on elementor. I was able to import it the very first time, but due to compatibility issues with some widgets I had to scratch it and start from the beginning. After I removed the template I was never able to get it imported (original zip file) ever again. Resetting WP install did not work. Setting up new WP container did not work. Creating new Elementor account and connecting to new LXC container also did not work. It always complains about \"issue on their site\" whenever I try to upload the zip file. It appears they proxy all uploads through their website and have for some reason locked my PAID template. I will request full refund for the template and never deal with this company ever again. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Is There Anything Better Than This?</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/xaifact/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/113558204d158fbfa045eb7376d9776b6b2038b2cc5e66ab4d755611af710095?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/113558204d158fbfa045eb7376d9776b6b2038b2cc5e66ab4d755611af710095?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/xaifact/\" class=\"reviewer-name\">xaifact</a> on <span class=\"review-date\">January 2, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor is amazing — the best page builder out there. Easy, powerful, and truly exceptional. What else do you need? Highly recommended!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">My go-to WordPress builder since 2016</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/benady/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ae7113b37249fde2d406f2e86abbe797a3aadde6de575ee0d6a5f2758d53900f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ae7113b37249fde2d406f2e86abbe797a3aadde6de575ee0d6a5f2758d53900f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/benady/\" class=\"reviewer-name\">benady</a> on <span class=\"review-date\">January 1, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I’ve been building with Elementor since the very beginning (2016), and it’s still the tool I trust most when I need to ship a WordPress site fast - without compromising on structure, UX, or maintainability.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Elementor makes it easy to design, iterate, and hand off projects in a clean way: templates, global settings, responsive controls, and a workflow that works for real client work, not just demos. It’s flexible enough for landing pages, content sites, and complex marketing websites, and stable enough to rely on in production.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you’re serious about building on WordPress and you want speed, control, and a modern visual workflow - Elementor is a solid choice.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">i like to use elementor to build website,thanks a lot</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/qystars/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8d95e5bb0199d82986cb410fb29611ec7298b6b80f2bdf847df5785f430201a2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8d95e5bb0199d82986cb410fb29611ec7298b6b80f2bdf847df5785f430201a2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/qystars/\" class=\"reviewer-name\">qystars</a> on <span class=\"review-date\">December 31, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>thanks ,it help me a lot</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Very Easy Builder</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/alredjuli222/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/935bdffafc6c87019c81989ba0f2e111ab895eb2fe291bd70391ea6185302321?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/935bdffafc6c87019c81989ba0f2e111ab895eb2fe291bd70391ea6185302321?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/alredjuli222/\" class=\"reviewer-name\">Alred Juli <small>(alredjuli222)</small></a> on <span class=\"review-date\">December 29, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor is very easy to use and makes website design simple with drag and drop features. Great plugin for beginners and professionals.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:145:\"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.1.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:388:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:6:\"3.32.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:6:\"3.33.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip\";s:12:\"3.33.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip\";s:12:\"3.33.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip\";s:12:\"3.33.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip\";s:12:\"3.33.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip\";s:11:\"3.33.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip\";s:11:\"3.33.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip\";s:11:\"3.33.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip\";s:11:\"3.33.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip\";s:6:\"3.33.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip\";s:6:\"3.33.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:6:\"3.33.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.3.zip\";s:6:\"3.33.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.4.zip\";s:6:\"3.33.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.5.zip\";s:6:\"3.33.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip\";s:6:\"3.34.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:12:\"3.34.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta1.zip\";s:12:\"3.34.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta2.zip\";s:12:\"3.34.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta3.zip\";s:11:\"3.34.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev1.zip\";s:11:\"3.34.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev2.zip\";s:6:\"3.34.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.1.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("206", "elementor_pro_license_key", "*********", "auto");
INSERT INTO `JQx2cw4_options` VALUES("207", "_elementor_pro_license_v2_data", "a:2:{s:7:\"timeout\";i:1768003747;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("208", "recently_activated", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("210", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1764029787;s:7:\"version\";s:5:\"6.1.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("211", "elementor_onboarded", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("212", "elementor_active_kit", "17", "auto");
INSERT INTO `JQx2cw4_options` VALUES("213", "elementor_font_display", "swap", "auto");
INSERT INTO `JQx2cw4_options` VALUES("217", "eael_setup_wizard", "init", "auto");
INSERT INTO `JQx2cw4_options` VALUES("218", "eael_save_settings", "a:71:{s:9:\"post-grid\";i:1;s:13:\"post-timeline\";i:1;s:10:\"fancy-text\";i:1;s:12:\"creative-btn\";i:1;s:10:\"count-down\";i:1;s:12:\"team-members\";i:1;s:12:\"testimonials\";i:1;s:8:\"info-box\";i:1;s:8:\"flip-box\";i:1;s:14:\"call-to-action\";i:1;s:11:\"dual-header\";i:1;s:11:\"price-table\";i:1;s:12:\"twitter-feed\";i:1;s:13:\"facebook-feed\";i:1;s:19:\"advanced-data-table\";i:1;s:10:\"data-table\";i:1;s:14:\"filter-gallery\";i:1;s:15:\"image-accordion\";i:1;s:14:\"content-ticker\";i:1;s:7:\"tooltip\";i:1;s:13:\"adv-accordion\";i:1;s:8:\"adv-tabs\";i:1;s:12:\"progress-bar\";i:1;s:12:\"feature-list\";i:1;s:12:\"product-grid\";i:1;s:16:\"woo-product-list\";i:1;s:17:\"woo-product-price\";i:1;s:18:\"woo-product-rating\";i:1;s:11:\"breadcrumbs\";i:1;s:12:\"code-snippet\";i:1;s:18:\"woo-product-images\";i:1;s:15:\"woo-add-to-cart\";i:1;s:14:\"contact-form-7\";i:1;s:7:\"weforms\";i:1;s:10:\"ninja-form\";i:1;s:9:\"formstack\";i:1;s:12:\"gravity-form\";i:1;s:12:\"caldera-form\";i:1;s:7:\"wpforms\";i:1;s:10:\"fluentform\";i:1;s:8:\"typeform\";i:1;s:24:\"betterdocs-category-grid\";i:1;s:23:\"betterdocs-category-box\";i:1;s:22:\"betterdocs-search-form\";i:1;s:12:\"sticky-video\";i:1;s:14:\"event-calendar\";i:1;s:10:\"embedpress\";i:1;s:12:\"woo-checkout\";i:1;s:8:\"woo-cart\";i:1;s:14:\"login-register\";i:1;s:11:\"career-page\";i:1;s:19:\"woo-product-compare\";i:1;s:20:\"woo-product-carousel\";i:1;s:11:\"simple-menu\";i:1;s:19:\"woo-product-gallery\";i:1;s:18:\"interactive-circle\";i:1;s:14:\"better-payment\";i:1;s:11:\"nft-gallery\";i:1;s:16:\"business-reviews\";i:1;s:8:\"svg-draw\";i:1;s:9:\"promotion\";i:1;s:9:\"custom-js\";i:1;s:16:\"reading-progress\";i:1;s:16:\"table-of-content\";i:1;s:15:\"post-duplicator\";i:1;s:13:\"scroll-to-top\";i:1;s:12:\"wrapper-link\";i:1;s:20:\"special-hover-effect\";i:1;s:19:\"liquid-glass-effect\";i:1;s:13:\"image-masking\";i:1;s:25:\"vertical-text-orientation\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("221", "jetpack_available_modules", "a:1:{s:4:\"15.4\";a:43:{s:18:\"account-protection\";s:4:\"14.5\";s:5:\"blaze\";s:4:\"12.3\";s:6:\"blocks\";s:8:\"13.9-a.8\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:12:\"google-fonts\";s:6:\"10.8.0\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"post-list\";s:4:\"11.3\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:3:\"waf\";s:4:\"10.9\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("222", "jetpack_activated", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("225", "jetpack_activation_source", "a:2:{i:0;s:7:\"unknown\";i:1;N;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("226", "jetpack_sync_settings_disable", "0", "on");
INSERT INTO `JQx2cw4_options` VALUES("227", "woocommerce_analytics_proxy_speed_module_version", "1.0.0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("228", "jetpack_options", "a:3:{s:7:\"version\";s:15:\"15.2:1764029788\";s:11:\"old_version\";s:15:\"15.2:1764029788\";s:14:\"last_heartbeat\";i:1767921415;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("229", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:2:{s:31:\"royal-elementor-addons/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1764029788;s:11:\"plugin_path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}s:49:\"portfolio-elementor/vendor/freemius/wordpress-sdk\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.13.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1765287446;s:11:\"plugin_path\";s:43:\"portfolio-elementor/portfolio-elementor.php\";}}s:7:\"abspath\";s:67:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:43:\"portfolio-elementor/portfolio-elementor.php\";s:8:\"sdk_path\";s:49:\"portfolio-elementor/vendor/freemius/wordpress-sdk\";s:7:\"version\";s:6:\"2.13.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1765326014;}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("230", "fs_debug_mode", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("231", "fs_accounts", "a:8:{s:21:\"id_slug_type_path_map\";a:2:{i:8416;a:3:{s:4:\"slug\";s:10:\"wpr-addons\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}i:7226;a:3:{s:4:\"slug\";s:19:\"portfolio-elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:43:\"portfolio-elementor/portfolio-elementor.php\";}}s:11:\"plugin_data\";a:2:{s:10:\"wpr-addons\";a:17:{s:19:\"last_load_timestamp\";i:1767953199;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:37:\"royal-elementor-addons/wpr-addons.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1764029788;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:6:\"2.12.2\";s:11:\"sdk_version\";s:6:\"2.13.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:8:\"1.7.1041\";s:14:\"plugin_version\";s:8:\"1.7.1045\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:34:\"websiteonabudget.thebootroomhq.com\";s:9:\"server_ip\";s:14:\"209.126.11.208\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1767960309;s:7:\"version\";s:8:\"1.7.1045\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}s:19:\"portfolio-elementor\";a:17:{s:19:\"last_load_timestamp\";i:1767953199;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:43:\"portfolio-elementor/portfolio-elementor.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1764180846;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:6:\"2.12.2\";s:11:\"sdk_version\";s:6:\"2.13.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"3.2.4\";s:14:\"plugin_version\";s:5:\"3.2.5\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:34:\"websiteonabudget.thebootroomhq.com\";s:9:\"server_ip\";s:14:\"209.126.11.208\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1765287446;s:7:\"version\";s:5:\"3.2.5\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:2:{s:37:\"royal-elementor-addons/wpr-addons.php\";s:10:\"wpr-addons\";s:43:\"portfolio-elementor/portfolio-elementor.php\";s:19:\"portfolio-elementor\";}s:7:\"plugins\";a:2:{s:10:\"wpr-addons\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:4:\"8416\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;s:10:\"public_key\";s:32:\"pk_a0b21b234a7c9581a555b9ee9f28a\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:22:\"Royal Elementor Addons\";s:4:\"slug\";s:10:\"wpr-addons\";s:12:\"premium_slug\";s:14:\"wpr-addons-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";s:8:\"selected\";s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:37:\"royal-elementor-addons/wpr-addons.php\";s:7:\"version\";s:8:\"1.7.1045\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}s:19:\"portfolio-elementor\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:4:\"7226\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_75702ac7c5c10d2bfd4880c1c8039\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:52:\"PowerFolio - Portfolio & Image Gallery for Elementor\";s:4:\"slug\";s:19:\"portfolio-elementor\";s:12:\"premium_slug\";s:23:\"portfolio-elementor-pro\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:43:\"portfolio-elementor/portfolio-elementor.php\";s:7:\"version\";s:5:\"3.2.5\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"PRO\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"d8096bbe0ac9c661b318b627cb7ea62e\";s:13:\"admin_notices\";a:2:{s:10:\"wpr-addons\";a:1:{s:15:\"connect_account\";a:10:{s:7:\"message\";s:182:\"We made a few tweaks to the plugin, <b><a href=\"https://websiteonabudget.thebootroomhq.com/wp-admin/admin.php?page=wpr-addons\">Opt in to make \"Royal Elementor Addons\" better!</a></b>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:10:\"update-nag\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"connect_account\";s:10:\"manager_id\";s:10:\"wpr-addons\";s:6:\"plugin\";s:22:\"Royal Elementor Addons\";s:10:\"wp_user_id\";N;s:11:\"dismissible\";b:1;s:4:\"data\";a:0:{}}}s:19:\"portfolio-elementor\";a:1:{s:15:\"connect_account\";a:10:{s:7:\"message\";s:221:\"We made a few tweaks to the plugin, <b><a href=\"https://websiteonabudget.thebootroomhq.com/wp-admin/admin.php?page=elementor_portfolio\">Opt in to make \"PowerFolio - Portfolio & Image Gallery for Elementor\" better!</a></b>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:10:\"update-nag\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"connect_account\";s:10:\"manager_id\";s:19:\"portfolio-elementor\";s:6:\"plugin\";s:52:\"PowerFolio - Portfolio & Image Gallery for Elementor\";s:10:\"wp_user_id\";N;s:11:\"dismissible\";b:1;s:4:\"data\";a:0:{}}}}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("232", "fs_api_cache", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("237", "royal_elementor_addons_activation_time", "1764029788", "auto");
INSERT INTO `JQx2cw4_options` VALUES("238", "royal_elementor_addons_activation_time_for_sale", "1764029788", "auto");
INSERT INTO `JQx2cw4_options` VALUES("240", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:25:\"{{WP_PLUGIN_DIR}}/jetpack\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("243", "elementor_cpt_support", "a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:13:\"wpr_templates\";i:3;s:18:\"tmpcoder_mega_menu\";i:4;s:13:\"wpr_mega_menu\";i:5;s:11:\"elemenfolio\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("244", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("245", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("246", "elementor_version", "3.34.1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("247", "elementor_install_history", "a:4:{s:6:\"3.15.1\";i:1764029789;s:6:\"3.33.2\";i:1764029789;s:6:\"3.33.4\";i:1765286809;s:6:\"3.34.1\";i:1767960265;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("248", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `JQx2cw4_options` VALUES("249", "elementor_pro_version", "3.15.1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("250", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("251", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("252", "eael_version", "6.5.5", "auto");
INSERT INTO `JQx2cw4_options` VALUES("254", "_elementor_pro_installed_time", "1764029790", "auto");
INSERT INTO `JQx2cw4_options` VALUES("255", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("256", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("257", "do_activate", "0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("262", "jetpack_waf_needs_update", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("263", "astra_sites_recent_import_log_file", "/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/uploads/astra-sites/import-25-Nov-2025-12-16-32-52d967d8d08f423d002fc16c9781e983.log", "off");
INSERT INTO `JQx2cw4_options` VALUES("267", "astra-sites-last-export-checksums-latest", "*tueIEife0e4", "off");
INSERT INTO `JQx2cw4_options` VALUES("270", "astra-sites-batch-status-string", "All processes are complete", "off");
INSERT INTO `JQx2cw4_options` VALUES("271", "astra-blocks-batch-status-string", "Complete storing data for page 4", "off");
INSERT INTO `JQx2cw4_options` VALUES("274", "astra-sites-fresh-site", "no", "off");
INSERT INTO `JQx2cw4_options` VALUES("275", "essential-addons-for-elementor-lite_notices", "a:3:{s:16:\"bfcm_2025_notice\";a:4:{s:5:\"start\";i:1767960273;s:10:\"recurrence\";b:0;s:7:\"refresh\";s:5:\"6.5.5\";s:6:\"expire\";i:1764892799;}s:7:\"version\";s:5:\"1.1.0\";s:6:\"review\";a:3:{s:5:\"start\";i:1768565075;s:10:\"recurrence\";i:30;s:7:\"refresh\";s:5:\"6.5.5\";}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("276", "ai_builder_recent_import_log_file", "/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/uploads/ai-builder/import-25-Nov-2025-12-16-33-52d967d8d08f423d002fc16c9781e983.log", "off");
INSERT INTO `JQx2cw4_options` VALUES("278", "elementor_submissions_db_version", "5", "auto");
INSERT INTO `JQx2cw4_options` VALUES("283", "bsf_analytics_installed_time", "1764029794", "off");
INSERT INTO `JQx2cw4_options` VALUES("285", "ast-block-templates-version", "2.4.17", "auto");
INSERT INTO `JQx2cw4_options` VALUES("289", "elementskit-lite__banner_last_check", "1767960218", "auto");
INSERT INTO `JQx2cw4_options` VALUES("290", "elementskit-lite__banner_data", "O:8:\"stdClass\":10:{s:8:\"10022095\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022095;s:5:\"title\";s:31:\"Wpmet Holiday Sale Ownpage 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768089600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022094\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022094;s:5:\"title\";s:28:\"Wpmet Holiday Sale Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";b:0;s:3:\"end\";b:0;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("292", "jetpack_active_modules", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("295", "_elementor_installed_time", "1764029795", "auto");
INSERT INTO `JQx2cw4_options` VALUES("296", "elementor_connect_site_key", "c0d8b473a240b2ae1994b07ec86eba7f", "auto");
INSERT INTO `JQx2cw4_options` VALUES("297", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("300", "astra-sites-batch-is-complete", "yes", "off");
INSERT INTO `JQx2cw4_options` VALUES("301", "astra-sites-last-export-checksums", "*tueIEife0e4", "off");
INSERT INTO `JQx2cw4_options` VALUES("302", "elementskit-lite_install_date", "2025-11-25 12:16:48", "auto");
INSERT INTO `JQx2cw4_options` VALUES("303", "elementor_fonts_manager_font_types", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("304", "elementor_fonts_manager_fonts", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("305", "elementor_custom_icon_sets_config", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("307", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1767780272;s:5:\"value\";s:11624:\"[{\"id\":\"atomic-tabs-3.34\",\"title\":\"Atomic Tabs\",\"description\":\"Nest any type of content inside tab triggers or content panels, unlocking a truly atomic way of design.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tabs-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"interactions-3.34\",\"title\":\"Entrance Interactions\",\"description\":\"Add subtle, performance\\u2011minded Fade, Scale or Slide effects to your elements from the new Interaction panel.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/interactions-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("310", "_elementor_settings_update_time", "1764137600", "auto");
INSERT INTO `JQx2cw4_options` VALUES("311", "elementor_disable_color_schemes", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("312", "elementor_disable_typography_schemes", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("313", "elementor_allow_tracking_last_update", "1764137600", "auto");
INSERT INTO `JQx2cw4_options` VALUES("314", "elementor_allow_tracking", "no", "auto");
INSERT INTO `JQx2cw4_options` VALUES("315", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("316", "elementor_pro_recaptcha_site_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("317", "elementor_pro_recaptcha_secret_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("318", "elementor_pro_recaptcha_v3_site_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("319", "elementor_pro_recaptcha_v3_secret_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("320", "elementor_pro_recaptcha_v3_threshold", "0.5", "auto");
INSERT INTO `JQx2cw4_options` VALUES("321", "elementor_pro_facebook_app_id", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("322", "elementor_pro_mailchimp_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("323", "elementor_validate_api_data", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("324", "elementor_pro_drip_api_token", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("325", "elementor_pro_activecampaign_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("326", "elementor_pro_activecampaign_api_url", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("327", "elementor_pro_getresponse_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("328", "elementor_pro_convertkit_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("329", "elementor_pro_mailerlite_api_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("330", "elementor_typekit-kit-id", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("332", "elementor_pro_stripe_test_secret_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("333", "elementor_validate_stripe_api_test_secret_key_button", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("334", "elementor_pro_stripe_live_secret_key", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("335", "elementor_validate_stripe_api_live_secret_key_button", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("336", "elementor_stripe_legal_disclaimer", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("337", "elementor_editor_break_lines", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("338", "elementor_unfiltered_files_upload", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("339", "elementor_google_font", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("340", "elementor_load_fa4_shim", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("341", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("342", "elementor_css_print_method", "external", "auto");
INSERT INTO `JQx2cw4_options` VALUES("343", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("344", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("345", "elementor_lazy_load_background_images", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("346", "elementor_local_google_fonts", "0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("347", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `JQx2cw4_options` VALUES("348", "elementor_experiment-import-export-customization", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("349", "elementor_experiment-container", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("350", "elementor_experiment-nested-elements", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("351", "elementor_experiment-mega-menu", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("352", "elementor_experiment-loop", "default", "auto");
INSERT INTO `JQx2cw4_options` VALUES("353", "elementor_experiment-taxonomy-filter", "default", "auto");
INSERT INTO `JQx2cw4_options` VALUES("354", "elementor_experiment-e_font_icon_svg", "inactive", "auto");
INSERT INTO `JQx2cw4_options` VALUES("355", "elementor_experiment-additional_custom_breakpoints", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("356", "elementor_experiment-e_optimized_markup", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("357", "elementor_experiment-theme_builder_v2", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("358", "elementor_experiment-page-transitions", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("359", "elementor_experiment-notes", "default", "auto");
INSERT INTO `JQx2cw4_options` VALUES("360", "elementor_experiment-form-submissions", "active", "auto");
INSERT INTO `JQx2cw4_options` VALUES("361", "elementor_experiment-e_scroll_snap", "default", "auto");
INSERT INTO `JQx2cw4_options` VALUES("364", "elementor_log", "a:26:{s:32:\"efc89fb2e9b52b175dc10819fca5d295\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 00:18:38\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:30:\"C.startsWith is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-11-25 00:18:38\";i:1;s:19:\"2025-11-25 00:18:57\";i:2;s:19:\"2025-11-25 00:19:34\";i:3;s:19:\"2025-11-26 06:12:25\";i:4;s:19:\"2025-11-26 06:13:18\";i:5;s:19:\"2025-11-27 16:08:52\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764029918\";s:7:\"message\";s:30:\"C.startsWith is not a function\";s:3:\"url\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:6:\"102651\";}s:7:\"\0*\0file\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"1\";s:9:\"\0*\0column\";s:6:\"102651\";}s:32:\"02e08dcc4b7d7756d623c31e522e77b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-25 00:32:34\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:69;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-12-10 01:37:55\";i:1;s:19:\"2025-12-10 01:39:46\";i:2;s:19:\"2025-12-10 01:50:33\";i:3;s:19:\"2025-12-10 01:51:34\";i:4;s:19:\"2025-12-10 01:54:29\";i:5;s:19:\"2025-12-10 05:41:48\";i:6;s:19:\"2025-12-10 05:49:54\";i:7;s:19:\"2025-12-10 05:50:00\";i:8;s:19:\"2025-12-10 05:50:22\";i:9;s:19:\"2025-12-10 05:52:18\";i:10;s:19:\"2025-12-10 05:56:18\";i:11;s:19:\"2025-12-10 07:38:01\";i:12;s:19:\"2025-12-10 07:42:16\";i:13;s:19:\"2025-12-10 07:42:22\";i:14;s:19:\"2025-12-10 18:54:56\";i:15;s:19:\"2025-12-10 19:02:29\";i:16;s:19:\"2025-12-10 19:11:59\";i:17;s:19:\"2025-12-10 19:12:08\";i:18;s:19:\"2025-12-10 19:12:12\";i:19;s:19:\"2025-12-10 19:12:17\";i:20;s:19:\"2025-12-10 19:12:22\";i:21;s:19:\"2025-12-10 19:38:16\";i:22;s:19:\"2025-12-10 19:38:34\";i:23;s:19:\"2025-12-10 19:38:40\";i:24;s:19:\"2025-12-10 22:34:54\";i:25;s:19:\"2026-01-07 11:02:20\";i:26;s:19:\"2026-01-07 11:02:20\";i:27;s:19:\"2026-01-07 15:17:47\";i:28;s:19:\"2026-01-07 15:17:54\";i:29;s:19:\"2026-01-07 15:18:00\";i:30;s:19:\"2026-01-07 15:18:10\";i:31;s:19:\"2026-01-07 15:18:27\";i:32;s:19:\"2026-01-07 15:18:37\";i:33;s:19:\"2026-01-08 21:44:12\";i:34;s:19:\"2026-01-08 21:47:51\";i:35;s:19:\"2026-01-08 22:24:38\";i:36;s:19:\"2026-01-08 22:34:54\";i:37;s:19:\"2026-01-08 22:49:32\";i:38;s:19:\"2026-01-08 23:11:56\";i:39;s:19:\"2026-01-08 23:15:51\";i:40;s:19:\"2026-01-08 23:48:08\";i:41;s:19:\"2026-01-08 23:50:05\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:4:\"file\";s:129:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:129:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:7:\"\0*\0line\";i:76;}s:32:\"1f3f7f521382974dd61eff7a8148ee9e\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 00:46:56\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:38:\"elementorFrontendConfig is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-11-25 00:46:56\";i:1;s:19:\"2025-11-25 00:51:05\";i:2;s:19:\"2025-11-26 18:04:37\";i:3;s:19:\"2025-11-26 18:05:02\";i:4;s:19:\"2025-12-10 19:14:34\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764031616\";s:7:\"message\";s:38:\"elementorFrontendConfig is not defined\";s:3:\"url\";s:108:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"1\";s:6:\"column\";s:5:\"25843\";}s:7:\"\0*\0file\";s:108:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"1\";s:9:\"\0*\0column\";s:5:\"25843\";}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 01:11:26\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 01:11:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764033086\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"22591\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"22591\";}s:32:\"b631895f3a5188538075d10a2f664702\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 01:57:14\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:54:\"An invalid argument supplied as multiple control value\";s:7:\"\0*\0meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `selected_icon` value. Expected array or object.\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 01:57:14\";}s:7:\"\0*\0args\";a:8:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764035834\";s:7:\"message\";s:54:\"An invalid argument supplied as multiple control value\";s:3:\"url\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"21332\";s:12:\"customFields\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `selected_icon` value. Expected array or object.\";}s:4:\"meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `selected_icon` value. Expected array or object.\";}}s:7:\"\0*\0file\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"21332\";}s:32:\"b387f1586afa1d0f78cfacf407b9bfab\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 01:57:14\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:54:\"An invalid argument supplied as multiple control value\";s:7:\"\0*\0meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `left_position` value. Expected array or object.\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 01:57:14\";}s:7:\"\0*\0args\";a:8:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764035834\";s:7:\"message\";s:54:\"An invalid argument supplied as multiple control value\";s:3:\"url\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"21332\";s:12:\"customFields\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `left_position` value. Expected array or object.\";}s:4:\"meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:75:\"Element `undefined` got as `left_position` value. Expected array or object.\";}}s:7:\"\0*\0file\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"21332\";}s:32:\"9cf47858b89f1ffca37a63e7ab1675de\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 01:57:14\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:54:\"An invalid argument supplied as multiple control value\";s:7:\"\0*\0meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:74:\"Element `undefined` got as `top_position` value. Expected array or object.\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-25 01:57:14\";}s:7:\"\0*\0args\";a:8:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764035834\";s:7:\"message\";s:54:\"An invalid argument supplied as multiple control value\";s:3:\"url\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"21332\";s:12:\"customFields\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:74:\"Element `undefined` got as `top_position` value. Expected array or object.\";}s:4:\"meta\";a:2:{s:8:\"category\";s:18:\"InvalidElementData\";s:3:\"tag\";s:74:\"Element `undefined` got as `top_position` value. Expected array or object.\";}}s:7:\"\0*\0file\";s:114:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"21332\";}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-25 03:25:41\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:45;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-11-26 19:10:15\";i:1;s:19:\"2025-11-26 19:16:01\";i:2;s:19:\"2025-11-26 19:16:01\";i:3;s:19:\"2025-11-26 19:18:50\";i:4;s:19:\"2025-11-26 19:18:50\";i:5;s:19:\"2025-11-27 15:54:45\";i:6;s:19:\"2025-11-27 19:30:47\";i:7;s:19:\"2025-12-09 14:59:18\";i:8;s:19:\"2025-12-09 14:59:18\";i:9;s:19:\"2025-12-09 15:03:30\";i:10;s:19:\"2025-12-09 15:03:30\";i:11;s:19:\"2025-12-10 01:59:14\";i:12;s:19:\"2025-12-10 01:59:14\";i:13;s:19:\"2025-12-10 02:00:18\";i:14;s:19:\"2025-12-10 02:00:18\";i:15;s:19:\"2025-12-10 02:51:22\";i:16;s:19:\"2025-12-10 02:51:22\";i:17;s:19:\"2025-12-10 02:55:53\";i:18;s:19:\"2025-12-10 03:38:56\";i:19;s:19:\"2025-12-10 03:38:56\";i:20;s:19:\"2025-12-10 03:38:56\";i:21;s:19:\"2025-12-10 03:38:56\";i:22;s:19:\"2025-12-10 03:56:09\";i:23;s:19:\"2025-12-10 04:31:21\";i:24;s:19:\"2025-12-10 18:35:23\";i:25;s:19:\"2025-12-10 18:35:23\";i:26;s:19:\"2025-12-10 18:46:33\";i:27;s:19:\"2025-12-10 18:46:33\";i:28;s:19:\"2025-12-10 18:46:35\";i:29;s:19:\"2025-12-10 18:46:35\";i:30;s:19:\"2025-12-10 18:46:47\";i:31;s:19:\"2025-12-10 18:46:47\";i:32;s:19:\"2025-12-22 12:08:32\";i:33;s:19:\"2025-12-22 12:08:48\";i:34;s:19:\"2025-12-22 12:50:53\";i:35;s:19:\"2025-12-22 12:50:53\";i:36;s:19:\"2025-12-22 16:19:51\";i:37;s:19:\"2025-12-22 16:19:51\";i:38;s:19:\"2025-12-23 12:08:58\";i:39;s:19:\"2025-12-23 12:08:58\";i:40;s:19:\"2025-12-23 12:10:57\";i:41;s:19:\"2025-12-23 12:10:57\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764041141\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"916748\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:6:\"916748\";}s:32:\"9a265cd7ec074eda7c026c6297c590e1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-26 19:14:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;toLowerCase&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:9;s:14:\"\0*\0times_dates\";a:9:{i:0;s:19:\"2025-11-26 19:14:10\";i:1;s:19:\"2025-11-26 19:14:48\";i:2;s:19:\"2025-11-26 19:15:05\";i:3;s:19:\"2025-11-26 19:46:19\";i:4;s:19:\"2025-11-26 19:46:29\";i:5;s:19:\"2025-11-28 21:36:12\";i:6;s:19:\"2025-12-10 02:55:11\";i:7;s:19:\"2025-12-10 02:55:28\";i:8;s:19:\"2025-12-11 19:36:13\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764184450\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'toLowerCase\')\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"999763\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:6:\"999763\";}s:32:\"e6e076c9d7c1040e07469a28b2906569\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-27 15:56:39\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:55:\"Cannot read properties of null (reading &#039;id&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-11-27 15:56:39\";i:1;s:19:\"2025-11-27 20:51:21\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764258999\";s:7:\"message\";s:45:\"Cannot read properties of null (reading \'id\')\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:7:\"1216735\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:7:\"1216735\";}s:32:\"8b940f8cfd06ce2af827f77dc96fed30\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-27 19:59:15\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:46:\"Undefined array key &quot;editor_post_id&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 19:59:15\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:36:\"Undefined array key \"editor_post_id\"\";s:4:\"file\";s:133:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:4:\"line\";i:363;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:133:\"/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:7:\"\0*\0line\";i:363;}s:32:\"e1645d246830dcecdc05663e2857389a\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-27 17:01:30\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:22:\"X is not a constructor\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-11-27 17:01:30\";i:1;s:19:\"2025-11-27 17:03:10\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764262890\";s:7:\"message\";s:22:\"X is not a constructor\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:7:\"1081272\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:7:\"1081272\";}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-28 02:57:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-11-28 02:57:12\";i:1;s:19:\"2025-11-28 02:57:12\";i:2;s:19:\"2025-11-28 02:57:12\";i:3;s:19:\"2025-11-28 02:57:13\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764298632\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:7:\"1000266\";}s:7:\"\0*\0file\";s:106:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:7:\"1000266\";}s:32:\"2f8b22503014336f8315fad251903af4\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-28 16:48:53\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:32:\"elementorFrontend is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-11-28 16:48:53\";i:1;s:19:\"2025-12-22 11:27:37\";i:2;s:19:\"2025-12-23 19:03:49\";i:3;s:19:\"2025-12-26 03:27:31\";i:4;s:19:\"2025-12-27 23:39:53\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764348533\";s:7:\"message\";s:32:\"elementorFrontend is not defined\";s:3:\"url\";s:134:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/portfolio-elementor/assets/js/custom-portfolio-elementor.js?ver=99999999\";s:4:\"line\";s:3:\"134\";s:6:\"column\";s:1:\"5\";}s:7:\"\0*\0file\";s:134:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/portfolio-elementor/assets/js/custom-portfolio-elementor.js?ver=99999999\";s:7:\"\0*\0line\";s:3:\"134\";s:9:\"\0*\0column\";s:1:\"5\";}s:32:\"d689e2e72151397d165af646fb2d0226\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 13:26:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 13:26:49\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d052eae8528d9dc49e24ad162499b485\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 13:26:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 13:26:49\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"499907f5cc6001463dd90dca720e6a90\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 13:26:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 13:26:49\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"4950859fe3e757c5a5d38bd6e3cb6df3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 13:26:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 13:26:49\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e3ce2b23075ec0569b832367613a0273\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 13:26:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 13:26:49\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"20176940ae701dbf14a5ea3ef67073e8\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-12-30 16:57:46\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:58:\"Cannot read properties of null (reading &#039;clone&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:12755;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2026-01-07 09:02:36\";i:1;s:19:\"2026-01-07 09:02:36\";i:2;s:19:\"2026-01-07 09:02:36\";i:3;s:19:\"2026-01-07 09:02:36\";i:4;s:19:\"2026-01-07 09:02:36\";i:5;s:19:\"2026-01-07 09:02:36\";i:6;s:19:\"2026-01-07 09:02:36\";i:7;s:19:\"2026-01-07 09:02:36\";i:8;s:19:\"2026-01-07 09:02:36\";i:9;s:19:\"2026-01-07 09:02:36\";i:10;s:19:\"2026-01-07 09:02:36\";i:11;s:19:\"2026-01-07 09:02:36\";i:12;s:19:\"2026-01-07 09:02:36\";i:13;s:19:\"2026-01-07 09:02:36\";i:14;s:19:\"2026-01-07 09:02:36\";i:15;s:19:\"2026-01-07 09:02:36\";i:16;s:19:\"2026-01-07 09:02:36\";i:17;s:19:\"2026-01-07 09:02:36\";i:18;s:19:\"2026-01-07 09:02:36\";i:19;s:19:\"2026-01-07 09:02:36\";i:20;s:19:\"2026-01-07 09:02:36\";i:21;s:19:\"2026-01-07 09:02:36\";i:22;s:19:\"2026-01-07 09:02:36\";i:23;s:19:\"2026-01-07 09:02:36\";i:24;s:19:\"2026-01-07 09:02:36\";i:25;s:19:\"2026-01-07 09:02:36\";i:26;s:19:\"2026-01-07 09:02:36\";i:27;s:19:\"2026-01-07 09:02:36\";i:28;s:19:\"2026-01-07 09:02:36\";i:29;s:19:\"2026-01-07 09:02:36\";i:30;s:19:\"2026-01-07 09:02:36\";i:31;s:19:\"2026-01-07 09:02:36\";i:32;s:19:\"2026-01-07 09:02:36\";i:33;s:19:\"2026-01-07 09:02:36\";i:34;s:19:\"2026-01-07 09:02:36\";i:35;s:19:\"2026-01-07 09:02:37\";i:36;s:19:\"2026-01-07 09:02:37\";i:37;s:19:\"2026-01-07 09:02:37\";i:38;s:19:\"2026-01-07 09:02:37\";i:39;s:19:\"2026-01-07 09:02:37\";i:40;s:19:\"2026-01-07 09:02:37\";i:41;s:19:\"2026-01-07 09:02:37\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1767113866\";s:7:\"message\";s:48:\"Cannot read properties of null (reading \'clone\')\";s:3:\"url\";s:111:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"14799\";}s:7:\"\0*\0file\";s:111:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"14799\";}s:32:\"0a997826a2fbc91e2cea3d61324d249d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-12-30 16:58:03\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of null (reading &#039;changestop&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:322;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2026-01-07 08:45:38\";i:1;s:19:\"2026-01-07 08:45:43\";i:2;s:19:\"2026-01-07 08:45:47\";i:3;s:19:\"2026-01-07 08:45:49\";i:4;s:19:\"2026-01-07 08:45:59\";i:5;s:19:\"2026-01-07 08:46:16\";i:6;s:19:\"2026-01-07 08:57:14\";i:7;s:19:\"2026-01-07 08:57:23\";i:8;s:19:\"2026-01-07 08:57:26\";i:9;s:19:\"2026-01-07 08:57:30\";i:10;s:19:\"2026-01-07 08:57:33\";i:11;s:19:\"2026-01-07 08:57:34\";i:12;s:19:\"2026-01-07 08:57:34\";i:13;s:19:\"2026-01-07 08:57:35\";i:14;s:19:\"2026-01-07 08:57:35\";i:15;s:19:\"2026-01-07 08:57:35\";i:16;s:19:\"2026-01-07 08:57:36\";i:17;s:19:\"2026-01-07 08:57:44\";i:18;s:19:\"2026-01-07 08:57:44\";i:19;s:19:\"2026-01-07 08:57:44\";i:20;s:19:\"2026-01-07 08:57:46\";i:21;s:19:\"2026-01-07 08:57:47\";i:22;s:19:\"2026-01-07 08:57:47\";i:23;s:19:\"2026-01-07 08:57:53\";i:24;s:19:\"2026-01-07 08:57:54\";i:25;s:19:\"2026-01-07 08:57:56\";i:26;s:19:\"2026-01-07 08:58:45\";i:27;s:19:\"2026-01-07 08:58:57\";i:28;s:19:\"2026-01-07 08:59:01\";i:29;s:19:\"2026-01-07 09:01:01\";i:30;s:19:\"2026-01-07 09:01:01\";i:31;s:19:\"2026-01-07 09:01:02\";i:32;s:19:\"2026-01-07 09:01:02\";i:33;s:19:\"2026-01-07 09:01:05\";i:34;s:19:\"2026-01-07 09:01:16\";i:35;s:19:\"2026-01-07 09:01:17\";i:36;s:19:\"2026-01-07 09:01:53\";i:37;s:19:\"2026-01-07 09:01:56\";i:38;s:19:\"2026-01-07 09:02:24\";i:39;s:19:\"2026-01-07 09:02:25\";i:40;s:19:\"2026-01-07 09:02:31\";i:41;s:19:\"2026-01-07 09:02:34\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1767113883\";s:7:\"message\";s:53:\"Cannot read properties of null (reading \'changestop\')\";s:3:\"url\";s:111:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"19552\";}s:7:\"\0*\0file\";s:111:\"https://websiteonabudget.thebootroomhq.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"19552\";}s:32:\"dcc48abd08d77725df3891ab14093dec\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-09 12:04:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-09 12:04:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"70db731aa272477b87f92601a40facbc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-09 12:04:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-09 12:04:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d0b1438fc78ea7dc8640b364634aeca3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-09 12:04:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-09 12:04:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"653d40fce58fb8fb6659bd76cce11c71\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-09 12:04:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-09 12:04:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d0ae5c6cb7537cd31f697974a84e5fc4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-01-09 12:04:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-01-09 12:04:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.4\";s:2:\"to\";s:6:\"3.34.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("367", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("368", "elementskit_options", "a:3:{s:17:\"megamenu_settings\";a:2:{s:15:\"menu_location_3\";a:1:{s:10:\"is_enabled\";i:1;}s:15:\"menu_location_4\";a:1:{s:10:\"is_enabled\";i:0;}}s:9:\"user_data\";a:1:{s:10:\"inline_svg\";a:1:{s:9:\"is_enable\";s:1:\"1\";}}s:8:\"settings\";a:1:{s:16:\"newsletter_email\";s:0:\"\";}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("370", "e_editor_counter", "246", "auto");
INSERT INTO `JQx2cw4_options` VALUES("376", "_transient_ekit_element_manager_compatibity", "1", "on");
INSERT INTO `JQx2cw4_options` VALUES("377", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1767960407;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("395", "rael_done_migration_theme_builder_templates", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("396", "hero_latest_dpn", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("397", "ms_was_installed_on", "1764031168", "auto");
INSERT INTO `JQx2cw4_options` VALUES("398", "metaslider_new_user", "new", "auto");
INSERT INTO `JQx2cw4_options` VALUES("399", "pp_install_date", "2025-11-25 00:39:28", "auto");
INSERT INTO `JQx2cw4_options` VALUES("400", "pp_plugin_activated", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("401", "elementor_experiment-e_swiper_latest", "inactive", "auto");
INSERT INTO `JQx2cw4_options` VALUES("402", "rael_widgets_data_update", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("403", "rael_theme_builder_widgets_data_update", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("404", "rael_facebook_feed_widgets_data_update", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("406", "rael_last_version", "2.0.9", "auto");
INSERT INTO `JQx2cw4_options` VALUES("407", "rael_enable_copy_paste_btn", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("408", "metaslider_plugin_version", "3.104.0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("409", "metaslider_plugin_path", "ml-slider/ml-slider.php", "auto");
INSERT INTO `JQx2cw4_options` VALUES("410", "option_tree_settings", "a:2:{s:8:\"sections\";a:1:{i:0;a:2:{s:2:\"id\";s:7:\"general\";s:5:\"title\";s:7:\"General\";}}s:8:\"settings\";a:1:{i:0;a:10:{s:2:\"id\";s:11:\"sample_text\";s:5:\"label\";s:23:\"Sample Text Field Label\";s:4:\"desc\";s:38:\"Description for the sample text field.\";s:7:\"section\";s:7:\"general\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:5:\"class\";s:0:\"\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:7:\"choices\";a:0:{}}}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("411", "widget_metaslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("412", "ot_media_post_ID", "24", "auto");
INSERT INTO `JQx2cw4_options` VALUES("413", "sh_plugin_options", "a:5:{s:21:\"hero_enable_preloader\";s:2:\"on\";s:27:\"hero_enable_preloader_image\";s:0:\"\";s:24:\"hero_enable_css_override\";s:3:\"off\";s:15:\"sh_custom_style\";s:0:\"\";s:12:\"sh_custom_js\";s:0:\"\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("414", "option_tree", "a:1:{s:11:\"sample_text\";s:0:\"\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("415", "jetpack_connection_active_plugins", "a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("419", "responsive_addons_for_elementor_review_notice", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("425", "tmpcoder_spexo_addons_version", "1.0.27", "auto");
INSERT INTO `JQx2cw4_options` VALUES("426", "_transient_timeout_tmpcoder_upgrade_pro_notice", "1768046947", "off");
INSERT INTO `JQx2cw4_options` VALUES("427", "_transient_tmpcoder_upgrade_pro_notice", "yes", "off");
INSERT INTO `JQx2cw4_options` VALUES("428", "tmpcoder-element-toggle-all", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("429", "tmpcoder-element-post-grid", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("430", "tmpcoder-element-media-grid", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("431", "tmpcoder-element-magazine-grid", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("432", "tmpcoder-element-posts-timeline", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("433", "tmpcoder-element-advanced-slider", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("434", "tmpcoder-element-offcanvas", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("435", "tmpcoder-element-testimonial", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("436", "tmpcoder-element-nav-menu", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("437", "tmpcoder-element-mega-menu", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("438", "tmpcoder-element-onepage-nav", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("439", "tmpcoder-element-data-table", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("440", "tmpcoder-element-pricing-table", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("441", "tmpcoder-element-countdown", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("442", "tmpcoder-element-progress-bar", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("443", "tmpcoder-element-dual-color-heading", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("444", "tmpcoder-element-image-accordion", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("445", "tmpcoder-element-advanced-accordion", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("446", "tmpcoder-element-advanced-text", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("447", "tmpcoder-element-flip-carousel", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("448", "tmpcoder-element-flip-box", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("449", "tmpcoder-element-promo-box", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("450", "tmpcoder-element-feature-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("451", "tmpcoder-element-before-after", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("452", "tmpcoder-element-image-hotspots", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("453", "tmpcoder-element-forms", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("454", "tmpcoder-element-mailchimp", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("455", "tmpcoder-element-content-ticker", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("456", "tmpcoder-element-button", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("457", "tmpcoder-element-dual-button", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("458", "tmpcoder-element-team-member", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("459", "tmpcoder-element-price-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("460", "tmpcoder-element-business-hours", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("461", "tmpcoder-element-sharing-buttons", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("462", "tmpcoder-element-search", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("463", "tmpcoder-element-back-to-top", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("464", "tmpcoder-element-phone-call", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("465", "tmpcoder-element-lottie-animations", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("466", "tmpcoder-element-logo", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("467", "tmpcoder-element-taxonomy-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("468", "tmpcoder-element-page-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("469", "tmpcoder-element-reading-progress-bar", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("470", "tmpcoder-element-Breadcrumb", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("471", "tmpcoder-element-archive-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("472", "tmpcoder-element-recent-post-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("473", "tmpcoder-element-elementor-template", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("474", "tmpcoder-element-post-title", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("475", "tmpcoder-element-archive-title", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("476", "tmpcoder-element-post-thumbnail", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("477", "tmpcoder-element-post-content", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("478", "tmpcoder-element-post-info", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("479", "tmpcoder-element-post-navigation", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("480", "tmpcoder-element-post-comments", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("481", "tmpcoder-element-author-box", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("482", "tmpcoder-element-post-excerpt", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("483", "tmpcoder-element-woo-grid", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("484", "tmpcoder-element-eicon-woocommerce", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("485", "tmpcoder-element-product-title", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("486", "tmpcoder-element-product-media", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("487", "tmpcoder-element-product-media-list", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("488", "tmpcoder-element-product-price", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("489", "tmpcoder-element-product-add-to-cart", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("490", "tmpcoder-element-product-tabs", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("491", "tmpcoder-element-product-excerpt", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("492", "tmpcoder-element-product-content", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("493", "tmpcoder-element-product-rating", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("494", "tmpcoder-element-product-meta", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("495", "tmpcoder-element-product-stock", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("496", "tmpcoder-element-product-mini-cart", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("497", "tmpcoder-element-product-additional-information", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("498", "sastra_addons_wizard_page", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("499", "sastrawp_wizard_page", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("500", "spexo_wizard_page", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("501", "tmpcoder_recent_import_log_file", "/home/thebootroomhq/public_html/websiteonabudget.thebootroomhq.com/wp-content/uploads/spexo-addons/import-25-Nov-2025-12-42-46-52d967d8d08f423d002fc16c9781e983.log", "off");
INSERT INTO `JQx2cw4_options` VALUES("502", "tmpcoder_pro_features_dismiss_notice_1.0.27", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("509", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:3;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1764031805;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("510", "hello_theme_version", "3.4.5", "auto");
INSERT INTO `JQx2cw4_options` VALUES("513", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1764075005;s:5:\"value\";s:7987:\"[{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("522", "tmpcoder-parallax-background", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("523", "tmpcoder-parallax-multi-layer", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("524", "eael_editor_updated_at", "1767777557", "auto");
INSERT INTO `JQx2cw4_options` VALUES("525", "eael_global_settings", "a:1:{s:22:\"eael_ext_scroll_to_top\";a:0:{}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("528", "tmpcoder_st_attachments", "a:13:{i:0;i:26;i:1;i:27;i:2;i:28;i:3;i:29;i:4;i:38;i:5;i:104;i:6;i:105;i:7;i:106;i:8;i:107;i:9;i:108;i:10;i:109;i:11;i:110;i:12;i:1512;}", "off");
INSERT INTO `JQx2cw4_options` VALUES("537", "spexoaddons_elements_cache", "a:1:{s:4:\"page\";a:2:{s:24:\"tmpcoder-advanced-slider\";i:1;s:18:\"tmpcoder-countdown\";i:1;}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("539", "category_children", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("546", "pp_elementor_modules", "a:38:{i:0;s:21:\"pp-advanced-accordion\";i:1;s:17:\"pp-business-hours\";i:2;s:10:\"pp-buttons\";i:3;s:9:\"pp-charts\";i:4;s:17:\"pp-contact-form-7\";i:5;s:17:\"pp-content-reveal\";i:6;s:17:\"pp-content-ticker\";i:7;s:10:\"pp-counter\";i:8;s:10:\"pp-divider\";i:9;s:15:\"pp-dual-heading\";i:10;s:16:\"pp-fancy-heading\";i:11;s:10:\"pp-flipbox\";i:12;s:11:\"pp-hotspots\";i:13;s:12:\"pp-icon-list\";i:14;s:18:\"pp-image-accordion\";i:15;s:19:\"pp-image-comparison\";i:16;s:11:\"pp-info-box\";i:17;s:20:\"pp-info-box-carousel\";i:18;s:12:\"pp-info-list\";i:19;s:13:\"pp-info-table\";i:20;s:12:\"pp-instafeed\";i:21;s:21:\"pp-interactive-circle\";i:22;s:15:\"pp-link-effects\";i:23;s:16:\"pp-logo-carousel\";i:24;s:12:\"pp-logo-grid\";i:25;s:8:\"pp-posts\";i:26;s:13:\"pp-price-menu\";i:27;s:16:\"pp-pricing-table\";i:28;s:15:\"pp-progress-bar\";i:29;s:12:\"pp-promo-box\";i:30;s:15:\"pp-random-image\";i:31;s:15:\"pp-scroll-image\";i:32;s:14:\"pp-team-member\";i:33;s:23:\"pp-team-member-carousel\";i:34;s:18:\"pp-twitter-buttons\";i:35;s:15:\"pp-twitter-grid\";i:36;s:19:\"pp-twitter-timeline\";i:37;s:16:\"pp-twitter-tweet\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("584", "wpr-parallax-background", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("585", "wpr-parallax-multi-layer", "on", "auto");
INSERT INTO `JQx2cw4_options` VALUES("586", "st_attachments", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("589", "wpr_has_used_royal_widgets", "1764043167", "auto");
INSERT INTO `JQx2cw4_options` VALUES("704", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":6,\"critical\":1}", "on");
INSERT INTO `JQx2cw4_options` VALUES("739", "_elementor_ab_testing_data", "a:2:{s:7:\"timeout\";i:1767780459;s:5:\"value\";s:273:\"[{\"coreOnboarding\":{\"emphasizeConnectBenefits101\":false,\"embedConnectInOnboarding102\":false,\"onboardingStartsWithLogin103\":false,\"offerThemeChoicesHelloBiz201\":true,\"emphasizeThemeValueAudience202\":false,\"updateCopyVisuals401\":false,\"reduceHierarchyBlankOption402\":false}}]\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("749", "_elementor_element_cache_unique_id", "4057e72c3dded61959d0d2dcce70f163", "auto");
INSERT INTO `JQx2cw4_options` VALUES("761", "elementor_font_awesome_pro_kit_id", "", "auto");
INSERT INTO `JQx2cw4_options` VALUES("762", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1764141224;s:5:\"value\";s:11281:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"pojo-accessibility\\/pojo-accessibility.php\",\"title\":\"Ally - Web Accessibility. Simplified.\",\"url\":\"\",\"description\":\"Make your website more accessible with powerful tools to detect and fix issues, enhance usability, and create a better experience for all visitors.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/ally_logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/bf-sale-2025.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-advanced-black-friday-25\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/bf-sale-2025.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-black-friday-25\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `JQx2cw4_options` VALUES("825", "theme_mods_oceanwp", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:11:\"mobile_menu\";i:4;s:9:\"main_menu\";i:3;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1764181183;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-2\";a:0:{}s:14:\"search_sidebar\";a:0:{}s:10:\"footer-one\";a:0:{}s:10:\"footer-two\";a:0:{}s:12:\"footer-three\";a:0:{}s:11:\"footer-four\";a:0:{}}}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("826", "oceanwp_theme_installed_version", "4.1.4", "auto");
INSERT INTO `JQx2cw4_options` VALUES("830", "elementor_pro_theme_builder_conditions", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("836", "update_mysticky_version_2_5_7", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("838", "mystickymenu_intro_box", "hide", "auto");
INSERT INTO `JQx2cw4_options` VALUES("841", "sticky_header_status", "done", "auto");
INSERT INTO `JQx2cw4_options` VALUES("842", "has_sticky_header_old_version", "no", "auto");
INSERT INTO `JQx2cw4_options` VALUES("843", "mysticky_option_name", "a:14:{s:17:\"stickymenu_enable\";s:1:\"0\";s:26:\"mysticky_class_id_selector\";s:9:\"main-menu\";s:23:\"mysticky_class_selector\";s:18:\"header#site-header\";s:14:\"myfixed_zindex\";s:5:\"99990\";s:12:\"myfixed_fade\";s:4:\"fade\";s:28:\"myfixed_disable_small_screen\";s:1:\"0\";s:25:\"mysticky_active_on_height\";s:1:\"0\";s:30:\"mysticky_active_on_height_home\";s:1:\"0\";s:15:\"myfixed_bgcolor\";s:7:\"#f7f5e7\";s:23:\"myfixed_transition_time\";s:3:\"0.3\";s:17:\"myfixed_textcolor\";s:0:\"\";s:15:\"myfixed_opacity\";s:2:\"90\";s:14:\"device_desktop\";s:2:\"on\";s:13:\"device_mobile\";s:2:\"on\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("844", "update_mysticky_version_2_6", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("845", "my-sticky-menu_show_upgrade_box_after", "2025-12-11", "auto");
INSERT INTO `JQx2cw4_options` VALUES("846", "mystickymenu_show_affiliate_box_after", "2025-12-01", "auto");
INSERT INTO `JQx2cw4_options` VALUES("854", "metform__banner_last_check", "1765319341", "auto");
INSERT INTO `JQx2cw4_options` VALUES("855", "metform__banner_data", "O:8:\"stdClass\":10:{s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018221\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018221;s:5:\"title\";s:43:\"WordPress Birthday Flash Sale 2025 Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018220\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018220;s:5:\"title\";s:44:\"WordPress Birthday Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("856", "metform_install_date", "2025-11-26 06:13:16", "auto");
INSERT INTO `JQx2cw4_options` VALUES("859", "elpt-installDate", "2026-01-09 12:09:07", "auto");
INSERT INTO `JQx2cw4_options` VALUES("866", "pa_complete_wizard", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("867", "pa_install_time", "26 November, 2025", "auto");
INSERT INTO `JQx2cw4_options` VALUES("883", "pa_edit_time", "1767777557", "auto");
INSERT INTO `JQx2cw4_options` VALUES("892", "pa_elements_91d39f0a7", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("893", "pa_edit_91d39f0a7", "1767776345", "off");
INSERT INTO `JQx2cw4_options` VALUES("934", "ast_block_templates_fresh_site", "no", "auto");
INSERT INTO `JQx2cw4_options` VALUES("935", "ast_blocks_sync_in_progress", "no", "off");
INSERT INTO `JQx2cw4_options` VALUES("936", "ast-block-templates-last-export-checksums-time", "1766731656", "off");
INSERT INTO `JQx2cw4_options` VALUES("1001", "elementskit-lite__stories_last_check", "1767960217", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1002", "elementskit-lite__stories_data", "O:8:\"stdClass\":10:{s:8:\"10022097\";O:8:\"stdClass\":9:{s:2:\"id\";i:10022097;s:5:\"title\";s:26:\"GetGenie Holiday Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768089600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:31:\"https://getgenie.ai/holidaysale\";s:11:\"story_image\";s:79:\"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Getgenie-Holiday-Sale.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10022091\";O:8:\"stdClass\":9:{s:2:\"id\";i:10022091;s:5:\"title\";s:23:\"Wpmet Holiday Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768089600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"story_image\";s:76:\"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Wpmet-Holiday-Sale.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10021822\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021822;s:5:\"title\";s:18:\"BFCM GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh50\";s:11:\"story_image\";s:68:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/GetGenie-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10021818\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021818;s:5:\"title\";s:15:\"Wpmet BFCM 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh80\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/Wpmet-2.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020924\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020924;s:5:\"title\";s:23:\"Halloween GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh45\";s:11:\"story_image\";s:66:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/GetGenie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020922\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020922;s:5:\"title\";s:20:\"Hallowwen Wpmet 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh78\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/Wpmet-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020276\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020276;s:5:\"title\";s:17:\"GetGenie 30K Deal\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1757203200;s:3:\"end\";i:1758499200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://getgenie.ai/30kstory\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/09/Genie-30K-GIF.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019442\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019442;s:5:\"title\";s:23:\"Wpmet Birthday 25 Genie\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:1:{i:0;s:8:\"getgenie\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:32:\"https://wpmet.com/gbday-story-25\";s:11:\"story_image\";s:63:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/Genie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019440\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019440;s:5:\"title\";s:19:\"Wpmet Birthday 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:6:{i:0;s:8:\"emailkit\";i:1;s:21:\"gutenkit-blocks-addon\";i:2;s:7:\"metform\";i:3;s:10:\"shopengine\";i:4;s:9:\"wp-social\";i:5;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:31:\"https://wpmet.com/bday-story-25\";s:11:\"story_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/WP.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10018690\";O:8:\"stdClass\":9:{s:2:\"id\";i:10018690;s:5:\"title\";s:36:\"GetGenie 4th of July Flash Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:27:\"https://getgenie.ai/story45\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/GetGenie__Gif.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1033", "seedprod_migration_run_once", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1034", "seedprod_run_activation", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1035", "seedprod_settings", "{  \n   \"api_key\":\"\",\n   \"enable_coming_soon_mode\":false,\n   \"enable_maintenance_mode\":false,\n   \"enable_login_mode\":false,\n   \"enable_404_mode\":false\n }", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1036", "seedprod_over_time", "a:3:{s:17:\"installed_version\";s:6:\"6.19.5\";s:14:\"installed_date\";i:1764249609;s:13:\"installed_pro\";s:4:\"lite\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1037", "seedprod_token", "c08f109f-19f5-4002-8770-40ae5f594cd6", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1042", "happy_addons_activation_time", "1764249609", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1043", "happyaddons_do_wizard_direct", "running", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1044", "uae_lite_is_activated", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1046", "happy-elementor-x98237938759348573", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1047", "happyaddons_version", "3.20.2", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1048", "hfe_is_theme_supported", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1049", "theplus_options", "a:2:{s:14:\"check_elements\";a:28:{i:0;s:12:\"tp_accordion\";i:1;s:17:\"tp_adv_text_block\";i:2;s:13:\"tp_blockquote\";i:3;s:15:\"tp_blog_listout\";i:4;s:9:\"tp_button\";i:5;s:17:\"tp_contact_form_7\";i:6;s:12:\"tp_countdown\";i:7;s:18:\"tp_clients_listout\";i:8;s:18:\"tp_gallery_listout\";i:9;s:11:\"tp_flip_box\";i:10;s:20:\"tp_heading_animation\";i:11;s:16:\"tp_header_extras\";i:12;s:16:\"tp_heading_title\";i:13;s:11:\"tp_info_box\";i:14;s:23:\"tp_navigation_menu_lite\";i:15;s:14:\"tp_page_scroll\";i:16;s:15:\"tp_progress_bar\";i:17;s:17:\"tp_number_counter\";i:18;s:16:\"tp_pricing_table\";i:19;s:20:\"tp_scroll_navigation\";i:20;s:14:\"tp_social_icon\";i:21;s:13:\"tp_tabs_tours\";i:22;s:22:\"tp_team_member_listout\";i:23;s:22:\"tp_testimonial_listout\";i:24;s:15:\"tp_video_player\";i:25;s:12:\"tp_plus_form\";i:26;s:13:\"tp_style_list\";i:27;s:7:\"tp_icon\";}s:15:\"extras_elements\";a:0:{}}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1050", "post_type_options", "a:3:{s:16:\"client_post_type\";s:7:\"disable\";s:21:\"testimonial_post_type\";s:7:\"disable\";s:21:\"team_member_post_type\";s:7:\"disable\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1051", "theplus_styling_data", "a:3:{s:17:\"tp_styling_hidden\";s:6:\"hidden\";s:25:\"theplus_custom_css_editor\";s:0:\"\";s:24:\"theplus_custom_js_editor\";s:0:\"\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1052", "theplus_performance", "a:1:{s:17:\"plus_cache_option\";s:8:\"separate\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1053", "theplus_api_connection_data", "a:26:{s:17:\"plus_lazyload_opt\";s:7:\"disable\";s:22:\"plus_lazyload_opt_anim\";s:4:\"fade\";s:23:\"theplus_facebook_app_id\";s:0:\"\";s:15:\"load_icons_mind\";s:7:\"disable\";s:15:\"gmap_api_switch\";s:6:\"enable\";s:20:\"load_pre_loader_func\";s:7:\"disable\";s:23:\"scroll_animation_offset\";i:85;s:26:\"theplus_site_key_recaptcha\";s:0:\"\";s:28:\"theplus_secret_key_recaptcha\";s:0:\"\";s:27:\"theplus_facebook_app_secret\";s:0:\"\";s:24:\"theplus_google_client_id\";s:0:\"\";s:27:\"theplus_google_analytics_id\";s:0:\"\";s:25:\"theplus_facebook_pixel_id\";s:0:\"\";s:19:\"load_icons_mind_ids\";s:0:\"\";s:22:\"theplus_google_map_api\";s:0:\"\";s:21:\"theplus_mailchimp_api\";s:0:\"\";s:20:\"theplus_mailchimp_id\";s:0:\"\";s:25:\"load_pre_loader_lottie_js\";s:2:\"on\";s:24:\"load_pre_loader_func_ids\";s:0:\"\";s:28:\"dynamic_category_thumb_check\";s:2:\"on\";s:27:\"theplus_woo_swatches_switch\";s:2:\"on\";s:33:\"theplus_custom_field_video_switch\";s:2:\"on\";s:34:\"theplus_woo_recently_viewed_switch\";s:2:\"on\";s:28:\"theplus_woo_countdown_switch\";s:2:\"on\";s:33:\"theplus_woo_thank_you_page_select\";s:0:\"\";s:23:\"bodymovin_load_js_check\";s:2:\"on\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1054", "tpae_install_time", "2025-11-27 13:20:15", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1057", "tpae_menu_notification", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1058", "tpae_whats_new_notification", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1060", "_hfe_db_version", "2.8.0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1061", "seedprod_notifications", "a:4:{s:6:\"update\";i:1765286674;s:4:\"feed\";a:1:{i:0;a:7:{s:5:\"title\";s:28:\"Green Monday Gives Back 🌱\";s:7:\"content\";s:255:\"Wrap up the year with savings that make a difference. Save up to 65% off SeedProd and get the SeedProd + RafflePress bundle for even more value. We’ll donate a portion of every sale to The Conservation Fund to help protect nature for future generations.\";s:4:\"type\";a:1:{i:0;s:3:\"any\";}s:2:\"id\";i:87;s:4:\"btns\";a:1:{s:4:\"main\";a:2:{s:3:\"url\";s:114:\"https://www.seedprod.com/pricing/?utm_source=sp-notification&utm_medium=in-plugin-cta&utm_campaign=black-friday-25\";s:4:\"text\";s:11:\"Save & Give\";}}s:5:\"start\";s:19:\"2025-12-07 23:59:00\";s:3:\"end\";s:19:\"2025-12-12 23:59:00\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1062", "hfe_onboarding_triggered", "yes", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1063", "hfe_plugin_previous_version", "2.7.0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1064", "hfe_plugin_version", "2.8.0", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1065", "tp_save_update_at", "1767775654", "off");
INSERT INTO `JQx2cw4_options` VALUES("1066", "tpae_version_cache", "a:2:{i:0;s:5:\"6.4.2\";i:1;s:5:\"5.6.0\";}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1067", "uae_analytics_installed_time", "1764249625", "off");
INSERT INTO `JQx2cw4_options` VALUES("1068", "nps-survey-header-footer-elementor", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1764249625;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1069", "seedprod_dismiss_setup_wizard", "1", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1074", "happyaddons_elements_cache", "a:0:{}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1076", "tpae_backend_cache", "1764249708", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1080", "wkit_settings_panel", "a:9:{s:7:\"builder\";b:1;s:8:\"template\";b:1;s:17:\"gutenberg_builder\";b:0;s:17:\"elementor_builder\";b:1;s:14:\"bricks_builder\";b:0;s:13:\"debugger_mode\";b:0;s:18:\"gutenberg_template\";b:0;s:18:\"elementor_template\";b:1;s:12:\"code_snippet\";b:1;}", "auto");
INSERT INTO `JQx2cw4_options` VALUES("1081", "wkit_builder", "a:1:{i:0;s:10:\"WDesignKit\";}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1083", "wkit_deactivate_widgets", "a:0:{}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1088", "ha_library_cache", "a:3:{s:9:\"templates\";a:529:{i:0;a:8:{s:2:\"id\";i:1551;s:5:\"title\";s:8:\"Banner17\";s:10:\"created_at\";s:19:\"2020-05-23 09:50:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner17/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/banner17-400x231.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:5:\"music\";}}i:1;a:8:{s:2:\"id\";i:1365;s:5:\"title\";s:6:\"Sales6\";s:10:\"created_at\";s:19:\"2020-05-20 19:13:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale6-400x235.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:2;a:8:{s:2:\"id\";i:2655;s:5:\"title\";s:9:\"Feature18\";s:10:\"created_at\";s:19:\"2020-06-07 05:19:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature18/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature18-400x237.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:3;a:8:{s:2:\"id\";i:1658;s:5:\"title\";s:6:\"Music1\";s:10:\"created_at\";s:19:\"2020-05-24 19:55:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/music1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/music1-1-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"music\";}}i:4;a:8:{s:2:\"id\";i:2528;s:5:\"title\";s:12:\"ImageBlock36\";s:10:\"created_at\";s:19:\"2020-06-03 09:47:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock36/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock36-400x195.jpg\";s:4:\"tags\";a:2:{i:0;s:11:\"image-block\";i:1;s:5:\"music\";}}i:5;a:8:{s:2:\"id\";i:2644;s:5:\"title\";s:12:\"ImageBlock39\";s:10:\"created_at\";s:19:\"2020-06-04 20:45:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock39/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock39-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:6;a:8:{s:2:\"id\";i:115;s:5:\"title\";s:8:\"Banner14\";s:10:\"created_at\";s:19:\"2020-04-23 07:57:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner14-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:7;a:8:{s:2:\"id\";i:1398;s:5:\"title\";s:6:\"Sales9\";s:10:\"created_at\";s:19:\"2020-05-21 15:58:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale9a-400x205.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:5:\"sales\";}}i:8;a:8:{s:2:\"id\";i:2810;s:5:\"title\";s:9:\"Product12\";s:10:\"created_at\";s:19:\"2020-06-13 16:15:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/product12-400x197.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"product\";i:1;s:5:\"sales\";}}i:9;a:8:{s:2:\"id\";i:2833;s:5:\"title\";s:7:\"Sales11\";s:10:\"created_at\";s:19:\"2020-06-17 21:30:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/sales11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/sale11-400x238.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:10;a:8:{s:2:\"id\";i:2850;s:5:\"title\";s:7:\"Sales12\";s:10:\"created_at\";s:19:\"2020-06-19 16:22:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/sales12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/sales12a-400x208.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:11;a:8:{s:2:\"id\";i:12;s:5:\"title\";s:7:\"Banner3\";s:10:\"created_at\";s:19:\"2020-04-21 08:06:35\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner3-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:12;a:8:{s:2:\"id\";i:16;s:5:\"title\";s:8:\"Banner 1\";s:10:\"created_at\";s:19:\"2020-04-20 10:43:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/elementor-16/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner1-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:13;a:8:{s:2:\"id\";i:25;s:5:\"title\";s:7:\"Banner2\";s:10:\"created_at\";s:19:\"2020-04-20 10:55:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner2-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:14;a:8:{s:2:\"id\";i:41;s:5:\"title\";s:7:\"Banner4\";s:10:\"created_at\";s:19:\"2020-04-21 08:11:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner4-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:15;a:8:{s:2:\"id\";i:47;s:5:\"title\";s:7:\"Banner5\";s:10:\"created_at\";s:19:\"2020-04-21 08:18:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner5-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:16;a:8:{s:2:\"id\";i:52;s:5:\"title\";s:7:\"Banner6\";s:10:\"created_at\";s:19:\"2020-04-21 08:54:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner6-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:17;a:8:{s:2:\"id\";i:60;s:5:\"title\";s:7:\"Banner7\";s:10:\"created_at\";s:19:\"2020-04-22 07:45:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner7-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:18;a:8:{s:2:\"id\";i:67;s:5:\"title\";s:7:\"Banner8\";s:10:\"created_at\";s:19:\"2020-04-22 08:35:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner8-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:19;a:8:{s:2:\"id\";i:81;s:5:\"title\";s:7:\"Banner9\";s:10:\"created_at\";s:19:\"2020-04-22 09:46:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/banner9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner9-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:20;a:8:{s:2:\"id\";i:85;s:5:\"title\";s:8:\"Banner10\";s:10:\"created_at\";s:19:\"2020-04-22 09:50:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner10-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:21;a:8:{s:2:\"id\";i:90;s:5:\"title\";s:8:\"Banner11\";s:10:\"created_at\";s:19:\"2020-04-22 09:51:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner11-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:22;a:8:{s:2:\"id\";i:96;s:5:\"title\";s:8:\"Banner12\";s:10:\"created_at\";s:19:\"2020-04-22 10:03:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner12-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:23;a:8:{s:2:\"id\";i:108;s:5:\"title\";s:8:\"Banner13\";s:10:\"created_at\";s:19:\"2020-04-22 14:31:43\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner13/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner13-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:24;a:8:{s:2:\"id\";i:119;s:5:\"title\";s:8:\"Banner15\";s:10:\"created_at\";s:19:\"2020-04-23 07:58:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner15-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:25;a:8:{s:2:\"id\";i:128;s:5:\"title\";s:8:\"Banner16\";s:10:\"created_at\";s:19:\"2020-04-23 08:05:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/04/banner16-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:26;a:8:{s:2:\"id\";i:137;s:5:\"title\";s:8:\"Feature1\";s:10:\"created_at\";s:19:\"2020-05-14 07:50:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature1-1-400x183.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:27;a:8:{s:2:\"id\";i:148;s:5:\"title\";s:8:\"Feature2\";s:10:\"created_at\";s:19:\"2020-05-14 08:11:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature1-400x199.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:28;a:8:{s:2:\"id\";i:153;s:5:\"title\";s:8:\"Feature3\";s:10:\"created_at\";s:19:\"2020-05-14 08:16:46\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature3-400x193.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:5:\"music\";}}i:29;a:8:{s:2:\"id\";i:161;s:5:\"title\";s:8:\"Feature4\";s:10:\"created_at\";s:19:\"2020-05-14 08:55:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature4-400x240.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:30;a:8:{s:2:\"id\";i:169;s:5:\"title\";s:8:\"Feature5\";s:10:\"created_at\";s:19:\"2020-05-14 09:04:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature5-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:31;a:8:{s:2:\"id\";i:175;s:5:\"title\";s:8:\"Feature6\";s:10:\"created_at\";s:19:\"2020-05-14 09:13:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature6-400x254.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:32;a:8:{s:2:\"id\";i:180;s:5:\"title\";s:8:\"Feature7\";s:10:\"created_at\";s:19:\"2020-05-14 09:53:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature7-400x203.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:33;a:8:{s:2:\"id\";i:187;s:5:\"title\";s:11:\"Intro Text1\";s:10:\"created_at\";s:19:\"2020-05-14 10:05:49\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext1-400x177.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:34;a:8:{s:2:\"id\";i:200;s:5:\"title\";s:11:\"Intro Text2\";s:10:\"created_at\";s:19:\"2020-05-14 11:13:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext2-400x125.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:35;a:8:{s:2:\"id\";i:203;s:5:\"title\";s:11:\"Intro Text3\";s:10:\"created_at\";s:19:\"2020-05-14 11:15:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext3-400x145.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:36;a:8:{s:2:\"id\";i:207;s:5:\"title\";s:11:\"Intro Text4\";s:10:\"created_at\";s:19:\"2020-05-14 11:17:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext4-400x195.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:37;a:8:{s:2:\"id\";i:212;s:5:\"title\";s:11:\"Intro Text5\";s:10:\"created_at\";s:19:\"2020-05-14 11:19:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext5-400x255.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:38;a:8:{s:2:\"id\";i:215;s:5:\"title\";s:11:\"Intro Text6\";s:10:\"created_at\";s:19:\"2020-05-14 11:22:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext6-400x208.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:39;a:8:{s:2:\"id\";i:219;s:5:\"title\";s:11:\"Intro Text7\";s:10:\"created_at\";s:19:\"2020-05-14 11:24:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext7-400x173.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:40;a:8:{s:2:\"id\";i:225;s:5:\"title\";s:11:\"Intro Text8\";s:10:\"created_at\";s:19:\"2020-05-14 11:34:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext8-400x203.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:41;a:8:{s:2:\"id\";i:231;s:5:\"title\";s:9:\"Parallax1\";s:10:\"created_at\";s:19:\"2020-05-14 11:53:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax1-400x190.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:42;a:8:{s:2:\"id\";i:237;s:5:\"title\";s:9:\"Parallax2\";s:10:\"created_at\";s:19:\"2020-05-14 12:06:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax2-400x206.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:43;a:8:{s:2:\"id\";i:242;s:5:\"title\";s:9:\"Parallax3\";s:10:\"created_at\";s:19:\"2020-05-14 12:07:56\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax3-400x182.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:44;a:8:{s:2:\"id\";i:248;s:5:\"title\";s:9:\"Parallax4\";s:10:\"created_at\";s:19:\"2020-05-14 12:09:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax4-400x193.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:45;a:8:{s:2:\"id\";i:253;s:5:\"title\";s:9:\"Parallax5\";s:10:\"created_at\";s:19:\"2020-05-14 12:11:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax5-400x191.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:46;a:8:{s:2:\"id\";i:258;s:5:\"title\";s:9:\"Parallax6\";s:10:\"created_at\";s:19:\"2020-05-14 12:13:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax6-400x176.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:47;a:8:{s:2:\"id\";i:263;s:5:\"title\";s:9:\"Parallax7\";s:10:\"created_at\";s:19:\"2020-05-14 12:14:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax7-400x178.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:8:\"parallax\";}}i:48;a:8:{s:2:\"id\";i:268;s:5:\"title\";s:9:\"Parallax8\";s:10:\"created_at\";s:19:\"2020-05-14 12:16:16\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax8-400x206.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:49;a:8:{s:2:\"id\";i:273;s:5:\"title\";s:9:\"Parallax9\";s:10:\"created_at\";s:19:\"2020-05-14 12:18:46\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/parallax9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax9-400x168.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:50;a:8:{s:2:\"id\";i:279;s:5:\"title\";s:10:\"Parallax10\";s:10:\"created_at\";s:19:\"2020-05-14 12:20:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/parallax10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax10-400x158.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:51;a:8:{s:2:\"id\";i:284;s:5:\"title\";s:10:\"Parallax11\";s:10:\"created_at\";s:19:\"2020-05-14 12:22:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/parallax11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax11a-400x165.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:52;a:8:{s:2:\"id\";i:290;s:5:\"title\";s:10:\"Parallax12\";s:10:\"created_at\";s:19:\"2020-05-14 12:23:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/parallax12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/parallax12-400x228.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"parallax\";}}i:53;a:8:{s:2:\"id\";i:296;s:5:\"title\";s:8:\"Service1\";s:10:\"created_at\";s:19:\"2020-05-14 13:37:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service1-400x202.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:54;a:8:{s:2:\"id\";i:308;s:5:\"title\";s:8:\"Service2\";s:10:\"created_at\";s:19:\"2020-05-14 13:40:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service2-400x268.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:55;a:8:{s:2:\"id\";i:311;s:5:\"title\";s:8:\"Service3\";s:10:\"created_at\";s:19:\"2020-05-14 13:49:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service3-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:56;a:8:{s:2:\"id\";i:314;s:5:\"title\";s:8:\"Service4\";s:10:\"created_at\";s:19:\"2020-05-14 13:51:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service4-400x253.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:57;a:8:{s:2:\"id\";i:324;s:5:\"title\";s:8:\"Service5\";s:10:\"created_at\";s:19:\"2020-05-14 13:55:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service5-400x227.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:58;a:8:{s:2:\"id\";i:327;s:5:\"title\";s:8:\"Service6\";s:10:\"created_at\";s:19:\"2020-05-14 13:58:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/service6-400x230.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:59;a:8:{s:2:\"id\";i:333;s:5:\"title\";s:9:\"About us1\";s:10:\"created_at\";s:19:\"2020-05-14 17:27:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about1-400x157.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:60;a:8:{s:2:\"id\";i:348;s:5:\"title\";s:9:\"About us2\";s:10:\"created_at\";s:19:\"2020-05-14 17:48:13\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about2-400x197.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:61;a:8:{s:2:\"id\";i:351;s:5:\"title\";s:9:\"About us3\";s:10:\"created_at\";s:19:\"2020-05-14 17:50:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about3-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:62;a:8:{s:2:\"id\";i:355;s:5:\"title\";s:9:\"About us4\";s:10:\"created_at\";s:19:\"2020-05-14 17:53:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about4-400x191.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:63;a:8:{s:2:\"id\";i:359;s:5:\"title\";s:9:\"About us5\";s:10:\"created_at\";s:19:\"2020-05-14 17:58:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about5-400x231.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:64;a:8:{s:2:\"id\";i:363;s:5:\"title\";s:9:\"About us6\";s:10:\"created_at\";s:19:\"2020-05-14 18:02:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about6-400x170.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:65;a:8:{s:2:\"id\";i:366;s:5:\"title\";s:9:\"About us7\";s:10:\"created_at\";s:19:\"2020-05-14 18:04:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about7-400x201.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:66;a:8:{s:2:\"id\";i:371;s:5:\"title\";s:9:\"About us8\";s:10:\"created_at\";s:19:\"2020-05-14 18:14:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about8-400x240.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:67;a:8:{s:2:\"id\";i:374;s:5:\"title\";s:9:\"About us9\";s:10:\"created_at\";s:19:\"2020-05-14 18:24:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/about-us9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about9-400x145.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:68;a:8:{s:2:\"id\";i:377;s:5:\"title\";s:10:\"About us10\";s:10:\"created_at\";s:19:\"2020-05-14 18:57:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/about-us10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/about10-400x278.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:69;a:8:{s:2:\"id\";i:384;s:5:\"title\";s:11:\"ImageBlock1\";s:10:\"created_at\";s:19:\"2020-05-14 19:09:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock1-400x143.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:70;a:8:{s:2:\"id\";i:401;s:5:\"title\";s:11:\"ImageBlock2\";s:10:\"created_at\";s:19:\"2020-05-14 19:20:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock2-400x175.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:71;a:8:{s:2:\"id\";i:405;s:5:\"title\";s:11:\"ImageBlock3\";s:10:\"created_at\";s:19:\"2020-05-14 19:26:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock3-400x166.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:72;a:8:{s:2:\"id\";i:409;s:5:\"title\";s:11:\"ImageBlock4\";s:10:\"created_at\";s:19:\"2020-05-14 19:28:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock4-400x157.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:73;a:8:{s:2:\"id\";i:413;s:5:\"title\";s:11:\"ImageBlock5\";s:10:\"created_at\";s:19:\"2020-05-14 19:32:00\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:66:\"https://templates.happyaddons.com/template/imageblock4-cloned-409/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock5-400x158.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:74;a:8:{s:2:\"id\";i:418;s:5:\"title\";s:11:\"ImageBlock6\";s:10:\"created_at\";s:19:\"2020-05-14 19:34:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock6-400x168.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:75;a:8:{s:2:\"id\";i:421;s:5:\"title\";s:11:\"ImageBlock7\";s:10:\"created_at\";s:19:\"2020-05-14 19:36:14\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock7-400x173.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:76;a:8:{s:2:\"id\";i:424;s:5:\"title\";s:11:\"ImageBlock8\";s:10:\"created_at\";s:19:\"2020-05-14 19:38:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock8-400x232.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:77;a:8:{s:2:\"id\";i:431;s:5:\"title\";s:11:\"ImageBlock9\";s:10:\"created_at\";s:19:\"2020-05-14 19:41:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/imageblock9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock9-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:78;a:8:{s:2:\"id\";i:435;s:5:\"title\";s:12:\"ImageBlock10\";s:10:\"created_at\";s:19:\"2020-05-14 19:43:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock10-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:79;a:8:{s:2:\"id\";i:439;s:5:\"title\";s:12:\"ImageBlock11\";s:10:\"created_at\";s:19:\"2020-05-14 19:44:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock11-400x248.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:80;a:8:{s:2:\"id\";i:443;s:5:\"title\";s:12:\"ImageBlock12\";s:10:\"created_at\";s:19:\"2020-05-14 19:45:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock12-400x237.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:81;a:8:{s:2:\"id\";i:448;s:5:\"title\";s:11:\"Fun Factor1\";s:10:\"created_at\";s:19:\"2020-05-15 19:15:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor1-400x135.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:82;a:8:{s:2:\"id\";i:457;s:5:\"title\";s:11:\"Fun Factor2\";s:10:\"created_at\";s:19:\"2020-05-15 19:17:49\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor2-400x135.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:83;a:8:{s:2:\"id\";i:460;s:5:\"title\";s:11:\"Fun Factor3\";s:10:\"created_at\";s:19:\"2020-05-15 19:18:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor3-400x179.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:84;a:8:{s:2:\"id\";i:464;s:5:\"title\";s:11:\"Fun Factor4\";s:10:\"created_at\";s:19:\"2020-05-15 19:20:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor4-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:85;a:8:{s:2:\"id\";i:468;s:5:\"title\";s:11:\"Fun Factor5\";s:10:\"created_at\";s:19:\"2020-05-15 19:22:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor5-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:86;a:8:{s:2:\"id\";i:471;s:5:\"title\";s:11:\"Fun Factor6\";s:10:\"created_at\";s:19:\"2020-05-15 19:24:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor6-400x107.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:87;a:8:{s:2:\"id\";i:475;s:5:\"title\";s:5:\"Team1\";s:10:\"created_at\";s:19:\"2020-05-16 08:02:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team1-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:88;a:8:{s:2:\"id\";i:500;s:5:\"title\";s:5:\"Team3\";s:10:\"created_at\";s:19:\"2020-05-16 16:44:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team3-400x267.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:89;a:8:{s:2:\"id\";i:501;s:5:\"title\";s:5:\"Team2\";s:10:\"created_at\";s:19:\"2020-05-16 16:36:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team2-400x236.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:90;a:8:{s:2:\"id\";i:507;s:5:\"title\";s:5:\"Team4\";s:10:\"created_at\";s:19:\"2020-05-16 16:48:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team4-400x267.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:91;a:8:{s:2:\"id\";i:509;s:5:\"title\";s:5:\"Team5\";s:10:\"created_at\";s:19:\"2020-05-16 17:03:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team5-400x365.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:92;a:8:{s:2:\"id\";i:521;s:5:\"title\";s:5:\"Team6\";s:10:\"created_at\";s:19:\"2020-05-16 17:10:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team6-400x210.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:93;a:8:{s:2:\"id\";i:528;s:5:\"title\";s:5:\"Team7\";s:10:\"created_at\";s:19:\"2020-05-16 17:14:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team7-400x210.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:94;a:8:{s:2:\"id\";i:533;s:5:\"title\";s:5:\"Team8\";s:10:\"created_at\";s:19:\"2020-05-16 17:17:14\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team8-400x242.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:95;a:8:{s:2:\"id\";i:552;s:5:\"title\";s:5:\"Team9\";s:10:\"created_at\";s:19:\"2020-05-16 18:47:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/team9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team9-400x260.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:96;a:8:{s:2:\"id\";i:555;s:5:\"title\";s:6:\"Team10\";s:10:\"created_at\";s:19:\"2020-05-16 18:49:49\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team10-400x247.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:97;a:8:{s:2:\"id\";i:559;s:5:\"title\";s:6:\"Team11\";s:10:\"created_at\";s:19:\"2020-05-16 18:51:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team11-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:98;a:8:{s:2:\"id\";i:564;s:5:\"title\";s:6:\"Team12\";s:10:\"created_at\";s:19:\"2020-05-16 18:52:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team12-400x272.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:99;a:8:{s:2:\"id\";i:569;s:5:\"title\";s:6:\"Team13\";s:10:\"created_at\";s:19:\"2020-05-16 18:54:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team13-400x197.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:100;a:8:{s:2:\"id\";i:574;s:5:\"title\";s:6:\"Team14\";s:10:\"created_at\";s:19:\"2020-05-16 18:55:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team14-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:101;a:8:{s:2:\"id\";i:578;s:5:\"title\";s:6:\"Team15\";s:10:\"created_at\";s:19:\"2020-05-16 18:56:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team15-400x179.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:102;a:8:{s:2:\"id\";i:582;s:5:\"title\";s:6:\"Team16\";s:10:\"created_at\";s:19:\"2020-05-16 18:58:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team16-400x253.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:103;a:8:{s:2:\"id\";i:585;s:5:\"title\";s:14:\"Content Block1\";s:10:\"created_at\";s:19:\"2020-05-16 20:10:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content1-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:104;a:8:{s:2:\"id\";i:602;s:5:\"title\";s:14:\"Content Block2\";s:10:\"created_at\";s:19:\"2020-05-16 20:13:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content2-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:105;a:8:{s:2:\"id\";i:606;s:5:\"title\";s:14:\"Content Block3\";s:10:\"created_at\";s:19:\"2020-05-16 20:14:25\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content3-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:106;a:8:{s:2:\"id\";i:610;s:5:\"title\";s:14:\"Content Block4\";s:10:\"created_at\";s:19:\"2020-05-16 20:15:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content4-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:107;a:8:{s:2:\"id\";i:614;s:5:\"title\";s:14:\"Content Block5\";s:10:\"created_at\";s:19:\"2020-05-16 20:16:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content5-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:108;a:8:{s:2:\"id\";i:618;s:5:\"title\";s:14:\"Content Block6\";s:10:\"created_at\";s:19:\"2020-05-16 20:17:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content6-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:109;a:8:{s:2:\"id\";i:622;s:5:\"title\";s:14:\"Content Block7\";s:10:\"created_at\";s:19:\"2020-05-16 20:19:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content7-400x179.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:110;a:8:{s:2:\"id\";i:626;s:5:\"title\";s:14:\"Content Block8\";s:10:\"created_at\";s:19:\"2020-05-16 20:20:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content8-400x128.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:111;a:8:{s:2:\"id\";i:630;s:5:\"title\";s:14:\"Content Block9\";s:10:\"created_at\";s:19:\"2020-05-16 20:21:50\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/content-block9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content9-400x128.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:112;a:8:{s:2:\"id\";i:633;s:5:\"title\";s:15:\"Content Block10\";s:10:\"created_at\";s:19:\"2020-05-16 20:23:10\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content10-400x206.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:113;a:8:{s:2:\"id\";i:637;s:5:\"title\";s:15:\"Content Block11\";s:10:\"created_at\";s:19:\"2020-05-16 20:24:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content11-400x178.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:114;a:8:{s:2:\"id\";i:642;s:5:\"title\";s:15:\"Content Block12\";s:10:\"created_at\";s:19:\"2020-05-16 20:27:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content12-400x178.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:115;a:8:{s:2:\"id\";i:647;s:5:\"title\";s:12:\"Client Logo1\";s:10:\"created_at\";s:19:\"2020-05-17 07:26:56\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client1-400x158.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:116;a:8:{s:2:\"id\";i:673;s:5:\"title\";s:12:\"Client Logo2\";s:10:\"created_at\";s:19:\"2020-05-17 07:44:16\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client2-400x95.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:117;a:8:{s:2:\"id\";i:676;s:5:\"title\";s:12:\"Client Logo3\";s:10:\"created_at\";s:19:\"2020-05-17 07:48:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client3-400x183.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:118;a:8:{s:2:\"id\";i:681;s:5:\"title\";s:12:\"Client Logo4\";s:10:\"created_at\";s:19:\"2020-05-17 07:53:13\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client4-400x145.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:119;a:8:{s:2:\"id\";i:686;s:5:\"title\";s:12:\"Client Logo5\";s:10:\"created_at\";s:19:\"2020-05-17 07:56:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client5-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:120;a:8:{s:2:\"id\";i:692;s:5:\"title\";s:12:\"Client Logo6\";s:10:\"created_at\";s:19:\"2020-05-17 08:02:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client6-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:121;a:8:{s:2:\"id\";i:695;s:5:\"title\";s:12:\"Client Logo7\";s:10:\"created_at\";s:19:\"2020-05-17 08:05:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client7-400x92.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:122;a:8:{s:2:\"id\";i:705;s:5:\"title\";s:12:\"Client Logo8\";s:10:\"created_at\";s:19:\"2020-05-17 08:07:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client8-400x92.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:123;a:8:{s:2:\"id\";i:708;s:5:\"title\";s:12:\"Client Logo9\";s:10:\"created_at\";s:19:\"2020-05-17 08:09:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/client-logo9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client9-400x114.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:124;a:8:{s:2:\"id\";i:711;s:5:\"title\";s:13:\"Client Logo10\";s:10:\"created_at\";s:19:\"2020-05-17 08:10:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/client-logo10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client10-400x124.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:125;a:8:{s:2:\"id\";i:714;s:5:\"title\";s:13:\"Client Logo11\";s:10:\"created_at\";s:19:\"2020-05-17 08:11:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/client-logo11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client11-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:126;a:8:{s:2:\"id\";i:718;s:5:\"title\";s:13:\"Client Logo12\";s:10:\"created_at\";s:19:\"2020-05-17 08:13:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/client-logo12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client12-400x117.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:127;a:8:{s:2:\"id\";i:721;s:5:\"title\";s:13:\"Client Logo13\";s:10:\"created_at\";s:19:\"2020-05-17 08:14:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/client-logo13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/client13-400x124.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:128;a:8:{s:2:\"id\";i:724;s:5:\"title\";s:4:\"CTA1\";s:10:\"created_at\";s:19:\"2020-05-17 11:42:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta1-400x110.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:129;a:8:{s:2:\"id\";i:736;s:5:\"title\";s:4:\"CTA2\";s:10:\"created_at\";s:19:\"2020-05-17 11:46:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta2-400x56.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:130;a:8:{s:2:\"id\";i:739;s:5:\"title\";s:4:\"CTA3\";s:10:\"created_at\";s:19:\"2020-05-17 11:49:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta3-400x57.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:131;a:8:{s:2:\"id\";i:742;s:5:\"title\";s:4:\"CTA4\";s:10:\"created_at\";s:19:\"2020-05-17 11:51:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta4-400x40.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:132;a:8:{s:2:\"id\";i:745;s:5:\"title\";s:4:\"CTA5\";s:10:\"created_at\";s:19:\"2020-05-17 11:55:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta5-400x78.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:133;a:8:{s:2:\"id\";i:748;s:5:\"title\";s:4:\"CTA6\";s:10:\"created_at\";s:19:\"2020-05-17 11:57:35\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta6-400x107.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:134;a:8:{s:2:\"id\";i:751;s:5:\"title\";s:4:\"CTA7\";s:10:\"created_at\";s:19:\"2020-05-17 11:58:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta7-400x191.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:135;a:8:{s:2:\"id\";i:752;s:5:\"title\";s:4:\"CTA8\";s:10:\"created_at\";s:19:\"2020-05-17 11:58:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta8-400x185.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:136;a:8:{s:2:\"id\";i:759;s:5:\"title\";s:4:\"CTA9\";s:10:\"created_at\";s:19:\"2020-05-17 12:02:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/cta9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/cta9-400x139.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:137;a:8:{s:2:\"id\";i:766;s:5:\"title\";s:4:\"FAQ1\";s:10:\"created_at\";s:19:\"2020-05-17 12:19:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq1-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:138;a:8:{s:2:\"id\";i:782;s:5:\"title\";s:4:\"FAQ2\";s:10:\"created_at\";s:19:\"2020-05-17 12:25:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq2-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:139;a:8:{s:2:\"id\";i:785;s:5:\"title\";s:4:\"FAQ3\";s:10:\"created_at\";s:19:\"2020-05-17 13:19:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq3-400x263.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:140;a:8:{s:2:\"id\";i:788;s:5:\"title\";s:4:\"FAQ4\";s:10:\"created_at\";s:19:\"2020-05-17 13:27:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq4-400x167.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:141;a:8:{s:2:\"id\";i:793;s:5:\"title\";s:4:\"FAQ5\";s:10:\"created_at\";s:19:\"2020-05-17 13:29:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq5-400x258.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:142;a:8:{s:2:\"id\";i:796;s:5:\"title\";s:4:\"FAQ6\";s:10:\"created_at\";s:19:\"2020-05-17 13:31:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq6-400x288.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:143;a:8:{s:2:\"id\";i:800;s:5:\"title\";s:4:\"FAQ7\";s:10:\"created_at\";s:19:\"2020-05-17 13:33:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq7-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:144;a:8:{s:2:\"id\";i:803;s:5:\"title\";s:4:\"FAQ8\";s:10:\"created_at\";s:19:\"2020-05-17 13:34:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq8-400x203.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:145;a:8:{s:2:\"id\";i:807;s:5:\"title\";s:4:\"FAQ9\";s:10:\"created_at\";s:19:\"2020-05-17 13:36:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/faq9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq9-400x226.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:146;a:8:{s:2:\"id\";i:811;s:5:\"title\";s:5:\"FAQ10\";s:10:\"created_at\";s:19:\"2020-05-17 13:38:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/faq10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/faq10-400x267.jpg\";s:4:\"tags\";a:1:{i:0;s:3:\"faq\";}}i:147;a:8:{s:2:\"id\";i:814;s:5:\"title\";s:10:\"Marketing1\";s:10:\"created_at\";s:19:\"2020-05-17 16:42:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing1-400x234.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:148;a:8:{s:2:\"id\";i:826;s:5:\"title\";s:10:\"Marketing2\";s:10:\"created_at\";s:19:\"2020-05-17 16:52:14\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing2-400x235.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:149;a:8:{s:2:\"id\";i:831;s:5:\"title\";s:10:\"Marketing3\";s:10:\"created_at\";s:19:\"2020-05-17 16:53:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing3-400x190.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:150;a:8:{s:2:\"id\";i:835;s:5:\"title\";s:10:\"Marketing4\";s:10:\"created_at\";s:19:\"2020-05-17 16:54:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing4-400x245.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:151;a:8:{s:2:\"id\";i:840;s:5:\"title\";s:10:\"Marketing5\";s:10:\"created_at\";s:19:\"2020-05-17 16:55:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing5-400x209.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"marketing\";i:1;s:5:\"music\";}}i:152;a:8:{s:2:\"id\";i:844;s:5:\"title\";s:10:\"Marketing6\";s:10:\"created_at\";s:19:\"2020-05-17 16:59:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing6-400x233.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:153;a:8:{s:2:\"id\";i:848;s:5:\"title\";s:10:\"Marketing7\";s:10:\"created_at\";s:19:\"2020-05-17 17:00:43\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing7-400x202.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:154;a:8:{s:2:\"id\";i:852;s:5:\"title\";s:10:\"Marketing8\";s:10:\"created_at\";s:19:\"2020-05-17 17:01:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/marketing8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/marketing8-400x299.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"marketing\";}}i:155;a:8:{s:2:\"id\";i:855;s:5:\"title\";s:8:\"Contact1\";s:10:\"created_at\";s:19:\"2020-05-17 17:08:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact1-400x360.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:156;a:8:{s:2:\"id\";i:866;s:5:\"title\";s:8:\"Contact2\";s:10:\"created_at\";s:19:\"2020-05-17 17:20:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact1-400x360.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:157;a:8:{s:2:\"id\";i:870;s:5:\"title\";s:8:\"Contact3\";s:10:\"created_at\";s:19:\"2020-05-17 17:22:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact3-400x224.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:158;a:8:{s:2:\"id\";i:875;s:5:\"title\";s:8:\"Contact4\";s:10:\"created_at\";s:19:\"2020-05-17 17:28:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact4-400x256.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:159;a:8:{s:2:\"id\";i:878;s:5:\"title\";s:8:\"Contact5\";s:10:\"created_at\";s:19:\"2020-05-17 17:30:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact5-400x376.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:160;a:8:{s:2:\"id\";i:884;s:5:\"title\";s:8:\"Contact6\";s:10:\"created_at\";s:19:\"2020-05-17 17:34:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contact6-400x240.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:161;a:8:{s:2:\"id\";i:887;s:5:\"title\";s:6:\"Video1\";s:10:\"created_at\";s:19:\"2020-05-18 15:44:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video1-400x184.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:162;a:8:{s:2:\"id\";i:899;s:5:\"title\";s:6:\"Video2\";s:10:\"created_at\";s:19:\"2020-05-18 15:47:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video2-400x208.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:163;a:8:{s:2:\"id\";i:903;s:5:\"title\";s:6:\"Video3\";s:10:\"created_at\";s:19:\"2020-05-18 15:51:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video3-400x256.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:164;a:8:{s:2:\"id\";i:907;s:5:\"title\";s:6:\"Video4\";s:10:\"created_at\";s:19:\"2020-05-18 15:52:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video4-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:165;a:8:{s:2:\"id\";i:911;s:5:\"title\";s:6:\"Video5\";s:10:\"created_at\";s:19:\"2020-05-18 15:57:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video5-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:166;a:8:{s:2:\"id\";i:915;s:5:\"title\";s:6:\"Video6\";s:10:\"created_at\";s:19:\"2020-05-18 15:59:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video6-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:167;a:8:{s:2:\"id\";i:919;s:5:\"title\";s:6:\"Video7\";s:10:\"created_at\";s:19:\"2020-05-18 16:00:50\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/video7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/video7-400x170.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"video\";}}i:168;a:8:{s:2:\"id\";i:923;s:5:\"title\";s:8:\"Product1\";s:10:\"created_at\";s:19:\"2020-05-18 16:17:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product1-400x190.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:7:\"product\";}}i:169;a:8:{s:2:\"id\";i:940;s:5:\"title\";s:8:\"Product2\";s:10:\"created_at\";s:19:\"2020-05-18 16:21:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product2-1-400x195.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:170;a:8:{s:2:\"id\";i:944;s:5:\"title\";s:8:\"Product3\";s:10:\"created_at\";s:19:\"2020-05-18 17:07:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product3-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:171;a:8:{s:2:\"id\";i:950;s:5:\"title\";s:8:\"Product4\";s:10:\"created_at\";s:19:\"2020-05-18 17:12:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product4-400x188.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:7:\"product\";}}i:172;a:8:{s:2:\"id\";i:955;s:5:\"title\";s:8:\"Product5\";s:10:\"created_at\";s:19:\"2020-05-18 17:15:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product5-400x204.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:173;a:8:{s:2:\"id\";i:959;s:5:\"title\";s:8:\"Product6\";s:10:\"created_at\";s:19:\"2020-05-18 17:17:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product6-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:174;a:8:{s:2:\"id\";i:963;s:5:\"title\";s:8:\"Product7\";s:10:\"created_at\";s:19:\"2020-05-18 17:19:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product7-400x219.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:175;a:8:{s:2:\"id\";i:969;s:5:\"title\";s:8:\"Product8\";s:10:\"created_at\";s:19:\"2020-05-18 17:22:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product8-400x246.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:7:\"product\";}}i:176;a:8:{s:2:\"id\";i:976;s:5:\"title\";s:8:\"Product9\";s:10:\"created_at\";s:19:\"2020-05-18 17:28:13\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/product9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product9-400x243.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:177;a:8:{s:2:\"id\";i:981;s:5:\"title\";s:9:\"Product10\";s:10:\"created_at\";s:19:\"2020-05-18 17:30:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/product9-cloned-976/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product10-400x173.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:178;a:8:{s:2:\"id\";i:987;s:5:\"title\";s:9:\"Product11\";s:10:\"created_at\";s:19:\"2020-05-18 17:39:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/product11-400x219.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:7:\"product\";}}i:179;a:8:{s:2:\"id\";i:991;s:5:\"title\";s:8:\"Gallery1\";s:10:\"created_at\";s:19:\"2020-05-18 19:47:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery1-400x242.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:180;a:8:{s:2:\"id\";i:1006;s:5:\"title\";s:8:\"Gallery2\";s:10:\"created_at\";s:19:\"2020-05-18 20:03:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery2-400x259.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:181;a:8:{s:2:\"id\";i:1025;s:5:\"title\";s:8:\"Gallery3\";s:10:\"created_at\";s:19:\"2020-05-18 20:12:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery3-400x216.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:182;a:8:{s:2:\"id\";i:1030;s:5:\"title\";s:8:\"Gallery4\";s:10:\"created_at\";s:19:\"2020-05-18 20:15:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery4-400x483.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:183;a:8:{s:2:\"id\";i:1046;s:5:\"title\";s:8:\"Gallery5\";s:10:\"created_at\";s:19:\"2020-05-18 20:26:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery5-400x328.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:184;a:8:{s:2:\"id\";i:1065;s:5:\"title\";s:8:\"Gallery6\";s:10:\"created_at\";s:19:\"2020-05-18 20:36:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery6-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:185;a:8:{s:2:\"id\";i:1075;s:5:\"title\";s:8:\"Gallery7\";s:10:\"created_at\";s:19:\"2020-05-18 20:41:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery7-400x318.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:186;a:8:{s:2:\"id\";i:1091;s:5:\"title\";s:8:\"Gallery8\";s:10:\"created_at\";s:19:\"2020-05-18 20:48:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery8-400x443.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:187;a:8:{s:2:\"id\";i:1099;s:5:\"title\";s:8:\"Gallery9\";s:10:\"created_at\";s:19:\"2020-05-19 07:25:25\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gallery9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery9-400x328.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:188;a:8:{s:2:\"id\";i:1115;s:5:\"title\";s:9:\"Gallery10\";s:10:\"created_at\";s:19:\"2020-05-19 08:01:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/gallery10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery10-400x90.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:189;a:8:{s:2:\"id\";i:1130;s:5:\"title\";s:9:\"Gallery11\";s:10:\"created_at\";s:19:\"2020-05-19 08:22:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/gallery11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery11-400x281.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:190;a:8:{s:2:\"id\";i:1135;s:5:\"title\";s:9:\"Gallery12\";s:10:\"created_at\";s:19:\"2020-05-19 08:28:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/gallery12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/gallery12-400x202.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"gallery\";}}i:191;a:8:{s:2:\"id\";i:1142;s:5:\"title\";s:12:\"Coming Soon1\";s:10:\"created_at\";s:19:\"2020-05-19 09:53:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon1-400x206.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:192;a:8:{s:2:\"id\";i:1147;s:5:\"title\";s:12:\"Coming Soon2\";s:10:\"created_at\";s:19:\"2020-05-19 09:57:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon2-400x251.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:193;a:8:{s:2:\"id\";i:1153;s:5:\"title\";s:12:\"Coming Soon3\";s:10:\"created_at\";s:19:\"2020-05-19 09:59:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon3-400x233.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:194;a:8:{s:2:\"id\";i:1163;s:5:\"title\";s:12:\"Coming Soon4\";s:10:\"created_at\";s:19:\"2020-05-19 10:01:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon4-400x175.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:195;a:8:{s:2:\"id\";i:1167;s:5:\"title\";s:12:\"Coming Soon5\";s:10:\"created_at\";s:19:\"2020-05-19 10:03:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon5a-400x198.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:196;a:8:{s:2:\"id\";i:1171;s:5:\"title\";s:12:\"Coming Soon6\";s:10:\"created_at\";s:19:\"2020-05-19 10:04:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon6-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:197;a:8:{s:2:\"id\";i:1175;s:5:\"title\";s:12:\"Coming Soon7\";s:10:\"created_at\";s:19:\"2020-05-19 10:06:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon7-400x258.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:198;a:8:{s:2:\"id\";i:1179;s:5:\"title\";s:12:\"Coming Soon8\";s:10:\"created_at\";s:19:\"2020-05-19 10:07:46\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/comingsoon8a-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:199;a:8:{s:2:\"id\";i:1187;s:5:\"title\";s:7:\"Footer1\";s:10:\"created_at\";s:19:\"2020-05-19 11:30:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/footer1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/footer1-400x111.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"footer\";}}i:200;a:8:{s:2:\"id\";i:1197;s:5:\"title\";s:7:\"Footer2\";s:10:\"created_at\";s:19:\"2020-05-19 11:45:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/footer2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/footer2-400x144.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"footer\";}}i:201;a:8:{s:2:\"id\";i:1201;s:5:\"title\";s:7:\"Footer3\";s:10:\"created_at\";s:19:\"2020-05-19 11:47:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/footer3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/footer3-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"footer\";}}i:202;a:8:{s:2:\"id\";i:1205;s:5:\"title\";s:7:\"Footer4\";s:10:\"created_at\";s:19:\"2020-05-19 11:52:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/footer4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/footer4-400x191.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"footer\";}}i:203;a:8:{s:2:\"id\";i:1208;s:5:\"title\";s:7:\"Footer5\";s:10:\"created_at\";s:19:\"2020-05-19 11:53:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/footer5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/footer5-400x123.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"footer\";}}i:204;a:8:{s:2:\"id\";i:1211;s:5:\"title\";s:11:\"restaurant1\";s:10:\"created_at\";s:19:\"2020-05-19 12:18:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/RestaurantMenu1-400x178.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:205;a:8:{s:2:\"id\";i:1230;s:5:\"title\";s:11:\"restaurant2\";s:10:\"created_at\";s:19:\"2020-05-19 12:23:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu2-400x269.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:206;a:8:{s:2:\"id\";i:1239;s:5:\"title\";s:11:\"restaurant3\";s:10:\"created_at\";s:19:\"2020-05-19 12:28:49\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu3-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:207;a:8:{s:2:\"id\";i:1242;s:5:\"title\";s:11:\"restaurant4\";s:10:\"created_at\";s:19:\"2020-05-19 12:29:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu4-400x261.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:208;a:8:{s:2:\"id\";i:1248;s:5:\"title\";s:11:\"restaurant5\";s:10:\"created_at\";s:19:\"2020-05-19 12:30:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu5-400x159.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:209;a:8:{s:2:\"id\";i:1252;s:5:\"title\";s:11:\"restaurant6\";s:10:\"created_at\";s:19:\"2020-05-19 13:33:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu6-400x182.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:210;a:8:{s:2:\"id\";i:1259;s:5:\"title\";s:11:\"restaurant7\";s:10:\"created_at\";s:19:\"2020-05-19 13:36:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu7-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:211;a:8:{s:2:\"id\";i:1262;s:5:\"title\";s:11:\"restaurant8\";s:10:\"created_at\";s:19:\"2020-05-19 13:37:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu8-400x201.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:212;a:8:{s:2:\"id\";i:1266;s:5:\"title\";s:11:\"restaurant9\";s:10:\"created_at\";s:19:\"2020-05-19 16:24:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/restaurant9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu9-400x146.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:213;a:8:{s:2:\"id\";i:1270;s:5:\"title\";s:12:\"restaurant10\";s:10:\"created_at\";s:19:\"2020-05-19 16:28:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu10-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:214;a:8:{s:2:\"id\";i:1273;s:5:\"title\";s:12:\"restaurant11\";s:10:\"created_at\";s:19:\"2020-05-19 16:30:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu11-400x256.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:215;a:8:{s:2:\"id\";i:1280;s:5:\"title\";s:12:\"restaurant12\";s:10:\"created_at\";s:19:\"2020-05-19 16:43:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu12-400x246.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:216;a:8:{s:2:\"id\";i:1284;s:5:\"title\";s:12:\"restaurant13\";s:10:\"created_at\";s:19:\"2020-05-19 16:54:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu13-400x258.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:217;a:8:{s:2:\"id\";i:1288;s:5:\"title\";s:12:\"restaurant14\";s:10:\"created_at\";s:19:\"2020-05-19 17:20:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu14-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:218;a:8:{s:2:\"id\";i:1293;s:5:\"title\";s:12:\"restaurant15\";s:10:\"created_at\";s:19:\"2020-05-19 17:24:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant15/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/menu15-400x188.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"restaurant\";}}i:219;a:8:{s:2:\"id\";i:1320;s:5:\"title\";s:6:\"Sales1\";s:10:\"created_at\";s:19:\"2020-05-20 11:08:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sales1-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:220;a:8:{s:2:\"id\";i:1330;s:5:\"title\";s:6:\"Sales2\";s:10:\"created_at\";s:19:\"2020-05-20 15:29:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale2-400x166.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:221;a:8:{s:2:\"id\";i:1339;s:5:\"title\";s:6:\"Sales3\";s:10:\"created_at\";s:19:\"2020-05-20 15:47:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale3-400x369.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:222;a:8:{s:2:\"id\";i:1347;s:5:\"title\";s:6:\"Sales4\";s:10:\"created_at\";s:19:\"2020-05-20 16:39:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale4-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:223;a:8:{s:2:\"id\";i:1354;s:5:\"title\";s:6:\"Sales5\";s:10:\"created_at\";s:19:\"2020-05-20 18:16:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale5-400x232.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:5:\"sales\";}}i:224;a:8:{s:2:\"id\";i:1376;s:5:\"title\";s:6:\"Sales7\";s:10:\"created_at\";s:19:\"2020-05-20 20:04:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale7-400x190.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:225;a:8:{s:2:\"id\";i:1386;s:5:\"title\";s:6:\"Sales8\";s:10:\"created_at\";s:19:\"2020-05-21 10:35:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/sales8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sale8-400x215.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:226;a:8:{s:2:\"id\";i:1412;s:5:\"title\";s:7:\"Sales10\";s:10:\"created_at\";s:19:\"2020-05-21 17:20:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/sales10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/sales10-400x200.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"sales\";}}i:227;a:8:{s:2:\"id\";i:1429;s:5:\"title\";s:8:\"Medical1\";s:10:\"created_at\";s:19:\"2020-05-21 19:28:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical1-400x198.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:228;a:8:{s:2:\"id\";i:1434;s:5:\"title\";s:8:\"Medical2\";s:10:\"created_at\";s:19:\"2020-05-21 19:34:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical2a-400x212.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:229;a:8:{s:2:\"id\";i:1441;s:5:\"title\";s:8:\"Medical3\";s:10:\"created_at\";s:19:\"2020-05-21 20:03:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical3-400x198.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:230;a:8:{s:2:\"id\";i:1451;s:5:\"title\";s:8:\"Medical4\";s:10:\"created_at\";s:19:\"2020-05-21 20:40:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical4-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:231;a:8:{s:2:\"id\";i:1458;s:5:\"title\";s:8:\"Medical5\";s:10:\"created_at\";s:19:\"2020-05-22 07:58:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical5-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:232;a:8:{s:2:\"id\";i:1472;s:5:\"title\";s:11:\"Fun Factor7\";s:10:\"created_at\";s:19:\"2020-05-22 08:43:43\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/fun-factor7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/funfactor7-400x192.jpg\";s:4:\"tags\";a:2:{i:0;s:10:\"fun-factor\";i:1;s:14:\"medical-health\";}}i:233;a:8:{s:2:\"id\";i:1479;s:5:\"title\";s:8:\"Medical6\";s:10:\"created_at\";s:19:\"2020-05-22 08:53:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical6-400x192.jpg\";s:4:\"tags\";a:3:{i:0;s:13:\"content-block\";i:1;s:11:\"image-block\";i:2;s:14:\"medical-health\";}}i:234;a:8:{s:2:\"id\";i:1485;s:5:\"title\";s:8:\"Medical7\";s:10:\"created_at\";s:19:\"2020-05-22 09:03:00\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical7-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"content-block\";i:1;s:14:\"medical-health\";}}i:235;a:8:{s:2:\"id\";i:1490;s:5:\"title\";s:8:\"Medical8\";s:10:\"created_at\";s:19:\"2020-05-22 10:40:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical8-400x213.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:236;a:8:{s:2:\"id\";i:1498;s:5:\"title\";s:8:\"Medical9\";s:10:\"created_at\";s:19:\"2020-05-22 11:22:23\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/medical9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical9-400x213.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"content-block\";i:1;s:14:\"medical-health\";}}i:237;a:8:{s:2:\"id\";i:1512;s:5:\"title\";s:9:\"Medical10\";s:10:\"created_at\";s:19:\"2020-05-22 12:05:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical9-400x213.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:238;a:8:{s:2:\"id\";i:1528;s:5:\"title\";s:9:\"Medical11\";s:10:\"created_at\";s:19:\"2020-05-22 18:30:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical11-400x212.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:239;a:8:{s:2:\"id\";i:1536;s:5:\"title\";s:9:\"Medical12\";s:10:\"created_at\";s:19:\"2020-05-22 19:59:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical12-400x212.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:14:\"medical-health\";}}i:240;a:8:{s:2:\"id\";i:1571;s:5:\"title\";s:9:\"Medical13\";s:10:\"created_at\";s:19:\"2020-05-23 16:12:13\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical13/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical13-400x231.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:14:\"medical-health\";}}i:241;a:8:{s:2:\"id\";i:1580;s:5:\"title\";s:9:\"Medical14\";s:10:\"created_at\";s:19:\"2020-05-23 16:28:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical14-400x213.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:14:\"medical-health\";}}i:242;a:8:{s:2:\"id\";i:1589;s:5:\"title\";s:9:\"Medical15\";s:10:\"created_at\";s:19:\"2020-05-23 16:42:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical15/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical15-400x194.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:14:\"medical-health\";}}i:243;a:8:{s:2:\"id\";i:1599;s:5:\"title\";s:9:\"Medical16\";s:10:\"created_at\";s:19:\"2020-05-23 18:36:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical16-400x195.jpg\";s:4:\"tags\";a:2:{i:0;s:10:\"fun-factor\";i:1;s:14:\"medical-health\";}}i:244;a:8:{s:2:\"id\";i:1606;s:5:\"title\";s:9:\"Medical17\";s:10:\"created_at\";s:19:\"2020-05-23 18:57:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical17/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical17-400x187.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:14:\"medical-health\";}}i:245;a:8:{s:2:\"id\";i:1614;s:5:\"title\";s:9:\"Medical18\";s:10:\"created_at\";s:19:\"2020-05-23 19:11:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical18/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical18-400x216.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"feature\";i:1;s:14:\"medical-health\";}}i:246;a:8:{s:2:\"id\";i:1626;s:5:\"title\";s:9:\"Medical19\";s:10:\"created_at\";s:19:\"2020-05-23 19:32:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical19/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical19-400x228.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:14:\"medical-health\";}}i:247;a:8:{s:2:\"id\";i:1647;s:5:\"title\";s:9:\"Medical20\";s:10:\"created_at\";s:19:\"2020-05-23 20:24:14\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/medical20/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/medical20-400x223.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:14:\"medical-health\";}}i:248;a:8:{s:2:\"id\";i:1678;s:5:\"title\";s:12:\"Testimonial1\";s:10:\"created_at\";s:19:\"2020-05-26 05:08:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial1-400x181.png\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:249;a:8:{s:2:\"id\";i:1685;s:5:\"title\";s:12:\"Testimonial2\";s:10:\"created_at\";s:19:\"2020-05-26 05:14:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial2-400x185.png\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:250;a:8:{s:2:\"id\";i:1693;s:5:\"title\";s:12:\"Testimonial3\";s:10:\"created_at\";s:19:\"2020-05-26 06:38:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial3-400x185.png\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:251;a:8:{s:2:\"id\";i:1698;s:5:\"title\";s:12:\"Testimonial4\";s:10:\"created_at\";s:19:\"2020-05-26 07:21:10\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial4-400x185.png\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:252;a:8:{s:2:\"id\";i:1706;s:5:\"title\";s:12:\"Testimonial5\";s:10:\"created_at\";s:19:\"2020-05-26 16:47:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial5-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:253;a:8:{s:2:\"id\";i:1718;s:5:\"title\";s:12:\"Testimonial6\";s:10:\"created_at\";s:19:\"2020-05-28 07:17:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial5-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:254;a:8:{s:2:\"id\";i:1727;s:5:\"title\";s:12:\"Testimonial7\";s:10:\"created_at\";s:19:\"2020-05-28 08:05:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial7-400x199.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:255;a:8:{s:2:\"id\";i:1736;s:5:\"title\";s:12:\"Testimonial8\";s:10:\"created_at\";s:19:\"2020-05-28 09:25:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial8-400x199.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:256;a:8:{s:2:\"id\";i:1744;s:5:\"title\";s:12:\"Testimonial9\";s:10:\"created_at\";s:19:\"2020-05-28 09:41:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/testimonial9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial9-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:257;a:8:{s:2:\"id\";i:1750;s:5:\"title\";s:13:\"Testimonial10\";s:10:\"created_at\";s:19:\"2020-05-28 09:50:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial10-400x191.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:258;a:8:{s:2:\"id\";i:1755;s:5:\"title\";s:13:\"Testimonial11\";s:10:\"created_at\";s:19:\"2020-05-28 10:01:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial11-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:259;a:8:{s:2:\"id\";i:1760;s:5:\"title\";s:13:\"Testimonial12\";s:10:\"created_at\";s:19:\"2020-05-28 10:13:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial12-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"music\";i:1;s:11:\"testimonial\";}}i:260;a:8:{s:2:\"id\";i:1765;s:5:\"title\";s:12:\"ImageBlock13\";s:10:\"created_at\";s:19:\"2020-05-28 10:43:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock13-400x155.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:261;a:8:{s:2:\"id\";i:1770;s:5:\"title\";s:12:\"ImageBlock14\";s:10:\"created_at\";s:19:\"2020-05-28 10:46:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock14-400x189.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:262;a:8:{s:2:\"id\";i:1776;s:5:\"title\";s:12:\"ImageBlock15\";s:10:\"created_at\";s:19:\"2020-05-28 10:50:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock15-400x190.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:263;a:8:{s:2:\"id\";i:1777;s:5:\"title\";s:12:\"ImageBlock16\";s:10:\"created_at\";s:19:\"2020-05-28 10:55:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock16-400x236.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:264;a:8:{s:2:\"id\";i:1786;s:5:\"title\";s:11:\"Intro Text9\";s:10:\"created_at\";s:19:\"2020-05-28 11:31:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/intro-text9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext9-400x160.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:265;a:8:{s:2:\"id\";i:1790;s:5:\"title\";s:12:\"Intro Text10\";s:10:\"created_at\";s:19:\"2020-05-28 11:34:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext10-400x160.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:266;a:8:{s:2:\"id\";i:1796;s:5:\"title\";s:15:\"Content Block13\";s:10:\"created_at\";s:19:\"2020-05-28 11:57:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock13-400x186.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"business-hour\";i:1;s:13:\"content-block\";}}i:267;a:8:{s:2:\"id\";i:1801;s:5:\"title\";s:15:\"Content Block14\";s:10:\"created_at\";s:19:\"2020-05-28 12:38:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content15-400x149.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"business-hour\";i:1;s:13:\"content-block\";}}i:268;a:8:{s:2:\"id\";i:1811;s:5:\"title\";s:15:\"Content Block15\";s:10:\"created_at\";s:19:\"2020-05-28 12:48:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/content16-400x174.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"business-hour\";i:1;s:13:\"content-block\";}}i:269;a:8:{s:2:\"id\";i:1815;s:5:\"title\";s:12:\"ImageBlock17\";s:10:\"created_at\";s:19:\"2020-05-28 13:52:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock17/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock17-400x174.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:270;a:8:{s:2:\"id\";i:1820;s:5:\"title\";s:12:\"ImageBlock18\";s:10:\"created_at\";s:19:\"2020-05-28 13:58:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock18/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock18-400x174.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:271;a:8:{s:2:\"id\";i:1825;s:5:\"title\";s:12:\"ImageBlock19\";s:10:\"created_at\";s:19:\"2020-05-28 14:05:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock19/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock19-400x174.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:272;a:8:{s:2:\"id\";i:1833;s:5:\"title\";s:12:\"ImageBlock21\";s:10:\"created_at\";s:19:\"2020-05-28 16:50:35\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock21/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock21-400x210.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:273;a:8:{s:2:\"id\";i:1834;s:5:\"title\";s:12:\"ImageBlock20\";s:10:\"created_at\";s:19:\"2020-05-28 16:33:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock20/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock20-400x178.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:274;a:8:{s:2:\"id\";i:1849;s:5:\"title\";s:12:\"ImageBlock22\";s:10:\"created_at\";s:19:\"2020-05-28 17:12:00\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock22/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock22-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:275;a:8:{s:2:\"id\";i:1857;s:5:\"title\";s:12:\"ImageBlock23\";s:10:\"created_at\";s:19:\"2020-05-28 17:43:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock23/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock23-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:276;a:8:{s:2:\"id\";i:1868;s:5:\"title\";s:6:\"Team17\";s:10:\"created_at\";s:19:\"2020-05-28 18:18:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock24/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team17-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:277;a:8:{s:2:\"id\";i:1881;s:5:\"title\";s:8:\"Feature8\";s:10:\"created_at\";s:19:\"2020-05-28 19:47:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature8-400x182.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:278;a:8:{s:2:\"id\";i:1891;s:5:\"title\";s:8:\"Feature9\";s:10:\"created_at\";s:19:\"2020-05-29 06:05:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/feature9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature9-400x209.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:279;a:8:{s:2:\"id\";i:1901;s:5:\"title\";s:9:\"Feature10\";s:10:\"created_at\";s:19:\"2020-05-29 06:21:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature10-400x139.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:280;a:8:{s:2:\"id\";i:1905;s:5:\"title\";s:12:\"ImageBlock24\";s:10:\"created_at\";s:19:\"2020-05-29 06:27:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/imageblock24-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock24-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:281;a:8:{s:2:\"id\";i:1912;s:5:\"title\";s:12:\"ImageBlock25\";s:10:\"created_at\";s:19:\"2020-05-29 06:34:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock25/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock25-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:282;a:8:{s:2:\"id\";i:1919;s:5:\"title\";s:12:\"ImageBlock26\";s:10:\"created_at\";s:19:\"2020-05-29 06:40:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock26/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock26-400x196.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:283;a:8:{s:2:\"id\";i:1925;s:5:\"title\";s:12:\"ImageBlock27\";s:10:\"created_at\";s:19:\"2020-05-29 06:45:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock27/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock27-400x212.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:284;a:8:{s:2:\"id\";i:1935;s:5:\"title\";s:9:\"Feature11\";s:10:\"created_at\";s:19:\"2020-05-29 10:20:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature11-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:285;a:8:{s:2:\"id\";i:1945;s:5:\"title\";s:9:\"Feature12\";s:10:\"created_at\";s:19:\"2020-05-29 10:56:37\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature12-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:286;a:8:{s:2:\"id\";i:1951;s:5:\"title\";s:9:\"Feature13\";s:10:\"created_at\";s:19:\"2020-05-29 11:01:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature13/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature13-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:287;a:8:{s:2:\"id\";i:1959;s:5:\"title\";s:9:\"Feature14\";s:10:\"created_at\";s:19:\"2020-05-29 11:08:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature14/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature14-400x154.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:288;a:8:{s:2:\"id\";i:1964;s:5:\"title\";s:9:\"Feature15\";s:10:\"created_at\";s:19:\"2020-05-29 11:11:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature15-400x154.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:289;a:8:{s:2:\"id\";i:1968;s:5:\"title\";s:9:\"Feature16\";s:10:\"created_at\";s:19:\"2020-05-29 11:14:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature16-400x154.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:290;a:8:{s:2:\"id\";i:1974;s:5:\"title\";s:8:\"Pricing1\";s:10:\"created_at\";s:19:\"2020-05-29 11:28:32\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing1-400x215.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:291;a:8:{s:2:\"id\";i:1980;s:5:\"title\";s:8:\"Pricing2\";s:10:\"created_at\";s:19:\"2020-05-29 11:32:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing2-400x184.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:292;a:8:{s:2:\"id\";i:1985;s:5:\"title\";s:8:\"Pricing3\";s:10:\"created_at\";s:19:\"2020-05-29 11:35:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing3-400x184.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:293;a:8:{s:2:\"id\";i:1995;s:5:\"title\";s:8:\"Pricing4\";s:10:\"created_at\";s:19:\"2020-05-29 12:28:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing4-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:294;a:8:{s:2:\"id\";i:2000;s:5:\"title\";s:8:\"Pricing5\";s:10:\"created_at\";s:19:\"2020-05-29 12:48:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing5-400x201.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:295;a:8:{s:2:\"id\";i:2005;s:5:\"title\";s:8:\"Pricing6\";s:10:\"created_at\";s:19:\"2020-05-29 13:29:07\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/pricing6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/pricing6-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"price-menu\";}}i:296;a:8:{s:2:\"id\";i:2012;s:5:\"title\";s:15:\"Content Block16\";s:10:\"created_at\";s:19:\"2020-05-29 14:54:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock16-400x238.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:13:\"content-block\";}}i:297;a:8:{s:2:\"id\";i:2018;s:5:\"title\";s:15:\"Content Block17\";s:10:\"created_at\";s:19:\"2020-05-29 15:32:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block17/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock17-400x200.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:13:\"content-block\";}}i:298;a:8:{s:2:\"id\";i:2025;s:5:\"title\";s:15:\"Content Block18\";s:10:\"created_at\";s:19:\"2020-05-29 15:50:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block18/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock18-400x208.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:13:\"content-block\";}}i:299;a:8:{s:2:\"id\";i:2031;s:5:\"title\";s:15:\"Content Block19\";s:10:\"created_at\";s:19:\"2020-05-29 16:01:07\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block19/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock19-400x222.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:13:\"content-block\";}}i:300;a:8:{s:2:\"id\";i:2038;s:5:\"title\";s:15:\"Content Block20\";s:10:\"created_at\";s:19:\"2020-05-29 17:01:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block20/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock20-400x193.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"client\";i:1;s:13:\"content-block\";}}i:301;a:8:{s:2:\"id\";i:2052;s:5:\"title\";s:15:\"Content Block21\";s:10:\"created_at\";s:19:\"2020-05-29 17:08:35\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block21/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock21-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"client\";i:1;s:13:\"content-block\";}}i:302;a:8:{s:2:\"id\";i:2062;s:5:\"title\";s:15:\"Content Block22\";s:10:\"created_at\";s:19:\"2020-05-29 17:11:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block22/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock22-400x177.jpg\";s:4:\"tags\";a:4:{i:0;s:6:\"client\";i:1;s:13:\"content-block\";i:2;s:7:\"feature\";i:3;s:7:\"service\";}}i:303;a:8:{s:2:\"id\";i:2066;s:5:\"title\";s:15:\"Content Block23\";s:10:\"created_at\";s:19:\"2020-05-29 17:21:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block23/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock23-400x220.jpg\";s:4:\"tags\";a:5:{i:0;s:13:\"content-block\";i:1;s:7:\"feature\";i:2;s:7:\"gallery\";i:3;s:11:\"image-block\";i:4;s:7:\"product\";}}i:304;a:8:{s:2:\"id\";i:2082;s:5:\"title\";s:13:\"Testimonial13\";s:10:\"created_at\";s:19:\"2020-05-29 17:34:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial13-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:305;a:8:{s:2:\"id\";i:2090;s:5:\"title\";s:13:\"Testimonial14\";s:10:\"created_at\";s:19:\"2020-05-29 18:11:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial14-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:306;a:8:{s:2:\"id\";i:2098;s:5:\"title\";s:13:\"Testimonial15\";s:10:\"created_at\";s:19:\"2020-05-29 18:17:16\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial15/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial15-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:307;a:8:{s:2:\"id\";i:2102;s:5:\"title\";s:13:\"Testimonial16\";s:10:\"created_at\";s:19:\"2020-05-29 19:02:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial16-400x192.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:308;a:8:{s:2:\"id\";i:2107;s:5:\"title\";s:13:\"Testimonial17\";s:10:\"created_at\";s:19:\"2020-05-29 19:05:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial17/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial17-400x173.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:309;a:8:{s:2:\"id\";i:2112;s:5:\"title\";s:13:\"Testimonial18\";s:10:\"created_at\";s:19:\"2020-05-29 19:10:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial18/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial18-400x186.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:310;a:8:{s:2:\"id\";i:2117;s:5:\"title\";s:13:\"Testimonial19\";s:10:\"created_at\";s:19:\"2020-05-29 19:15:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial19/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial19-400x195.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:311;a:8:{s:2:\"id\";i:2125;s:5:\"title\";s:13:\"Testimonial20\";s:10:\"created_at\";s:19:\"2020-05-29 19:20:48\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial20/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial20-400x187.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:312;a:8:{s:2:\"id\";i:2130;s:5:\"title\";s:13:\"Testimonial21\";s:10:\"created_at\";s:19:\"2020-05-29 20:06:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial21/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial21-400x189.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:313;a:8:{s:2:\"id\";i:2136;s:5:\"title\";s:13:\"Testimonial22\";s:10:\"created_at\";s:19:\"2020-05-29 20:13:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial22/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/testimonial22-400x134.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:314;a:8:{s:2:\"id\";i:2141;s:5:\"title\";s:12:\"ImageBlock28\";s:10:\"created_at\";s:19:\"2020-05-30 04:14:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock28/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock28-400x210.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:315;a:8:{s:2:\"id\";i:2147;s:5:\"title\";s:15:\"Content Block24\";s:10:\"created_at\";s:19:\"2020-05-30 05:01:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block24/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock24-400x177.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:316;a:8:{s:2:\"id\";i:2153;s:5:\"title\";s:15:\"Content Block25\";s:10:\"created_at\";s:19:\"2020-05-30 05:12:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block25/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock25-400x177.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:317;a:8:{s:2:\"id\";i:2159;s:5:\"title\";s:15:\"Content Block26\";s:10:\"created_at\";s:19:\"2020-05-30 05:26:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block26/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/contentblock26-400x177.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:318;a:8:{s:2:\"id\";i:2164;s:5:\"title\";s:12:\"ImageBlock29\";s:10:\"created_at\";s:19:\"2020-05-30 05:35:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock29/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock29-400x201.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:319;a:8:{s:2:\"id\";i:2174;s:5:\"title\";s:6:\"Team18\";s:10:\"created_at\";s:19:\"2020-05-30 06:13:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team18/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/team18-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:320;a:8:{s:2:\"id\";i:2241;s:5:\"title\";s:12:\"Intro Text11\";s:10:\"created_at\";s:19:\"2020-05-30 19:47:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text11/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/introtext9-400x160.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:321;a:8:{s:2:\"id\";i:2251;s:5:\"title\";s:12:\"Intro Text12\";s:10:\"created_at\";s:19:\"2020-05-30 20:12:56\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/intro13-400x223.jpg\";s:4:\"tags\";a:2:{i:0;s:10:\"intro-text\";i:1;s:5:\"music\";}}i:322;a:8:{s:2:\"id\";i:2277;s:5:\"title\";s:9:\"Feature17\";s:10:\"created_at\";s:19:\"2020-05-31 06:27:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature17/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/feature17-400x231.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:323;a:8:{s:2:\"id\";i:2340;s:5:\"title\";s:12:\"Intro Text13\";s:10:\"created_at\";s:19:\"2020-05-31 10:54:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text13/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/intro14-400x215.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:324;a:8:{s:2:\"id\";i:2358;s:5:\"title\";s:12:\"ImageBlock30\";s:10:\"created_at\";s:19:\"2020-05-31 16:30:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock30/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock30-400x237.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:325;a:8:{s:2:\"id\";i:2369;s:5:\"title\";s:12:\"ImageBlock31\";s:10:\"created_at\";s:19:\"2020-05-31 16:56:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock31/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock31-400x237.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:326;a:8:{s:2:\"id\";i:2378;s:5:\"title\";s:12:\"ImageBlock32\";s:10:\"created_at\";s:19:\"2020-05-31 17:18:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock32/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/imageblock32-400x237.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:327;a:8:{s:2:\"id\";i:2386;s:5:\"title\";s:12:\"Intro Text14\";s:10:\"created_at\";s:19:\"2020-05-31 17:49:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text14/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/05/intro14a-400x194.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:328;a:8:{s:2:\"id\";i:2403;s:5:\"title\";s:12:\"Intro Text15\";s:10:\"created_at\";s:19:\"2020-06-01 08:25:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/intro-text15/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/intro16-400x157.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:329;a:8:{s:2:\"id\";i:2489;s:5:\"title\";s:12:\"ImageBlock33\";s:10:\"created_at\";s:19:\"2020-06-02 05:07:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock33/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock33-400x226.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:330;a:8:{s:2:\"id\";i:2502;s:5:\"title\";s:12:\"ImageBlock34\";s:10:\"created_at\";s:19:\"2020-06-02 09:17:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock34/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock34a-400x178.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:331;a:8:{s:2:\"id\";i:2517;s:5:\"title\";s:12:\"ImageBlock35\";s:10:\"created_at\";s:19:\"2020-06-02 16:52:02\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock35/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock35-400x151.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:332;a:8:{s:2:\"id\";i:2625;s:5:\"title\";s:12:\"ImageBlock37\";s:10:\"created_at\";s:19:\"2020-06-04 14:02:28\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock37/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock37-400x110.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:333;a:8:{s:2:\"id\";i:2630;s:5:\"title\";s:12:\"ImageBlock38\";s:10:\"created_at\";s:19:\"2020-06-04 14:30:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock38/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock38a-400x167.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:334;a:8:{s:2:\"id\";i:2669;s:5:\"title\";s:9:\"Feature19\";s:10:\"created_at\";s:19:\"2020-06-07 13:32:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature19/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature19-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:335;a:8:{s:2:\"id\";i:2681;s:5:\"title\";s:8:\"Contact7\";s:10:\"created_at\";s:19:\"2020-06-07 18:38:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature19-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:336;a:8:{s:2:\"id\";i:2711;s:5:\"title\";s:8:\"Contact8\";s:10:\"created_at\";s:19:\"2020-06-08 08:10:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/contact8-400x82.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:337;a:8:{s:2:\"id\";i:2738;s:5:\"title\";s:13:\"Image Block40\";s:10:\"created_at\";s:19:\"2020-06-09 15:40:54\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/imageblock40/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock40-400x188.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"banner\";i:1;s:13:\"content-block\";i:2;s:11:\"image-block\";}}i:338;a:8:{s:2:\"id\";i:2766;s:5:\"title\";s:6:\"Team19\";s:10:\"created_at\";s:19:\"2020-06-11 08:33:52\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/team19/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/team19-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:339;a:8:{s:2:\"id\";i:2776;s:5:\"title\";s:9:\"Feature20\";s:10:\"created_at\";s:19:\"2020-06-11 12:28:43\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature20/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature20-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:340;a:8:{s:2:\"id\";i:2786;s:5:\"title\";s:9:\"Feature21\";s:10:\"created_at\";s:19:\"2020-06-11 19:24:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature21/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature21-400x172.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:341;a:8:{s:2:\"id\";i:2800;s:5:\"title\";s:9:\"Feature22\";s:10:\"created_at\";s:19:\"2020-06-13 05:55:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature22/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/feature22-400x227.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:342;a:8:{s:2:\"id\";i:2818;s:5:\"title\";s:11:\"Imageblog41\";s:10:\"created_at\";s:19:\"2020-06-14 04:49:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/elementor-2818/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/imageblock41-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:343;a:8:{s:2:\"id\";i:2844;s:5:\"title\";s:8:\"Contact9\";s:10:\"created_at\";s:19:\"2020-06-19 11:42:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/contact9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/06/contact9-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:344;a:8:{s:2:\"id\";i:2878;s:5:\"title\";s:16:\"Pricing Table -1\";s:10:\"created_at\";s:19:\"2020-07-09 07:05:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-1-400x184.jpg\";s:4:\"tags\";a:0:{}}i:345;a:8:{s:2:\"id\";i:2882;s:5:\"title\";s:15:\"Pricing Table-2\";s:10:\"created_at\";s:19:\"2020-07-09 07:10:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-2-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:346;a:8:{s:2:\"id\";i:2885;s:5:\"title\";s:15:\"Pricing Table-3\";s:10:\"created_at\";s:19:\"2020-07-09 07:11:39\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-3-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:347;a:8:{s:2:\"id\";i:2888;s:5:\"title\";s:15:\"Pricing Table-4\";s:10:\"created_at\";s:19:\"2020-07-09 07:13:00\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-4-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:348;a:8:{s:2:\"id\";i:2893;s:5:\"title\";s:15:\"Pricing Table-5\";s:10:\"created_at\";s:19:\"2020-07-09 07:14:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-5-400x216.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:349;a:8:{s:2:\"id\";i:2899;s:5:\"title\";s:15:\"Pricing Table-6\";s:10:\"created_at\";s:19:\"2020-07-09 07:16:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-6-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:350;a:8:{s:2:\"id\";i:2904;s:5:\"title\";s:15:\"Pricing Table-7\";s:10:\"created_at\";s:19:\"2020-07-09 07:17:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-7-400x218.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:351;a:8:{s:2:\"id\";i:2907;s:5:\"title\";s:15:\"Pricing Table-8\";s:10:\"created_at\";s:19:\"2020-07-09 07:19:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-8/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-8-400x218.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:352;a:8:{s:2:\"id\";i:2913;s:5:\"title\";s:15:\"Pricing Table-9\";s:10:\"created_at\";s:19:\"2020-07-09 07:22:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/pricing-table-9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-9-400x198.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:353;a:8:{s:2:\"id\";i:2916;s:5:\"title\";s:16:\"Pricing Table-10\";s:10:\"created_at\";s:19:\"2020-07-09 07:24:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/pricing-table-10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-10-400x209.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:354;a:8:{s:2:\"id\";i:2921;s:5:\"title\";s:16:\"Pricing Table-11\";s:10:\"created_at\";s:19:\"2020-07-09 07:30:04\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/pricing-table-11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/pt-11-400x200.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:355;a:8:{s:2:\"id\";i:2941;s:5:\"title\";s:11:\"404 Error-1\";s:10:\"created_at\";s:19:\"2020-07-10 09:18:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/404-error-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/E-1-400x204.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"error-404\";}}i:356;a:8:{s:2:\"id\";i:2950;s:5:\"title\";s:11:\"404 Error-2\";s:10:\"created_at\";s:19:\"2020-07-10 09:22:13\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/404-error-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/E-2-400x199.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"error-404\";}}i:357;a:8:{s:2:\"id\";i:2954;s:5:\"title\";s:11:\"404 Error-3\";s:10:\"created_at\";s:19:\"2020-07-10 09:23:55\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/404-error-3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/E-3-400x181.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"error-404\";}}i:358;a:8:{s:2:\"id\";i:2957;s:5:\"title\";s:11:\"404 Error-4\";s:10:\"created_at\";s:19:\"2020-07-10 09:26:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/404-error-4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/E-4-400x232.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"error-404\";}}i:359;a:8:{s:2:\"id\";i:2961;s:5:\"title\";s:11:\"404 Error-5\";s:10:\"created_at\";s:19:\"2020-07-10 09:27:29\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/404-error-5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:76:\"https://templates.happyaddons.com/wp-content/uploads/2020/07/E-5-400x214.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"error-404\";}}i:360;a:8:{s:2:\"id\";i:2984;s:5:\"title\";s:14:\"Landing Page 1\";s:10:\"created_at\";s:19:\"2020-10-19 08:04:11\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/landing-page-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/landing1-1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:12:\"landing-page\";}}i:361;a:8:{s:2:\"id\";i:3011;s:5:\"title\";s:6:\"Agency\";s:10:\"created_at\";s:19:\"2020-10-19 11:18:54\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:50:\"https://templates.happyaddons.com/template/agency/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/agency1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:362;a:8:{s:2:\"id\";i:3037;s:5:\"title\";s:8:\"GameSite\";s:10:\"created_at\";s:19:\"2020-10-19 11:42:54\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/gamesite/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/game-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:363;a:8:{s:2:\"id\";i:3074;s:5:\"title\";s:17:\"Halloween Banner1\";s:10:\"created_at\";s:19:\"2020-10-21 09:32:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner1-400x220.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:364;a:8:{s:2:\"id\";i:3084;s:5:\"title\";s:17:\"Halloween banner2\";s:10:\"created_at\";s:19:\"2020-10-21 09:37:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner2-400x220.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:365;a:8:{s:2:\"id\";i:3089;s:5:\"title\";s:17:\"Halloween Banner3\";s:10:\"created_at\";s:19:\"2020-10-21 09:40:07\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner3-400x220.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:366;a:8:{s:2:\"id\";i:3096;s:5:\"title\";s:17:\"Halloween Banner4\";s:10:\"created_at\";s:19:\"2020-10-21 09:47:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner4-400x220.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:367;a:8:{s:2:\"id\";i:3101;s:5:\"title\";s:16:\"Halloween About1\";s:10:\"created_at\";s:19:\"2020-10-21 09:50:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/halloween-about1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-about2-400x209.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:9:\"halloween\";}}i:368;a:8:{s:2:\"id\";i:3108;s:5:\"title\";s:16:\"Halloween About2\";s:10:\"created_at\";s:19:\"2020-10-21 09:55:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/halloween-about2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-about1-400x193.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:9:\"halloween\";}}i:369;a:8:{s:2:\"id\";i:3114;s:5:\"title\";s:18:\"Halloween Pricing1\";s:10:\"created_at\";s:19:\"2020-10-21 09:57:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/halloween-pricing1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-pricing1-400x295.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"halloween\";i:1;s:13:\"pricing-table\";}}i:370;a:8:{s:2:\"id\";i:3123;s:5:\"title\";s:18:\"Halloween Pricing2\";s:10:\"created_at\";s:19:\"2020-10-21 11:53:16\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/halloween-pricing2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-pricing2-400x212.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"halloween\";i:1;s:13:\"pricing-table\";}}i:371;a:8:{s:2:\"id\";i:3147;s:5:\"title\";s:15:\"Halloween Team1\";s:10:\"created_at\";s:19:\"2020-10-21 11:58:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/halloween-team1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-team1a-400x222.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"halloween\";i:1;s:4:\"team\";}}i:372;a:8:{s:2:\"id\";i:3159;s:5:\"title\";s:17:\"Halloween Banner5\";s:10:\"created_at\";s:19:\"2020-10-21 12:21:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/3159/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner5-400x222.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:373;a:8:{s:2:\"id\";i:3166;s:5:\"title\";s:16:\"Halloween About3\";s:10:\"created_at\";s:19:\"2020-10-21 12:31:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/halloween-about3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-about3-400x194.jpg\";s:4:\"tags\";a:2:{i:0;s:5:\"about\";i:1;s:9:\"halloween\";}}i:374;a:8:{s:2:\"id\";i:3181;s:5:\"title\";s:17:\"Halloween Banner6\";s:10:\"created_at\";s:19:\"2020-10-21 14:22:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/Halloween-banner6-400x306.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:375;a:8:{s:2:\"id\";i:3192;s:5:\"title\";s:17:\"Halloween Banner7\";s:10:\"created_at\";s:19:\"2020-10-21 14:54:49\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/Halloween-banner7-400x267.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:376;a:8:{s:2:\"id\";i:3202;s:5:\"title\";s:17:\"Halloween Banner8\";s:10:\"created_at\";s:19:\"2020-10-21 15:23:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/halloween-banner8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-banner8-400x182.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"halloween\";}}i:377;a:8:{s:2:\"id\";i:3207;s:5:\"title\";s:14:\"Halloween CTA1\";s:10:\"created_at\";s:19:\"2020-10-21 15:30:03\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/halloween-cta1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-cta1-400x168.jpg\";s:4:\"tags\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:9:\"halloween\";}}i:378;a:8:{s:2:\"id\";i:3214;s:5:\"title\";s:10:\"Portfolio1\";s:10:\"created_at\";s:19:\"2020-10-25 10:29:25\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/portfolio1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/portfolio1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:379;a:8:{s:2:\"id\";i:3226;s:5:\"title\";s:7:\"Agency2\";s:10:\"created_at\";s:19:\"2020-10-25 10:32:41\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/agency2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/agency2-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:380;a:8:{s:2:\"id\";i:3239;s:5:\"title\";s:7:\"Agency3\";s:10:\"created_at\";s:19:\"2020-10-25 10:37:51\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/agency3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/agency3-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:381;a:8:{s:2:\"id\";i:3260;s:5:\"title\";s:13:\"Landing Page2\";s:10:\"created_at\";s:19:\"2020-10-25 10:47:50\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/landing-page2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/product2-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:382;a:8:{s:2:\"id\";i:3267;s:5:\"title\";s:8:\"Product1\";s:10:\"created_at\";s:19:\"2020-10-25 10:51:02\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/product1-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/product1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:383;a:8:{s:2:\"id\";i:3282;s:5:\"title\";s:9:\"Insurance\";s:10:\"created_at\";s:19:\"2020-10-25 10:59:02\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/insurance/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/insurance-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:384;a:8:{s:2:\"id\";i:3292;s:5:\"title\";s:9:\"Business1\";s:10:\"created_at\";s:19:\"2020-10-25 11:05:08\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/business1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/business1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:385;a:8:{s:2:\"id\";i:3302;s:5:\"title\";s:4:\"Gym1\";s:10:\"created_at\";s:19:\"2020-10-25 11:17:06\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:48:\"https://templates.happyaddons.com/template/gym1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:77:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/gym1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:386;a:8:{s:2:\"id\";i:3322;s:5:\"title\";s:13:\"Landing Page3\";s:10:\"created_at\";s:19:\"2020-10-25 11:20:00\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/landing-page3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/landing3-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:12:\"landing-page\";}}i:387;a:8:{s:2:\"id\";i:3338;s:5:\"title\";s:14:\"Landing Page 4\";s:10:\"created_at\";s:19:\"2020-10-25 11:25:27\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/landing-page-4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/landing4-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:12:\"landing-page\";}}i:388;a:8:{s:2:\"id\";i:3347;s:5:\"title\";s:14:\"Landing Page 5\";s:10:\"created_at\";s:19:\"2020-10-25 11:29:58\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/landing-page-5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/landing5-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:12:\"landing-page\";}}i:389;a:8:{s:2:\"id\";i:3359;s:5:\"title\";s:10:\"Corporate1\";s:10:\"created_at\";s:19:\"2020-10-25 11:36:03\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/corporate1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/corporate1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:390;a:8:{s:2:\"id\";i:3375;s:5:\"title\";s:9:\"LIstings1\";s:10:\"created_at\";s:19:\"2020-10-25 11:40:21\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/listings1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/listing1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:391;a:8:{s:2:\"id\";i:3381;s:5:\"title\";s:14:\"Subscribe Form\";s:10:\"created_at\";s:19:\"2020-10-25 11:56:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/subscribe-form/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/subscribe-form-400x123.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:392;a:8:{s:2:\"id\";i:3385;s:5:\"title\";s:8:\"Startup1\";s:10:\"created_at\";s:19:\"2020-10-25 12:03:32\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/startup1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/startup1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:393;a:8:{s:2:\"id\";i:3400;s:5:\"title\";s:7:\"Charity\";s:10:\"created_at\";s:19:\"2020-10-25 12:06:36\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/charity/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/charity-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:394;a:8:{s:2:\"id\";i:3417;s:5:\"title\";s:7:\"Fashion\";s:10:\"created_at\";s:19:\"2020-10-25 12:10:09\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/job-seek/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/fashion-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:395;a:8:{s:2:\"id\";i:3448;s:5:\"title\";s:17:\"Business Startup2\";s:10:\"created_at\";s:19:\"2020-10-25 12:17:10\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/business-startup2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/business-startup2-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:396;a:8:{s:2:\"id\";i:3455;s:5:\"title\";s:10:\"Portfolio3\";s:10:\"created_at\";s:19:\"2020-10-25 12:20:45\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/portfolio3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/portfolio3-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:397;a:8:{s:2:\"id\";i:3471;s:5:\"title\";s:9:\"Halloween\";s:10:\"created_at\";s:19:\"2020-10-25 13:08:52\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/halloween/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/10/halloween-page-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"halloween\";i:1;s:8:\"homepage\";}}i:398;a:8:{s:2:\"id\";i:3587;s:5:\"title\";s:12:\"Coming Soon1\";s:10:\"created_at\";s:19:\"2020-11-08 09:26:03\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/coming-soon-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/coming-soon1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"coming-soon\";}}i:399;a:8:{s:2:\"id\";i:3597;s:5:\"title\";s:12:\"Travelling 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:18:54\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/travelling-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/travel1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"travel\";}}i:400;a:8:{s:2:\"id\";i:3619;s:5:\"title\";s:14:\"Job Homepage 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:17:43\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/job-homepage-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/job-homepage1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:3:\"job\";}}i:401;a:8:{s:2:\"id\";i:3629;s:5:\"title\";s:11:\"Portfolio 2\";s:10:\"created_at\";s:19:\"2020-11-23 14:12:00\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/portfolio-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/portfolio2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:9:\"portfolio\";}}i:402;a:8:{s:2:\"id\";i:3641;s:5:\"title\";s:17:\"Interior Design 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:24:03\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/interior-design-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/interior1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:8:\"interior\";}}i:403;a:8:{s:2:\"id\";i:3652;s:5:\"title\";s:8:\"Agency 4\";s:10:\"created_at\";s:19:\"2020-11-23 17:17:27\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/agency-4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/agency4-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"agency\";i:1;s:8:\"homepage\";}}i:404;a:8:{s:2:\"id\";i:3667;s:5:\"title\";s:8:\"Agency 5\";s:10:\"created_at\";s:19:\"2020-11-08 19:34:20\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/agency-5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/agency-5-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"agency\";i:1;s:8:\"homepage\";}}i:405;a:8:{s:2:\"id\";i:3685;s:5:\"title\";s:13:\"Personal Site\";s:10:\"created_at\";s:19:\"2020-11-23 17:16:31\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/personal-site/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/personal-site-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:8:\"personal\";}}i:406;a:8:{s:2:\"id\";i:3712;s:5:\"title\";s:12:\"Car Dealer 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:08:46\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/car-dealer-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/car-dealer1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:10:\"car-dealer\";i:1;s:8:\"homepage\";}}i:407;a:8:{s:2:\"id\";i:3726;s:5:\"title\";s:19:\"Business Homepage 3\";s:10:\"created_at\";s:19:\"2020-11-23 17:15:45\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/business-homepage-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/business-homepage3-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:408;a:8:{s:2:\"id\";i:3738;s:5:\"title\";s:18:\"General Homepage 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:13:56\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/general-homepage-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/general-homepage1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:409;a:8:{s:2:\"id\";i:3749;s:5:\"title\";s:18:\"App Landing Page 1\";s:10:\"created_at\";s:19:\"2020-11-09 18:15:15\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/app-landing-page-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/app-landing1-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:11:\"app-landing\";i:1;s:8:\"homepage\";i:2;s:12:\"landing-page\";}}i:410;a:8:{s:2:\"id\";i:3773;s:5:\"title\";s:11:\"Portfolio 4\";s:10:\"created_at\";s:19:\"2020-11-09 19:31:47\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/portfolio-4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/portfolio-4-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:9:\"portfolio\";}}i:411;a:8:{s:2:\"id\";i:3799;s:5:\"title\";s:21:\"Restaurant Homepage 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:09:09\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:65:\"https://templates.happyaddons.com/template/restaurant-homepage-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:93:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/restaurant-homepage1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:10:\"restaurant\";}}i:412;a:8:{s:2:\"id\";i:3818;s:5:\"title\";s:17:\"Creative Design 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:13:31\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/creative-design-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/creative-design1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"creative\";i:1;s:8:\"homepage\";}}i:413;a:8:{s:2:\"id\";i:3833;s:5:\"title\";s:11:\"Portfolio 5\";s:10:\"created_at\";s:19:\"2020-11-16 13:58:04\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/portfolio-5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/portfolio-5-1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"portfolio\";}}i:414;a:8:{s:2:\"id\";i:3855;s:5:\"title\";s:19:\"Business Solution 4\";s:10:\"created_at\";s:19:\"2020-11-23 17:04:00\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/business-solution-4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/business-solution4-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:415;a:8:{s:2:\"id\";i:3866;s:5:\"title\";s:21:\"E-commerce Homepage 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:05:08\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:65:\"https://templates.happyaddons.com/template/e-commerce-homepage-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/ecommerce-home1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"ecommerce\";i:1;s:8:\"homepage\";}}i:416;a:8:{s:2:\"id\";i:3881;s:5:\"title\";s:21:\"E-commerce Homepage 2\";s:10:\"created_at\";s:19:\"2020-11-23 17:05:58\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:65:\"https://templates.happyaddons.com/template/e-commerce-homepage-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/ecommerce-home2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"ecommerce\";i:1;s:8:\"homepage\";}}i:417;a:8:{s:2:\"id\";i:3898;s:5:\"title\";s:9:\"Fashion 2\";s:10:\"created_at\";s:19:\"2020-11-23 17:06:48\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/fashion-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/fashion2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"fashion\";i:1;s:8:\"homepage\";}}i:418;a:8:{s:2:\"id\";i:3925;s:5:\"title\";s:14:\"Brand Design 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:07:16\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/brand-design-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/brand-design1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"branding\";i:1;s:8:\"homepage\";}}i:419;a:8:{s:2:\"id\";i:3939;s:5:\"title\";s:19:\"Business Homepage 5\";s:10:\"created_at\";s:19:\"2020-11-23 17:07:42\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/business-homepage-5/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/business-home5-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:420;a:8:{s:2:\"id\";i:3952;s:5:\"title\";s:14:\"Black Friday 1\";s:10:\"created_at\";s:19:\"2020-11-12 18:08:58\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/black-friday-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/black-friday-1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:12:\"black-friday\";}}i:421;a:8:{s:2:\"id\";i:3978;s:5:\"title\";s:14:\"Black Friday 2\";s:10:\"created_at\";s:19:\"2020-11-12 18:12:39\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/black-friday-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/blackfriday1-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:12:\"black-friday\";i:1;s:8:\"homepage\";i:2;s:12:\"landing-page\";}}i:422;a:8:{s:2:\"id\";i:4001;s:5:\"title\";s:14:\"Black Friday 3\";s:10:\"created_at\";s:19:\"2020-11-12 18:22:31\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/black-friday-3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/blackfriday3-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:12:\"black-friday\";i:1;s:8:\"homepage\";i:2;s:12:\"landing-page\";}}i:423;a:8:{s:2:\"id\";i:4017;s:5:\"title\";s:14:\"Cyber Monday 1\";s:10:\"created_at\";s:19:\"2020-11-12 18:28:52\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/cyber-monday-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/cybermonday1-400x549.jpg\";s:4:\"tags\";a:4:{i:0;s:12:\"black-friday\";i:1;s:12:\"cyber-monday\";i:2;s:8:\"homepage\";i:3;s:12:\"landing-page\";}}i:424;a:8:{s:2:\"id\";i:4029;s:5:\"title\";s:14:\"Cyber Monday 2\";s:10:\"created_at\";s:19:\"2020-11-12 18:35:41\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/cyber-monday-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/cybermonday2-400x549.jpg\";s:4:\"tags\";a:4:{i:0;s:12:\"black-friday\";i:1;s:12:\"cyber-monday\";i:2;s:8:\"homepage\";i:3;s:12:\"landing-page\";}}i:425;a:8:{s:2:\"id\";i:4112;s:5:\"title\";s:19:\"Parallax Homepage 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:08:01\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/parallax-homepage-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/parallax-home1-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:8:\"homepage\";}}i:426;a:8:{s:2:\"id\";i:4139;s:5:\"title\";s:19:\"Creative Homepage 2\";s:10:\"created_at\";s:19:\"2020-11-23 17:21:38\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/creative-homepage-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/creative-home2-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:8:\"business\";i:1;s:8:\"creative\";i:2;s:8:\"homepage\";}}i:427;a:8:{s:2:\"id\";i:4147;s:5:\"title\";s:15:\"Digital Trend 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:12:52\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/digital-trend-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/digital-trend1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:428;a:8:{s:2:\"id\";i:4158;s:5:\"title\";s:21:\"Gym Training Studio 1\";s:10:\"created_at\";s:19:\"2020-11-15 17:18:06\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:65:\"https://templates.happyaddons.com/template/gym-training-studio-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/gym-studio1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:3:\"gym\";i:1;s:8:\"homepage\";}}i:429;a:8:{s:2:\"id\";i:4170;s:5:\"title\";s:13:\"Art Gallery 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:20:07\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/art-gallery-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/art-gallery1-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:3:\"art\";i:1;s:8:\"creative\";i:2;s:8:\"homepage\";}}i:430;a:8:{s:2:\"id\";i:4184;s:5:\"title\";s:13:\"Gaming Site 2\";s:10:\"created_at\";s:19:\"2020-11-23 17:12:34\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/gaming-site-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/gameing-site2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:4:\"game\";i:1;s:8:\"homepage\";}}i:431;a:8:{s:2:\"id\";i:4206;s:5:\"title\";s:10:\"Cleaning 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:11:22\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/cleaning-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/cleaning1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"cleaning\";i:1;s:8:\"homepage\";}}i:432;a:8:{s:2:\"id\";i:4216;s:5:\"title\";s:19:\"Personal Homepage 2\";s:10:\"created_at\";s:19:\"2020-11-23 17:12:09\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/personal-homepage-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/personal-homepage2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:8:\"personal\";}}i:433;a:8:{s:2:\"id\";i:4236;s:5:\"title\";s:12:\"Restaurant 2\";s:10:\"created_at\";s:19:\"2020-11-15 20:43:28\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/restaurant2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:10:\"restaurant\";}}i:434;a:8:{s:2:\"id\";i:4267;s:5:\"title\";s:17:\"Creative Design 3\";s:10:\"created_at\";s:19:\"2020-11-23 13:42:26\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/creative-design-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/creative-design-3-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"creative\";i:1;s:8:\"homepage\";}}i:435;a:8:{s:2:\"id\";i:4297;s:5:\"title\";s:9:\"PetCare 1\";s:10:\"created_at\";s:19:\"2020-11-23 17:10:57\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/petcare-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/pet-care1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:3:\"pet\";}}i:436;a:8:{s:2:\"id\";i:4336;s:5:\"title\";s:11:\"Portfolio 6\";s:10:\"created_at\";s:19:\"2020-11-23 17:11:45\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/portfolio-6/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/portfolio6-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:9:\"portfolio\";}}i:437;a:8:{s:2:\"id\";i:4610;s:5:\"title\";s:8:\"Intro 16\";s:10:\"created_at\";s:19:\"2020-12-02 00:34:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/intro-16/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/intro16-400x179.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:438;a:8:{s:2:\"id\";i:4621;s:5:\"title\";s:9:\"Feature23\";s:10:\"created_at\";s:19:\"2020-12-02 00:42:16\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature23/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature23-400x179.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:439;a:8:{s:2:\"id\";i:4626;s:5:\"title\";s:10:\"Feature 24\";s:10:\"created_at\";s:19:\"2020-12-02 14:02:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-24/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature24-400x158.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:440;a:8:{s:2:\"id\";i:4634;s:5:\"title\";s:10:\"Feature 25\";s:10:\"created_at\";s:19:\"2020-12-02 15:14:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-25/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature25-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:441;a:8:{s:2:\"id\";i:4645;s:5:\"title\";s:10:\"Feature 26\";s:10:\"created_at\";s:19:\"2020-12-02 15:20:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-26/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature26-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:442;a:8:{s:2:\"id\";i:4657;s:5:\"title\";s:10:\"Feature 27\";s:10:\"created_at\";s:19:\"2020-12-02 15:35:59\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-27/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature27-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:443;a:8:{s:2:\"id\";i:4663;s:5:\"title\";s:9:\"Banner 18\";s:10:\"created_at\";s:19:\"2020-12-02 15:46:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/banner-18/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner-18-400x208.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:444;a:8:{s:2:\"id\";i:4674;s:5:\"title\";s:9:\"Banner 19\";s:10:\"created_at\";s:19:\"2020-12-02 16:20:22\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/banner-19/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner19-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:445;a:8:{s:2:\"id\";i:4680;s:5:\"title\";s:12:\"Fun Factor 9\";s:10:\"created_at\";s:19:\"2020-12-02 16:25:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/fun-factor-9/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/funfactor9-400x151.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:446;a:8:{s:2:\"id\";i:4685;s:5:\"title\";s:9:\"Banner 20\";s:10:\"created_at\";s:19:\"2020-12-02 16:30:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/banner-20/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner20-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:447;a:8:{s:2:\"id\";i:4694;s:5:\"title\";s:8:\"About 11\";s:10:\"created_at\";s:19:\"2020-12-02 16:40:00\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/about-11/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/about11-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:448;a:8:{s:2:\"id\";i:4713;s:5:\"title\";s:7:\"Team 20\";s:10:\"created_at\";s:19:\"2020-12-02 16:51:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/team-20/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:79:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/team20-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:4:\"team\";}}i:449;a:8:{s:2:\"id\";i:4725;s:5:\"title\";s:16:\"Pricing Table 12\";s:10:\"created_at\";s:19:\"2020-12-02 17:10:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/pricing-table-12/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/pricingtable12-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"pricing-table\";}}i:450;a:8:{s:2:\"id\";i:4739;s:5:\"title\";s:10:\"Feature 28\";s:10:\"created_at\";s:19:\"2020-12-02 19:38:10\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-28/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature28-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:451;a:8:{s:2:\"id\";i:4751;s:5:\"title\";s:8:\"Banner21\";s:10:\"created_at\";s:19:\"2020-12-03 17:25:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner21/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner-21-400x206.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:452;a:8:{s:2:\"id\";i:4760;s:5:\"title\";s:10:\"Feature 29\";s:10:\"created_at\";s:19:\"2020-12-04 01:40:51\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/feature-29/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature29-400x170.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:453;a:8:{s:2:\"id\";i:4768;s:5:\"title\";s:8:\"Banner22\";s:10:\"created_at\";s:19:\"2020-12-04 16:24:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner22/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner22-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:454;a:8:{s:2:\"id\";i:4783;s:5:\"title\";s:8:\"Banner23\";s:10:\"created_at\";s:19:\"2020-12-04 16:32:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner23/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner23-400x215.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:455;a:8:{s:2:\"id\";i:4792;s:5:\"title\";s:7:\"Intro17\";s:10:\"created_at\";s:19:\"2020-12-04 16:37:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/intro17/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/intro17-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:456;a:8:{s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Intro18\";s:10:\"created_at\";s:19:\"2020-12-04 17:13:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/intro18/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/intro18-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:457;a:8:{s:2:\"id\";i:4817;s:5:\"title\";s:7:\"Intro19\";s:10:\"created_at\";s:19:\"2020-12-04 17:16:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/intro19/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/intro19-400x153.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"intro-text\";}}i:458;a:8:{s:2:\"id\";i:4822;s:5:\"title\";s:8:\"Banner24\";s:10:\"created_at\";s:19:\"2020-12-04 17:38:06\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner24/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner24-400x197.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:459;a:8:{s:2:\"id\";i:4837;s:5:\"title\";s:9:\"Feature30\";s:10:\"created_at\";s:19:\"2020-12-04 17:51:26\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature30/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature30-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:460;a:8:{s:2:\"id\";i:4846;s:5:\"title\";s:5:\"CTA10\";s:10:\"created_at\";s:19:\"2020-12-04 18:14:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:49:\"https://templates.happyaddons.com/template/cta10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:78:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/cta10-400x123.jpg\";s:4:\"tags\";a:1:{i:0;s:14:\"call-to-action\";}}i:461;a:8:{s:2:\"id\";i:4855;s:5:\"title\";s:7:\"About12\";s:10:\"created_at\";s:19:\"2020-12-04 18:24:33\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:51:\"https://templates.happyaddons.com/template/about12/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:80:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/about12-400x173.jpg\";s:4:\"tags\";a:1:{i:0;s:5:\"about\";}}i:462;a:8:{s:2:\"id\";i:4864;s:5:\"title\";s:8:\"Service7\";s:10:\"created_at\";s:19:\"2020-12-04 18:58:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/service7-400x217.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:463;a:8:{s:2:\"id\";i:4872;s:5:\"title\";s:9:\"Feature31\";s:10:\"created_at\";s:19:\"2020-12-05 02:00:34\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature31/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature31-400x199.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:464;a:8:{s:2:\"id\";i:4880;s:5:\"title\";s:8:\"Banner25\";s:10:\"created_at\";s:19:\"2020-12-05 02:03:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner25/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner25-400x205.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:465;a:8:{s:2:\"id\";i:4886;s:5:\"title\";s:9:\"Product13\";s:10:\"created_at\";s:19:\"2020-12-05 02:07:15\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product13/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/product13-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:466;a:8:{s:2:\"id\";i:4900;s:5:\"title\";s:8:\"Banner26\";s:10:\"created_at\";s:19:\"2020-12-05 02:10:21\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner26/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner26-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:467;a:8:{s:2:\"id\";i:4908;s:5:\"title\";s:9:\"Product14\";s:10:\"created_at\";s:19:\"2020-12-05 02:48:31\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/product14-400x418.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:468;a:8:{s:2:\"id\";i:4920;s:5:\"title\";s:9:\"Product15\";s:10:\"created_at\";s:19:\"2020-12-06 13:16:08\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product15/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/product15-400x223.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:469;a:8:{s:2:\"id\";i:4932;s:5:\"title\";s:9:\"Product16\";s:10:\"created_at\";s:19:\"2020-12-08 00:45:38\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product16/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/product16-400x213.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:470;a:8:{s:2:\"id\";i:4942;s:5:\"title\";s:9:\"Feature32\";s:10:\"created_at\";s:19:\"2020-12-08 00:54:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature32/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature32-400x166.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:471;a:8:{s:2:\"id\";i:4952;s:5:\"title\";s:8:\"Client14\";s:10:\"created_at\";s:19:\"2020-12-08 01:03:46\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/client14/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/client14-400x197.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"client\";}}i:472;a:8:{s:2:\"id\";i:4962;s:5:\"title\";s:14:\"Black Friday 4\";s:10:\"created_at\";s:19:\"2020-12-08 01:08:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:58:\"https://templates.happyaddons.com/template/black-friday-4/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/11/blackfriday4-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:12:\"black-friday\";}}i:473;a:8:{s:2:\"id\";i:4976;s:5:\"title\";s:9:\"Contact10\";s:10:\"created_at\";s:19:\"2020-12-08 01:11:40\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/contact10/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/contact10-400x196.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:474;a:8:{s:2:\"id\";i:4981;s:5:\"title\";s:16:\"Content Block 27\";s:10:\"created_at\";s:19:\"2020-12-08 01:55:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/content-block-27/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/contentblock27-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:475;a:8:{s:2:\"id\";i:4988;s:5:\"title\";s:9:\"Feature33\";s:10:\"created_at\";s:19:\"2020-12-08 12:53:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature33/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature33-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:476;a:8:{s:2:\"id\";i:4993;s:5:\"title\";s:9:\"Feature34\";s:10:\"created_at\";s:19:\"2020-12-08 13:16:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature34/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature34-400x227.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:477;a:8:{s:2:\"id\";i:4999;s:5:\"title\";s:8:\"Banner27\";s:10:\"created_at\";s:19:\"2020-12-08 13:18:57\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner27/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner27-400x227.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:478;a:8:{s:2:\"id\";i:5006;s:5:\"title\";s:10:\"Blog Post1\";s:10:\"created_at\";s:19:\"2020-12-09 13:51:36\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/blog-post1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/blogpost1-400x121.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"blog-post\";}}i:479;a:8:{s:2:\"id\";i:5013;s:5:\"title\";s:13:\"Testimonial23\";s:10:\"created_at\";s:19:\"2020-12-09 15:19:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/testimonial23/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/testimonial23-400x175.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"testimonial\";}}i:480;a:8:{s:2:\"id\";i:5022;s:5:\"title\";s:16:\"Content Block 28\";s:10:\"created_at\";s:19:\"2020-12-09 15:46:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/content-block-28/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/contentblock28-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:13:\"content-block\";}}i:481;a:8:{s:2:\"id\";i:5028;s:5:\"title\";s:13:\"Image Block42\";s:10:\"created_at\";s:19:\"2020-12-09 15:52:09\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/image-block42/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/imageblog42-400x182.jpg\";s:4:\"tags\";a:1:{i:0;s:11:\"image-block\";}}i:482;a:8:{s:2:\"id\";i:5034;s:5:\"title\";s:9:\"Product17\";s:10:\"created_at\";s:19:\"2020-12-09 15:58:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/product17/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/product17-400x220.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"product\";}}i:483;a:8:{s:2:\"id\";i:5054;s:5:\"title\";s:8:\"Banner28\";s:10:\"created_at\";s:19:\"2020-12-09 16:01:50\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner28/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner28-400x221.jpg\";s:4:\"tags\";a:1:{i:0;s:6:\"banner\";}}i:484;a:8:{s:2:\"id\";i:5060;s:5:\"title\";s:9:\"Feature35\";s:10:\"created_at\";s:19:\"2020-12-09 17:16:01\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:53:\"https://templates.happyaddons.com/template/feature35/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/feature35-400x162.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"feature\";}}i:485;a:8:{s:2:\"id\";i:5067;s:5:\"title\";s:11:\"Blog Post 2\";s:10:\"created_at\";s:19:\"2020-12-09 17:19:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/blog-post-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:82:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/blogpost2-400x280.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"blog-post\";}}i:486;a:8:{s:2:\"id\";i:5075;s:5:\"title\";s:8:\"Service8\";s:10:\"created_at\";s:19:\"2020-12-09 17:27:24\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/service8/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/service8-400x222.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"service\";}}i:487;a:8:{s:2:\"id\";i:5081;s:5:\"title\";s:12:\"Fun Factor10\";s:10:\"created_at\";s:19:\"2020-12-09 17:43:10\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/fun-factor10/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/funfactor10-400x211.jpg\";s:4:\"tags\";a:1:{i:0;s:10:\"fun-factor\";}}i:488;a:8:{s:2:\"id\";i:5090;s:5:\"title\";s:10:\"Christmas5\";s:10:\"created_at\";s:19:\"2020-12-10 20:21:33\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/christmas5/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas5-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:9:\"christmas\";i:1;s:9:\"ecommerce\";i:2;s:12:\"landing-page\";}}i:489;a:8:{s:2:\"id\";i:5176;s:5:\"title\";s:20:\"Christmas Banner 001\";s:10:\"created_at\";s:19:\"2020-12-10 19:07:41\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:64:\"https://templates.happyaddons.com/template/christmas-banner-001/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-banner-1-400x200.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:490;a:8:{s:2:\"id\";i:5185;s:5:\"title\";s:11:\"Gift Shop 2\";s:10:\"created_at\";s:19:\"2020-12-22 18:43:54\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/gift-shop-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/gift-shop-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:8:\"homepage\";}}i:491;a:8:{s:2:\"id\";i:5202;s:5:\"title\";s:12:\"Restaurant 3\";s:10:\"created_at\";s:19:\"2020-12-22 15:40:15\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/restaurant-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:87:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/restaurant-3-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:8:\"homepage\";}}i:492;a:8:{s:2:\"id\";i:5226;s:5:\"title\";s:12:\"Car Agency 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:48:10\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/car-agency-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/car-agency-1-400x549.jpg\";s:4:\"tags\";a:4:{i:0;s:6:\"agency\";i:1;s:10:\"car-dealer\";i:2;s:9:\"christmas\";i:3;s:8:\"homepage\";}}i:493;a:8:{s:2:\"id\";i:5244;s:5:\"title\";s:12:\"Home Decor 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:02\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/home-decor-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:85:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/home-decor-1-400x549.jpg\";s:4:\"tags\";a:4:{i:0;s:6:\"agency\";i:1;s:9:\"christmas\";i:2;s:8:\"homepage\";i:3;s:8:\"interior\";}}i:494;a:8:{s:2:\"id\";i:5275;s:5:\"title\";s:12:\"Coming Soon9\";s:10:\"created_at\";s:19:\"2020-12-10 21:17:42\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/coming-soon9/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/comingsoon9-400x221.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:11:\"coming-soon\";}}i:495;a:8:{s:2:\"id\";i:5286;s:5:\"title\";s:15:\"Content Block29\";s:10:\"created_at\";s:19:\"2020-12-10 21:24:44\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/content-block29/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/content-block-29-400x189.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:13:\"content-block\";}}i:496;a:8:{s:2:\"id\";i:5332;s:5:\"title\";s:8:\"Banner29\";s:10:\"created_at\";s:19:\"2020-12-11 00:27:30\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/banner29/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:81:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/banner29-400x222.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:497;a:8:{s:2:\"id\";i:5348;s:5:\"title\";s:10:\"Christmas6\";s:10:\"created_at\";s:19:\"2020-12-22 18:40:58\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/christmas6/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-6-400x190.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:498;a:8:{s:2:\"id\";i:5352;s:5:\"title\";s:18:\"Christmas Banner 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/christmas-banner-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/chritmas-banner-1-400x177.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:499;a:8:{s:2:\"id\";i:5358;s:5:\"title\";s:18:\"Christmas Banner 2\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/christmas-banner-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-banner-2-400x172.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:500;a:8:{s:2:\"id\";i:5380;s:5:\"title\";s:22:\"Car dealer Testimonial\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:35\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:66:\"https://templates.happyaddons.com/template/car-dealer-testimonial/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:95:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/car-agency-testimonial-400x152.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"agency\";i:1;s:10:\"car-dealer\";i:2;s:11:\"testimonial\";}}i:501;a:8:{s:2:\"id\";i:5385;s:5:\"title\";s:20:\"Christmas Newsletter\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:45\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:64:\"https://templates.happyaddons.com/template/christmas-newsletter/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:93:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-newsletter-400x128.jpg\";s:4:\"tags\";a:1:{i:0;s:9:\"christmas\";}}i:502;a:8:{s:2:\"id\";i:5466;s:5:\"title\";s:19:\"Car Agency Banner 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:44:53\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/car-agency-banner-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:100:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/Christmas-Car-Agency-Banner-400x191.jpg\";s:4:\"tags\";a:4:{i:0;s:6:\"agency\";i:1;s:6:\"banner\";i:2;s:10:\"car-dealer\";i:3;s:9:\"christmas\";}}i:503;a:8:{s:2:\"id\";i:5475;s:5:\"title\";s:12:\"Price Menu 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:45:07\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/price-menu-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:93:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/price-menu-christmas-400x250.jpg\";s:4:\"tags\";a:3:{i:0;s:9:\"christmas\";i:1;s:10:\"price-menu\";i:2;s:10:\"restaurant\";}}i:504;a:8:{s:2:\"id\";i:5485;s:5:\"title\";s:15:\"Business Hour 1\";s:10:\"created_at\";s:19:\"2020-12-22 18:45:19\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/business-hour-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/Business-Hour-01-400x166.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"business-hour\";i:1;s:9:\"christmas\";}}i:505;a:8:{s:2:\"id\";i:5495;s:5:\"title\";s:17:\"Special Food menu\";s:10:\"created_at\";s:19:\"2020-12-22 18:41:05\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/special-food-menu/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:102:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-special-item-banner-400x192.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:10:\"restaurant\";}}i:506;a:8:{s:2:\"id\";i:5508;s:5:\"title\";s:18:\"Christmas banner 4\";s:10:\"created_at\";s:19:\"2020-12-22 18:41:14\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:62:\"https://templates.happyaddons.com/template/christmas-banner-4/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:91:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-banner-4-400x229.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:9:\"christmas\";}}i:507;a:8:{s:2:\"id\";i:5519;s:5:\"title\";s:19:\"Christmas Pricing 1\";s:10:\"created_at\";s:19:\"2020-12-20 23:27:12\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/christmas-pricing-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:92:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-pricing-1-400x254.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:13:\"pricing-table\";}}i:508;a:8:{s:2:\"id\";i:5533;s:5:\"title\";s:19:\"Christmas Pricing 2\";s:10:\"created_at\";s:19:\"2020-12-21 16:09:20\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:63:\"https://templates.happyaddons.com/template/christmas-pricing-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:92:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-pricing-2-400x271.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:13:\"pricing-table\";}}i:509;a:8:{s:2:\"id\";i:5547;s:5:\"title\";s:25:\"Christmas Pricing Table 3\";s:10:\"created_at\";s:19:\"2020-12-22 18:48:18\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:69:\"https://templates.happyaddons.com/template/christmas-pricing-table-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:98:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/christmas-pricing-table-3-400x285.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:13:\"pricing-table\";}}i:510;a:8:{s:2:\"id\";i:5607;s:5:\"title\";s:11:\"Portfolio 7\";s:10:\"created_at\";s:19:\"2020-12-31 12:53:45\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/portfolio-7/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/portfolio-7-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"homepage\";i:1;s:9:\"portfolio\";}}i:511;a:8:{s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Branding 2\";s:10:\"created_at\";s:19:\"2020-12-31 13:02:34\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/branding-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/branding-2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"branding\";i:1;s:8:\"homepage\";}}i:512;a:8:{s:2:\"id\";i:5645;s:5:\"title\";s:15:\"Beauty saloon 1\";s:10:\"created_at\";s:19:\"2020-12-31 13:19:26\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/beauty-saloon-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/beauty-saloon-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:13:\"beauty-saloon\";i:1;s:8:\"homepage\";}}i:513;a:8:{s:2:\"id\";i:5670;s:5:\"title\";s:13:\"Hair Saloon 1\";s:10:\"created_at\";s:19:\"2020-12-31 15:44:10\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:57:\"https://templates.happyaddons.com/template/hair-saloon-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:86:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/hair-saloon-1-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:11:\"hair-saloon\";i:1;s:8:\"homepage\";}}i:514;a:8:{s:2:\"id\";i:5700;s:5:\"title\";s:17:\"New Year Banner 1\";s:10:\"created_at\";s:19:\"2020-12-31 18:28:17\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:61:\"https://templates.happyaddons.com/template/new-year-banner-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:90:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/new-year-banner-1-400x188.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"banner\";i:1;s:8:\"new-year\";}}i:515;a:8:{s:2:\"id\";i:5710;s:5:\"title\";s:16:\"Hosting agency 1\";s:10:\"created_at\";s:19:\"2020-12-31 15:57:44\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/hosting-agency-1/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/hosting-agency-1-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"agency\";i:1;s:8:\"homepage\";i:2;s:8:\"new-year\";}}i:516;a:8:{s:2:\"id\";i:5731;s:5:\"title\";s:16:\"Hosting Agency 2\";s:10:\"created_at\";s:19:\"2020-12-31 16:03:41\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:60:\"https://templates.happyaddons.com/template/hosting-agency-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:89:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/hosting-agency-2-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"agency\";i:1;s:8:\"homepage\";i:2;s:8:\"new-year\";}}i:517;a:8:{s:2:\"id\";i:5746;s:5:\"title\";s:15:\"New Year Sale 1\";s:10:\"created_at\";s:19:\"2020-12-31 18:20:11\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/new-year-sale-1/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/new-year-sale-1-400x273.png\";s:4:\"tags\";a:3:{i:0;s:6:\"banner\";i:1;s:8:\"new-year\";i:2;s:5:\"sales\";}}i:518;a:8:{s:2:\"id\";i:5753;s:5:\"title\";s:15:\"New Year Sale 2\";s:10:\"created_at\";s:19:\"2020-12-31 18:23:47\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/new-year-sale-2/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/new-year-sale-2-400x196.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"banner\";i:1;s:8:\"new-year\";i:2;s:5:\"sales\";}}i:519;a:8:{s:2:\"id\";i:5760;s:5:\"title\";s:15:\"New Year Sale 3\";s:10:\"created_at\";s:19:\"2020-12-31 18:26:27\";s:4:\"type\";s:7:\"section\";s:3:\"url\";s:59:\"https://templates.happyaddons.com/template/new-year-sale-3/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:88:\"https://templates.happyaddons.com/wp-content/uploads/2020/12/new-year-sale-3-400x202.jpg\";s:4:\"tags\";a:3:{i:0;s:6:\"banner\";i:1;s:8:\"new-year\";i:2;s:5:\"sales\";}}i:520;a:8:{s:2:\"id\";i:5773;s:5:\"title\";s:11:\"Corporate 2\";s:10:\"created_at\";s:19:\"2021-06-02 17:11:40\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/corporate-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2021/06/Corporate-2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:521;a:8:{s:2:\"id\";i:5804;s:5:\"title\";s:11:\"Corporate 3\";s:10:\"created_at\";s:19:\"2021-06-03 20:24:36\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:55:\"https://templates.happyaddons.com/template/corporate-3/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:84:\"https://templates.happyaddons.com/wp-content/uploads/2021/06/corporate-3-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";}}i:522;a:8:{s:2:\"id\";i:5826;s:5:\"title\";s:10:\"Justice 01\";s:10:\"created_at\";s:19:\"2021-06-22 13:40:34\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/justice-01/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2021/06/justice-01-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:7:\"justice\";i:1;s:3:\"law\";}}i:523;a:8:{s:2:\"id\";i:5845;s:5:\"title\";s:10:\"Justice 02\";s:10:\"created_at\";s:19:\"2021-07-07 18:41:01\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/justice-02/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2021/07/justice-02-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:6:\"agency\";i:1;s:3:\"law\";}}i:524;a:8:{s:2:\"id\";i:5864;s:5:\"title\";s:8:\"Law Firm\";s:10:\"created_at\";s:19:\"2021-07-26 18:16:53\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:52:\"https://templates.happyaddons.com/template/law-firm/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2021/07/justice-03-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:8:\"homepage\";i:1;s:7:\"justice\";i:2;s:3:\"law\";}}i:525;a:8:{s:2:\"id\";i:5882;s:5:\"title\";s:10:\"WallStreet\";s:10:\"created_at\";s:19:\"2021-07-27 18:20:46\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/wallstreet/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2021/07/wallstreet-400x549.jpg\";s:4:\"tags\";a:3:{i:0;s:8:\"business\";i:1;s:8:\"homepage\";i:2;s:9:\"marketing\";}}i:526;a:8:{s:2:\"id\";i:5904;s:5:\"title\";s:12:\"Contact page\";s:10:\"created_at\";s:19:\"2021-07-29 18:05:11\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/contact-page/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:83:\"https://templates.happyaddons.com/wp-content/uploads/2021/07/contact-us-400x549.jpg\";s:4:\"tags\";a:1:{i:0;s:7:\"contact\";}}i:527;a:8:{s:2:\"id\";i:8892;s:5:\"title\";s:10:\"Christmas6\";s:10:\"created_at\";s:19:\"2021-12-05 18:53:21\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:56:\"https://templates.happyaddons.com/template/christmas6-2/\";s:6:\"is_pro\";b:1;s:9:\"thumbnail\";s:93:\"https://templates.happyaddons.com/wp-content/uploads/2021/12/christmas-cozy-gift2-400x549.jpg\";s:4:\"tags\";a:2:{i:0;s:9:\"christmas\";i:1;s:12:\"landing-page\";}}i:528;a:8:{s:2:\"id\";i:9141;s:5:\"title\";s:10:\"Christmas7\";s:10:\"created_at\";s:19:\"2021-12-13 12:28:31\";s:4:\"type\";s:4:\"page\";s:3:\"url\";s:54:\"https://templates.happyaddons.com/template/christmas7/\";s:6:\"is_pro\";b:0;s:9:\"thumbnail\";s:97:\"https://templates.happyaddons.com/wp-content/uploads/2021/12/christmas-cozy-gift-free-400x549.jpg\";s:4:\"tags\";a:0:{}}}s:4:\"tags\";a:59:{s:5:\"about\";s:5:\"About\";s:6:\"agency\";s:6:\"Agency\";s:11:\"app-landing\";s:11:\"App Landing\";s:3:\"art\";s:3:\"Art\";s:6:\"banner\";s:6:\"Banner\";s:13:\"beauty-saloon\";s:13:\"beauty saloon\";s:12:\"black-friday\";s:12:\"Black Friday\";s:9:\"blog-post\";s:9:\"Blog Post\";s:8:\"branding\";s:8:\"Branding\";s:8:\"business\";s:8:\"Business\";s:13:\"business-hour\";s:13:\"Business Hour\";s:14:\"call-to-action\";s:14:\"Call to Action\";s:10:\"car-dealer\";s:10:\"Car Dealer\";s:9:\"christmas\";s:9:\"Christmas\";s:8:\"cleaning\";s:8:\"Cleaning\";s:6:\"client\";s:6:\"Client\";s:11:\"coming-soon\";s:11:\"Coming Soon\";s:7:\"contact\";s:7:\"Contact\";s:13:\"content-block\";s:13:\"Content Block\";s:8:\"creative\";s:8:\"Creative\";s:12:\"cyber-monday\";s:12:\"Cyber Monday\";s:9:\"ecommerce\";s:9:\"Ecommerce\";s:9:\"error-404\";s:9:\"Error 404\";s:3:\"faq\";s:3:\"FAQ\";s:7:\"fashion\";s:7:\"Fashion\";s:7:\"feature\";s:7:\"Feature\";s:6:\"footer\";s:6:\"Footer\";s:10:\"fun-factor\";s:10:\"fun factor\";s:7:\"gallery\";s:7:\"Gallery\";s:4:\"game\";s:4:\"Game\";s:3:\"gym\";s:3:\"Gym\";s:11:\"hair-saloon\";s:11:\"Hair Saloon\";s:9:\"halloween\";s:9:\"Halloween\";s:8:\"homepage\";s:8:\"Homepage\";s:11:\"image-block\";s:11:\"image block\";s:8:\"interior\";s:8:\"Interior\";s:10:\"intro-text\";s:10:\"Intro Text\";s:3:\"job\";s:3:\"Job\";s:7:\"justice\";s:7:\"Justice\";s:12:\"landing-page\";s:12:\"Landing Page\";s:3:\"law\";s:3:\"Law\";s:9:\"marketing\";s:9:\"Marketing\";s:14:\"medical-health\";s:20:\"Medical &amp; Health\";s:5:\"music\";s:5:\"Music\";s:8:\"new-year\";s:8:\"New Year\";s:8:\"parallax\";s:8:\"Parallax\";s:8:\"personal\";s:8:\"Personal\";s:3:\"pet\";s:3:\"Pet\";s:9:\"portfolio\";s:9:\"Portfolio\";s:10:\"price-menu\";s:10:\"Price Menu\";s:13:\"pricing-table\";s:13:\"Pricing Table\";s:7:\"product\";s:7:\"Product\";s:10:\"restaurant\";s:10:\"Restaurant\";s:5:\"sales\";s:5:\"Sales\";s:7:\"service\";s:7:\"Service\";s:4:\"team\";s:4:\"Team\";s:11:\"testimonial\";s:11:\"Testimonial\";s:6:\"travel\";s:6:\"Travel\";s:5:\"video\";s:5:\"Video\";}s:9:\"type_tags\";a:2:{s:7:\"section\";a:36:{i:0;s:6:\"banner\";i:1;s:5:\"music\";i:2;s:5:\"sales\";i:3;s:7:\"feature\";i:4;s:11:\"image-block\";i:5;s:7:\"product\";i:6;s:10:\"intro-text\";i:7;s:8:\"parallax\";i:8;s:7:\"service\";i:9;s:5:\"about\";i:10;s:10:\"fun-factor\";i:11;s:4:\"team\";i:12;s:13:\"content-block\";i:13;s:6:\"client\";i:14;s:14:\"call-to-action\";i:15;s:3:\"faq\";i:16;s:9:\"marketing\";i:17;s:7:\"contact\";i:18;s:5:\"video\";i:19;s:7:\"gallery\";i:20;s:11:\"coming-soon\";i:21;s:6:\"footer\";i:22;s:10:\"restaurant\";i:23;s:14:\"medical-health\";i:24;s:11:\"testimonial\";i:25;s:13:\"business-hour\";i:26;s:10:\"price-menu\";i:27;s:13:\"pricing-table\";i:28;s:9:\"error-404\";i:29;s:9:\"halloween\";i:30;s:12:\"black-friday\";i:31;s:9:\"blog-post\";i:32;s:9:\"christmas\";i:33;s:6:\"agency\";i:34;s:10:\"car-dealer\";i:35;s:8:\"new-year\";}s:4:\"page\";a:33:{i:0;s:12:\"landing-page\";i:1;s:8:\"homepage\";i:2;s:8:\"business\";i:3;s:9:\"halloween\";i:4;s:11:\"coming-soon\";i:5;s:6:\"travel\";i:6;s:3:\"job\";i:7;s:9:\"portfolio\";i:8;s:8:\"interior\";i:9;s:6:\"agency\";i:10;s:8:\"personal\";i:11;s:10:\"car-dealer\";i:12;s:11:\"app-landing\";i:13;s:10:\"restaurant\";i:14;s:8:\"creative\";i:15;s:9:\"ecommerce\";i:16;s:7:\"fashion\";i:17;s:8:\"branding\";i:18;s:12:\"black-friday\";i:19;s:12:\"cyber-monday\";i:20;s:3:\"gym\";i:21;s:3:\"art\";i:22;s:4:\"game\";i:23;s:8:\"cleaning\";i:24;s:3:\"pet\";i:25;s:9:\"christmas\";i:26;s:13:\"beauty-saloon\";i:27;s:11:\"hair-saloon\";i:28;s:8:\"new-year\";i:29;s:7:\"justice\";i:30;s:3:\"law\";i:31;s:9:\"marketing\";i:32;s:7:\"contact\";}}}", "off");
INSERT INTO `JQx2cw4_options` VALUES("1109", "pa_elements_01d595335", "a:0:{}", "off");
INSERT INTO `JQx2cw4_options` VALUES("1110", "pa_edit_01d595335", "1767777557", "off");
INSERT INTO `JQx2cw4_options` VALUES("1136", "astra-color-palettes", "a:5:{s:14:\"currentPalette\";s:9:\"palette_1\";s:8:\"palettes\";a:4:{s:9:\"palette_1\";a:9:{i:0;s:7:\"#046bd2\";i:1;s:7:\"#045cb4\";i:2;s:7:\"#1e293b\";i:3;s:7:\"#334155\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F0F5FA\";i:6;s:7:\"#111111\";i:7;s:7:\"#D1D5DB\";i:8;s:7:\"#111111\";}s:9:\"palette_2\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#364151\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#E7F6FF\";i:6;s:7:\"#070614\";i:7;s:7:\"#D1DAE5\";i:8;s:7:\"#222222\";}s:9:\"palette_3\";a:9:{i:0;s:7:\"#6528F7\";i:1;s:7:\"#5511F8\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F2F0FE\";i:6;s:7:\"#0D0614\";i:7;s:7:\"#D8D8F5\";i:8;s:7:\"#222222\";}s:9:\"palette_4\";a:9:{i:0;s:7:\"#0085FF\";i:1;s:7:\"#0177E3\";i:2;s:7:\"#FFFFFF\";i:3;s:7:\"#E7F6FF\";i:4;s:7:\"#212A37\";i:5;s:7:\"#0F172A\";i:6;s:7:\"#4F5B62\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}}s:7:\"presets\";a:11:{s:3:\"Oak\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#364151\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#E7F6FF\";i:6;s:7:\"#070614\";i:7;s:7:\"#D1DAE5\";i:8;s:7:\"#222222\";}s:5:\"Viola\";a:9:{i:0;s:7:\"#6528F7\";i:1;s:7:\"#5511F8\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F2F0FE\";i:6;s:7:\"#0D0614\";i:7;s:7:\"#D8D8F5\";i:8;s:7:\"#222222\";}s:5:\"Cedar\";a:9:{i:0;s:7:\"#DD183B\";i:1;s:7:\"#CC1939\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#3A3A3A\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FFEDE6\";i:6;s:7:\"#140609\";i:7;s:7:\"#FFD1BF\";i:8;s:7:\"#222222\";}s:6:\"Willow\";a:9:{i:0;s:7:\"#54B435\";i:1;s:7:\"#379237\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#2F3B40\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#EDFBE2\";i:6;s:7:\"#0C1406\";i:7;s:7:\"#D5EAD8\";i:8;s:7:\"#222222\";}s:4:\"Lily\";a:9:{i:0;s:7:\"#DCA54A\";i:1;s:7:\"#D09A40\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#4A4A4A\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FAF5E5\";i:6;s:7:\"#141004\";i:7;s:7:\"#F0E6C5\";i:8;s:7:\"#222222\";}s:4:\"Rose\";a:9:{i:0;s:7:\"#FB5FAB\";i:1;s:7:\"#EA559D\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FCEEF5\";i:6;s:7:\"#140610\";i:7;s:7:\"#FAD8E9\";i:8;s:7:\"#222222\";}s:4:\"Sage\";a:9:{i:0;s:7:\"#1B9C85\";i:1;s:7:\"#178E79\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#EDF6EE\";i:6;s:7:\"#06140C\";i:7;s:7:\"#D4F3D7\";i:8;s:7:\"#222222\";}s:5:\"Flare\";a:9:{i:0;s:7:\"#FD9800\";i:1;s:7:\"#E98C00\";i:2;s:7:\"#0F172A\";i:3;s:7:\"#454F5E\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FEF9E1\";i:6;s:7:\"#141006\";i:7;s:7:\"#F9F0C8\";i:8;s:7:\"#222222\";}s:5:\"Maple\";a:9:{i:0;s:7:\"#FF6210\";i:1;s:7:\"#F15808\";i:2;s:7:\"#1C0D0A\";i:3;s:7:\"#353535\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#FEF1E4\";i:6;s:7:\"#140B06\";i:7;s:7:\"#E5D7D1\";i:8;s:7:\"#222222\";}s:5:\"Birch\";a:9:{i:0;s:7:\"#737880\";i:1;s:7:\"#65696F\";i:2;s:7:\"#151616\";i:3;s:7:\"#393C40\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#F6F6F6\";i:6;s:7:\"#232529\";i:7;s:7:\"#F1F0F0\";i:8;s:7:\"#222222\";}s:4:\"Dark\";a:9:{i:0;s:7:\"#0085FF\";i:1;s:7:\"#0177E3\";i:2;s:7:\"#FFFFFF\";i:3;s:7:\"#E7F6FF\";i:4;s:7:\"#212A37\";i:5;s:7:\"#0F172A\";i:6;s:7:\"#4F5B62\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}}s:11:\"presetNames\";a:4:{s:9:\"palette_1\";N;s:9:\"palette_2\";s:3:\"Oak\";s:9:\"palette_3\";s:5:\"Viola\";s:9:\"palette_4\";s:4:\"Dark\";}s:4:\"flag\";b:1;}", "on");
INSERT INTO `JQx2cw4_options` VALUES("1175", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:20:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:20:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:20:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:20:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:20:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:20:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:20:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:20:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:20:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:20:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:20:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:20:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:20:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:20:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:20:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:20:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:20:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:20:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:20:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:20:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:20:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:20:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:20:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:20:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:20:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:20:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:20:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:20:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:20:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:20:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:20:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:20:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:20:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:20:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:20:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:20:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:20:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:20:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:20:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:20:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:20:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:20:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:20:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:20:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:20:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:20:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:20:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:20:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:20:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:20:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:20:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:20:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:20:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:20:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:20:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:20:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:20:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:20:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:20:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:20:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:20:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:20:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:20:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:20:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:20:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:20:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:20:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:20:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:20:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:20:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:20:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:20:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:20:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:20:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:20:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:20:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:20:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:20:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:20:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:20:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:20:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:20:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:20:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:20:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:20:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:20:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:20:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:20:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:20:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:20:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:20:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:20:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:20:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:20:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:20:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:20:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:20:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:20:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:20:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:20:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:20:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:20:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:20:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:20:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:20:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:20:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:20:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:20:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:20:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:20:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:20:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:20:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:20:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:20:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:20:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:20:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:20:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:20:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:20:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:20:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:20:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:20:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:20:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:20:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:20:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:20:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:20:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:20:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:20:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:20:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:20:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:20:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:20:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:20:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:20:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:20:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:20:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:20:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:20:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:20:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:20:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:20:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:20:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:20:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:20:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:20:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:20:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:20:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:20:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:20:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:20:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:20:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:20:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:20:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:20:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:20:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:20:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:20:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:20:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:20:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:20:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:20:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:20:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:20:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:20:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:20:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:20:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:20:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:20:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:20:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:20:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:20:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:20:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:20:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:20:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:20:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:20:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:20:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:20:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:20:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:20:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:20:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:20:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:20:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:20:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:20:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:20:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:20:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:20:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:20:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:20:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:20:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:20:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:20:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:20:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:20:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:20:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:20:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:20:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:20:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:20:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:20:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:20:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:20:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:20:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:20:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:20:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:20:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:20:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:20:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:20:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:20:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:20:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:20:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:20:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:20:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:20:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:20:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:20:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:20:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:20:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:20:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:20:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:20:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:20:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:20:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:20:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:20:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:20:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:20:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:20:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:20:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:20:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:20:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:20:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:20:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:20:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:20:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:20:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:20:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:20:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:20:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:20:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:20:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:20:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:20:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:20:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:20:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:20:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:20:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:20:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:20:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:20:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:20:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:20:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:20:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:20:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:20:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:20:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:20:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:20:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:20:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:20:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:20:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:20:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:20:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:20:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:20:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:20:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:20:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:20:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:20:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:20:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:20:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s: